/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.deployment.DeploymentSorter;
import org.jboss.logging.Logger;

public final class SuffixOrderHelper {
    public static final String[] DEFAULT_ENHANCED_SUFFIXES = new String[0];
    public static final int DEFAULT_RELATIVE_ORDER = 850;
    public static final Logger log = Logger.getLogger((Class)SuffixOrderHelper.class);
    private final DeploymentSorter sorter;
    private String[] enhancedSuffixes;
    private List suffixes;
    private Set staticSuffixes;

    public SuffixOrderHelper(DeploymentSorter sorter) {
        this.sorter = sorter;
        this.suffixes = new ArrayList();
        this.staticSuffixes = new HashSet();
    }

    public String[] getSuffixOrder() {
        return this.sorter.getSuffixOrder();
    }

    public String[] getEnhancedSuffixes() {
        return this.enhancedSuffixes;
    }

    public void setEnhancedSuffixes(String[] enhancedSuffixes) {
        this.enhancedSuffixes = enhancedSuffixes;
    }

    public void initialize() {
        if (this.enhancedSuffixes == null) {
            this.enhancedSuffixes = DEFAULT_ENHANCED_SUFFIXES;
        }
        this.suffixes.clear();
        this.staticSuffixes.clear();
        for (int i = 0; i < this.enhancedSuffixes.length; ++i) {
            EnhancedSuffix es = new EnhancedSuffix(this.enhancedSuffixes[i]);
            this.addSuffix(es);
            this.staticSuffixes.add(es.suffix);
        }
        this.sorter.setSuffixOrder(this.produceSuffixOrder());
    }

    public void addEnhancedSuffixes(String[] enhancedSuffixes) {
        if (enhancedSuffixes != null) {
            int size = this.suffixes.size();
            for (int i = 0; i < enhancedSuffixes.length; ++i) {
                EnhancedSuffix es = new EnhancedSuffix(enhancedSuffixes[i]);
                this.addSuffix(es);
            }
            if (this.suffixes.size() > size) {
                this.sorter.setSuffixOrder(this.produceSuffixOrder());
            }
        }
    }

    public void addSuffixes(String[] suffixes, int relativeOrder) {
        if (suffixes != null) {
            int size = this.suffixes.size();
            for (int i = 0; i < suffixes.length; ++i) {
                this.addSuffix(new EnhancedSuffix(suffixes[i], relativeOrder));
            }
            if (this.suffixes.size() > size) {
                this.sorter.setSuffixOrder(this.produceSuffixOrder());
            }
        }
    }

    public void removeEnhancedSuffixes(String[] enhancedSuffixes) {
        if (enhancedSuffixes != null) {
            int size = this.suffixes.size();
            for (int i = 0; i < enhancedSuffixes.length; ++i) {
                EnhancedSuffix es = new EnhancedSuffix(enhancedSuffixes[i]);
                if (this.staticSuffixes.contains(es.suffix)) continue;
                this.suffixes.remove(es);
            }
            if (this.suffixes.size() < size) {
                this.sorter.setSuffixOrder(this.produceSuffixOrder());
            }
        }
    }

    public void removeSuffixes(String[] suffixes, int relativeOrder) {
        if (suffixes != null) {
            int size = this.suffixes.size();
            for (int i = 0; i < suffixes.length; ++i) {
                if (this.staticSuffixes.contains(suffixes[i])) continue;
                this.suffixes.remove(new EnhancedSuffix(suffixes[i], relativeOrder));
            }
            if (this.suffixes.size() < size) {
                this.sorter.setSuffixOrder(this.produceSuffixOrder());
            }
        }
    }

    private String[] produceSuffixOrder() {
        String[] suffixOrder = new String[this.suffixes.size()];
        for (int i = 0; i < this.suffixes.size(); ++i) {
            suffixOrder[i] = ((EnhancedSuffix)this.suffixes.get((int)i)).suffix;
        }
        return suffixOrder;
    }

    private void addSuffix(EnhancedSuffix enhancedSuffix) {
        if (this.staticSuffixes.contains(enhancedSuffix.suffix)) {
            log.debug((Object)("Static suffix exists; ignoring request for adding enhanced suffix: " + enhancedSuffix));
        } else {
            int size = this.suffixes.size();
            if (size == 0) {
                this.suffixes.add(enhancedSuffix);
            } else {
                for (int i = size - 1; i > -1; --i) {
                    EnhancedSuffix entry = (EnhancedSuffix)this.suffixes.get(i);
                    if (enhancedSuffix.order >= entry.order) {
                        this.suffixes.add(i + 1, enhancedSuffix);
                        break;
                    }
                    if (i != 0) continue;
                    this.suffixes.add(0, enhancedSuffix);
                }
            }
        }
    }

    public static final class EnhancedSuffix {
        public String suffix;
        public int order;

        public EnhancedSuffix(String suffix, int order) {
            this.suffix = suffix;
            this.order = order;
        }

        public EnhancedSuffix(String enhancedSuffix) throws IllegalArgumentException {
            StringTokenizer tokenizer = new StringTokenizer(enhancedSuffix, ":");
            int tokens = tokenizer.countTokens();
            switch (tokens) {
                case 1: {
                    this.order = 850;
                    this.suffix = enhancedSuffix;
                    break;
                }
                case 2: {
                    this.order = Integer.parseInt(tokenizer.nextToken());
                    this.suffix = tokenizer.nextToken();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot parse enhancedSuffix: " + enhancedSuffix);
                }
            }
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof EnhancedSuffix)) {
                return false;
            }
            EnhancedSuffix that = (EnhancedSuffix)other;
            return this.suffix.equals(that.suffix) && this.order == that.order;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.suffix.hashCode();
            result = 37 * result + this.order;
            return result;
        }

        public String toString() {
            return this.order + ":" + this.suffix;
        }
    }
}

