/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache.tree;

import java.util.HashMap;
import java.util.Map;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.ejb3.cache.tree.PassivationEvictionPolicy;
import org.jboss.ejb3.stateful.StatefulBeanContext;

public class StatefulEvictionPolicy
extends PassivationEvictionPolicy {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evict(Fqn fqn) throws Exception {
        if (fqn.size() == 2) {
            Node node = this.cache_.get(fqn);
            if (node == null) {
                return;
            }
            StatefulBeanContext bean = null;
            Map data = node.getData();
            if (data != null) {
                bean = (StatefulBeanContext)data.get("bean");
            }
            if (bean == null) {
                this.superEvict(fqn);
                return;
            }
            StatefulBeanContext statefulBeanContext = bean;
            synchronized (statefulBeanContext) {
                if (bean.inUse) {
                    bean.markedForPassivation = true;
                    this.superEvict(fqn);
                    return;
                }
                this.superEvict(fqn);
                this.passivate(node, bean);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passivate(Node node, StatefulBeanContext bean) throws Exception {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            bean.prePassivate();
            this.fileCacheLoader.put(node.getFqn(), node.getData(), true);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passivate(Fqn fqn, StatefulBeanContext bean) throws Exception {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            bean.prePassivate();
            HashMap<String, StatefulBeanContext> map = new HashMap<String, StatefulBeanContext>();
            map.put("bean", bean);
            this.fileCacheLoader.put(fqn, map, true);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }
}

