/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.SimpleProperty;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLBaseProperty;

public class SQLSimpleProperty
extends SQLBaseProperty {
    public static final String DC_ISSUED = "dc:issued";
    protected static final Set<String> VERSION_WRITABLE_PROPS = new HashSet<String>(Arrays.asList("ecm:binaryText", "ecm:lifeCycleState", "dc:issued"));
    private final SimpleProperty property;

    public SQLSimpleProperty(SimpleProperty property, Type type, boolean readonly) {
        super(type, readonly);
        this.property = property;
    }

    public String getName() {
        return this.property.getName();
    }

    public Serializable getValue() throws DocumentException {
        try {
            return this.property.getValue();
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    public void setValue(Object value) throws DocumentException {
        if (!VERSION_WRITABLE_PROPS.contains(this.getName())) {
            this.checkWritable();
        }
        if (value != null && !(value instanceof Serializable)) {
            throw new DocumentException("Value is not Serializable: " + value);
        }
        try {
            this.property.setValue((Serializable)value);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }
}

