/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.Credentials;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.ModelSetup;
import org.nuxeo.ecm.core.storage.sql.RepositoryBackend;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.jdbc.ClusterNodeHandler;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCMapper;
import org.nuxeo.ecm.core.storage.sql.jdbc.SQLInfo;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.runtime.api.Framework;

public class JDBCBackend
implements RepositoryBackend {
    private static final Log log = LogFactory.getLog(JDBCBackend.class);
    private RepositoryImpl repository;
    private XADataSource xadatasource;
    private Dialect dialect;
    private SQLInfo sqlInfo;
    private ClusterNodeHandler clusterNodeHandler;

    @Override
    public void initialize(RepositoryImpl repository) throws StorageException {
        Object instance;
        Class<?> klass;
        this.repository = repository;
        RepositoryDescriptor repositoryDescriptor = repository.getRepositoryDescriptor();
        String className = repositoryDescriptor.xaDataSourceName;
        try {
            klass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new StorageException("Unknown class: " + className, e);
        }
        try {
            instance = klass.newInstance();
        }
        catch (Exception e) {
            throw new StorageException("Cannot instantiate class: " + className, e);
        }
        if (!(instance instanceof XADataSource)) {
            throw new StorageException("Not a XADataSource: " + className);
        }
        this.xadatasource = (XADataSource)instance;
        for (Map.Entry<String, String> entry : repositoryDescriptor.properties.entrySet()) {
            String name = entry.getKey();
            String value = Framework.expandVars((String)entry.getValue());
            if (name.contains("/")) {
                name = name.substring(0, name.indexOf(47));
            }
            if (Character.isLowerCase(name.charAt(1))) {
                name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            }
            try {
                BeanUtils.setProperty((Object)this.xadatasource, (String)name, (Object)value);
            }
            catch (Exception e) {
                log.error((Object)String.format("Cannot set %s = %s", name, value));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeModelSetup(ModelSetup modelSetup) throws StorageException {
        try {
            XAConnection xaconnection = this.xadatasource.getXAConnection();
            Connection connection = null;
            try {
                connection = xaconnection.getConnection();
                this.dialect = Dialect.createDialect(connection, this.repository.getBinaryManager(), this.repository.getRepositoryDescriptor());
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
                xaconnection.close();
            }
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
        modelSetup.materializeFulltextSyntheticColumn = this.dialect.getMaterializeFulltextSyntheticColumn();
    }

    @Override
    public void initializeModel(Model model) throws StorageException {
        this.sqlInfo = new SQLInfo(this.repository, model, this.dialect);
    }

    @Override
    public Mapper newMapper(Model model, Session.PathResolver pathResolver, Credentials credentials, boolean create) throws StorageException {
        JDBCMapper mapper = this.createMapper(model, pathResolver);
        if (create) {
            if (this.repository.getRepositoryDescriptor().noDDL) {
                log.info((Object)"Skipping database creation");
            } else {
                mapper.createDatabase();
            }
            RepositoryDescriptor repositoryDescriptor = this.repository.getRepositoryDescriptor();
            if (repositoryDescriptor.clusteringEnabled) {
                log.info((Object)("Clustering enabled with " + repositoryDescriptor.clusteringDelay + " ms delay for repository: " + this.repository.getName()));
                this.clusterNodeHandler = new ClusterNodeHandler(mapper, repositoryDescriptor);
                mapper = this.createMapper(model, pathResolver);
            }
        }
        return mapper;
    }

    protected JDBCMapper createMapper(Model model, Session.PathResolver pathResolver) throws StorageException {
        return new JDBCMapper(model, pathResolver, this.sqlInfo, this.xadatasource, this.clusterNodeHandler);
    }

    @Override
    public void shutdown() throws StorageException {
        if (this.clusterNodeHandler != null) {
            this.clusterNodeHandler.close();
        }
    }
}

