/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyId;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.JaxBHelper;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringImpl;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomEntryParser {
    private static final String TAG_ENTRY = "entry";
    private static final String TAG_TITLE = "title";
    private static final String TAG_OBJECT = "object";
    private static final String TAG_CONTENT = "content";
    private static final String TAG_BASE64 = "base64";
    private static final String TAG_MEDIATYPE = "mediatype";
    private static final String ATTR_SRC = "src";
    private static final String ATTR_TYPE = "type";
    private ObjectData fObject;
    private ContentStreamImpl fAtomContentStream;
    private ContentStreamImpl fCmisContentStream;

    public AtomEntryParser() {
    }

    public AtomEntryParser(InputStream stream) throws Exception {
        this.parse(stream);
    }

    public ObjectData getObject() {
        return this.fObject;
    }

    public Properties getProperties() {
        return this.fObject == null ? null : this.fObject.getProperties();
    }

    public String getId() {
        Properties properties = this.getProperties();
        if (properties == null) {
            return null;
        }
        Map propertiesMap = properties.getProperties();
        if (propertiesMap == null) {
            return null;
        }
        PropertyData property = (PropertyData)propertiesMap.get("cmis:objectId");
        if (property instanceof PropertyId) {
            return (String)((PropertyId)property).getFirstValue();
        }
        return null;
    }

    public Acl getAcl() {
        return this.fObject == null ? null : this.fObject.getAcl();
    }

    public List<String> getPolicyIds() {
        if (this.fObject == null || this.fObject.getPolicyIds() == null) {
            return null;
        }
        return this.fObject.getPolicyIds().getPolicyIds();
    }

    public ContentStream getContentStream() {
        return this.fCmisContentStream == null ? this.fAtomContentStream : this.fCmisContentStream;
    }

    public void parse(InputStream stream) throws Exception {
        this.fObject = null;
        this.fAtomContentStream = null;
        this.fCmisContentStream = null;
        if (stream == null) {
            return;
        }
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader parser = factory.createXMLStreamReader(stream);
        do {
            int event;
            if ((event = parser.getEventType()) != 1) continue;
            QName name = parser.getName();
            if ("http://www.w3.org/2005/Atom".equals(name.getNamespaceURI()) && TAG_ENTRY.equals(name.getLocalPart())) {
                this.parseEntry(parser);
                break;
            }
            throw new CmisInvalidArgumentException("XML is not an Atom entry!");
        } while (this.next(parser));
        parser.close();
    }

    private void parseEntry(XMLStreamReader parser) throws Exception {
        String atomTitle = null;
        this.next(parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                QName name = parser.getName();
                if ("http://docs.oasis-open.org/ns/cmis/restatom/200908/".equals(name.getNamespaceURI())) {
                    if (TAG_OBJECT.equals(name.getLocalPart())) {
                        this.parseObject(parser);
                        continue;
                    }
                    if (TAG_CONTENT.equals(name.getLocalPart())) {
                        this.parseCmisContent(parser);
                        continue;
                    }
                    this.skip(parser);
                    continue;
                }
                if ("http://www.w3.org/2005/Atom".equals(name.getNamespaceURI())) {
                    if (TAG_CONTENT.equals(name.getLocalPart())) {
                        this.parseAtomContent(parser);
                        continue;
                    }
                    if (TAG_TITLE.equals(name.getLocalPart())) {
                        atomTitle = this.readText(parser);
                        continue;
                    }
                    this.skip(parser);
                    continue;
                }
                this.skip(parser);
                continue;
            }
            if (event == 2 || !this.next(parser)) break;
        }
        if (this.fObject != null && this.fObject.getProperties() != null && atomTitle != null && atomTitle.length() > 0) {
            PropertyStringImpl nameProperty = new PropertyStringImpl("cmis:name", atomTitle);
            ((PropertiesImpl)this.fObject.getProperties()).replaceProperty((PropertyData)nameProperty);
        }
    }

    private void parseObject(XMLStreamReader parser) throws Exception {
        Unmarshaller u = JaxBHelper.createUnmarshaller();
        JAXBElement object = u.unmarshal(parser, CmisObjectType.class);
        if (object != null) {
            this.fObject = Converter.convert((CmisObjectType)((CmisObjectType)object.getValue()));
        }
    }

    private void parseAtomContent(XMLStreamReader parser) throws Exception {
        this.fAtomContentStream = new ContentStreamImpl();
        String type = "text";
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            QName attrName = parser.getAttributeName(i);
            if (ATTR_TYPE.equals(attrName.getLocalPart())) {
                this.fAtomContentStream.setMimeType(parser.getAttributeValue(i));
                if (parser.getAttributeValue(i) == null) continue;
                type = parser.getAttributeValue(i).trim().toLowerCase();
                continue;
            }
            if (!ATTR_SRC.equals(attrName.getLocalPart())) continue;
            throw new CmisNotSupportedException("External content not supported!");
        }
        byte[] bytes = null;
        bytes = type.equals("text") || type.equals("html") ? this.readText(parser).getBytes("UTF-8") : (type.equals("xhtml") ? this.copy(parser) : (type.endsWith("/xml") || type.endsWith("+xml") ? this.copy(parser) : (type.startsWith("text/") ? this.readText(parser).getBytes("UTF-8") : Base64.decodeBase64((String)this.readText(parser)))));
        if (bytes != null) {
            this.fAtomContentStream.setStream((InputStream)new ByteArrayInputStream(bytes));
            this.fAtomContentStream.setLength(BigInteger.valueOf(bytes.length));
        }
    }

    private void parseCmisContent(XMLStreamReader parser) throws Exception {
        this.fCmisContentStream = new ContentStreamImpl();
        this.next(parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                QName name = parser.getName();
                if ("http://docs.oasis-open.org/ns/cmis/restatom/200908/".equals(name.getNamespaceURI())) {
                    if (TAG_MEDIATYPE.equals(name.getLocalPart())) {
                        this.fCmisContentStream.setMimeType(this.readText(parser));
                        continue;
                    }
                    if (TAG_BASE64.equals(name.getLocalPart())) {
                        byte[] bytes = Base64.decodeBase64((String)this.readText(parser));
                        this.fCmisContentStream.setStream((InputStream)new ByteArrayInputStream(bytes));
                        this.fCmisContentStream.setLength(BigInteger.valueOf(bytes.length));
                        continue;
                    }
                    this.skip(parser);
                    continue;
                }
                this.skip(parser);
                continue;
            }
            if (event == 2 || !this.next(parser)) break;
        }
        this.next(parser);
    }

    private String readText(XMLStreamReader parser) throws Exception {
        int event;
        StringBuilder sb = new StringBuilder();
        this.next(parser);
        while ((event = parser.getEventType()) != 2) {
            if (event == 4) {
                String s = parser.getText();
                if (s != null) {
                    sb.append(s);
                }
            } else if (event == 1) {
                throw new RuntimeException("Unexpected tag: " + parser.getName());
            }
            if (this.next(parser)) continue;
            break;
        }
        this.next(parser);
        return sb.toString();
    }

    private byte[] copy(XMLStreamReader parser) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(out);
        writer.writeStartDocument();
        int level = 1;
        while (this.next(parser)) {
            int event = parser.getEventType();
            if (event == 1) {
                this.copyStartElement(parser, writer);
                ++level;
                continue;
            }
            if (event == 4) {
                writer.writeCharacters(parser.getText());
                continue;
            }
            if (event == 5) {
                writer.writeComment(parser.getText());
                continue;
            }
            if (event == 12) {
                writer.writeCData(parser.getText());
                continue;
            }
            if (event != 2 || --level == 0) break;
            writer.writeEndElement();
        }
        writer.writeEndDocument();
        this.next(parser);
        return out.toByteArray();
    }

    private void copyStartElement(XMLStreamReader parser, XMLStreamWriter writer) throws Exception {
        int i;
        String namespaceUri = parser.getNamespaceURI();
        String prefix = parser.getPrefix();
        String localName = parser.getLocalName();
        if (namespaceUri != null) {
            if (prefix == null || prefix.length() == 0) {
                writer.writeStartElement(localName);
            } else {
                writer.writeStartElement(prefix, localName, namespaceUri);
            }
        } else {
            writer.writeStartElement(localName);
        }
        for (i = 0; i < parser.getNamespaceCount(); ++i) {
            this.addNamespace(writer, parser.getNamespacePrefix(i), parser.getNamespaceURI(i));
        }
        this.addNamespaceIfMissing(writer, prefix, namespaceUri);
        for (i = 0; i < parser.getAttributeCount(); ++i) {
            String attrNamespaceUri = parser.getAttributeNamespace(i);
            String attrPrefix = parser.getAttributePrefix(i);
            String attrName = parser.getAttributeLocalName(i);
            String attrValue = parser.getAttributeValue(i);
            if (attrNamespaceUri == null || attrNamespaceUri.trim().length() == 0) {
                writer.writeAttribute(attrName, attrValue);
                continue;
            }
            if (attrPrefix == null || attrPrefix.trim().length() == 0) {
                writer.writeAttribute(attrNamespaceUri, attrName, attrValue);
                continue;
            }
            this.addNamespaceIfMissing(writer, attrPrefix, attrNamespaceUri);
            writer.writeAttribute(attrPrefix, attrNamespaceUri, attrName, attrValue);
        }
    }

    private void addNamespaceIfMissing(XMLStreamWriter writer, String prefix, String namespaceUri) throws Exception {
        Iterator<String> iter;
        if (namespaceUri == null || namespaceUri.trim().length() == 0) {
            return;
        }
        if (prefix == null) {
            prefix = "";
        }
        if ((iter = writer.getNamespaceContext().getPrefixes(namespaceUri)) == null) {
            return;
        }
        while (iter.hasNext()) {
            String p = iter.next();
            if (p == null || !p.equals(prefix)) continue;
            return;
        }
        this.addNamespace(writer, prefix, namespaceUri);
    }

    private void addNamespace(XMLStreamWriter writer, String prefix, String namespaceUri) throws Exception {
        if (prefix == null || prefix.trim().length() == 0) {
            writer.setDefaultNamespace(namespaceUri);
            writer.writeDefaultNamespace(namespaceUri);
        } else {
            writer.setPrefix(prefix, namespaceUri);
            writer.writeNamespace(prefix, namespaceUri);
        }
    }

    private void skip(XMLStreamReader parser) throws Exception {
        int level = 1;
        while (this.next(parser)) {
            int event = parser.getEventType();
            if (event == 1) {
                ++level;
                continue;
            }
            if (event != 2 || --level != 0) continue;
            break;
        }
        this.next(parser);
    }

    private boolean next(XMLStreamReader parser) throws Exception {
        if (parser.hasNext()) {
            try {
                parser.next();
            }
            catch (XMLStreamException e) {
                return false;
            }
            return true;
        }
        return false;
    }
}

