/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.webservices;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthHandler
implements SOAPHandler<SOAPMessageContext> {
    private static final String WSSE_NS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private static final QName WSSE_SECURITY = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
    private static final QName WSSE_USERNAME_TOKEN = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken");
    private static final QName WSSE_USERNAME = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Username");
    private static final QName WSSE_PASSWORD = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Password");
    private static final Set<QName> HEADERS = new HashSet<QName>();

    public Set<QName> getHeaders() {
        return HEADERS;
    }

    public void close(MessageContext context) {
    }

    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    public boolean handleMessage(SOAPMessageContext context) {
        Boolean outboundProperty = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
        if (outboundProperty.booleanValue()) {
            return true;
        }
        try {
            SOAPMessage msg = context.getMessage();
            SOAPHeader sh = msg.getSOAPHeader();
            SOAPElement securityElement = (SOAPElement)sh.getChildElements(WSSE_SECURITY).next();
            SOAPElement tokenElement = (SOAPElement)securityElement.getChildElements(WSSE_USERNAME_TOKEN).next();
            SOAPElement userElement = (SOAPElement)tokenElement.getChildElements(WSSE_USERNAME).next();
            SOAPElement passwordElement = (SOAPElement)tokenElement.getChildElements(WSSE_PASSWORD).next();
            HashMap<String, String> callContextMap = new HashMap<String, String>();
            callContextMap.put("useranme", userElement.getValue());
            callContextMap.put("password", passwordElement.getValue());
            context.put((Object)"org.apache.chemistry.opencmis.callcontext", callContextMap);
            context.setScope("org.apache.chemistry.opencmis.callcontext", MessageContext.Scope.APPLICATION);
        }
        catch (Exception e) {
            throw new RuntimeException("UsernameToken not set!", e);
        }
        return true;
    }

    static {
        HEADERS.add(WSSE_SECURITY);
    }
}

