/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs;

import java.io.IOException;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.doc.JSONExporter;
import org.nuxeo.ecm.automation.core.impl.OperationTypeImpl;
import org.nuxeo.ecm.automation.server.jaxrs.ExecutableResource;
import org.nuxeo.ecm.automation.server.jaxrs.ExecutionRequest;

public class OperationResource
extends ExecutableResource {
    protected OperationType type;

    public OperationResource(AutomationService service, OperationType type) {
        super(service);
        this.type = type;
    }

    @GET
    @Produces(value={"application/json"})
    public Object doGet() {
        try {
            OperationDocumentation doc = ((OperationTypeImpl)this.type).getDocumentation();
            JSONObject json = JSONExporter.toJSON((OperationDocumentation)doc);
            return Response.ok((Object)json.toString(2)).type("application/json").build();
        }
        catch (IOException e) {
            return Response.status((int)500).build();
        }
    }

    @Override
    public Object execute(ExecutionRequest xreq) throws Exception {
        OperationContext ctx = xreq.createContext(this.request, this.getCoreSession());
        return this.service.run(ctx, xreq.createChain(this.type));
    }

    @Override
    public String getId() {
        return this.type.getId();
    }

    @Override
    public boolean isChain() {
        return false;
    }
}

