/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ArrayProperty;
import org.nuxeo.ecm.core.api.model.impl.ComplexProperty;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.utils.DateParser;
import org.nuxeo.ecm.webengine.WebException;

@Provider
@Produces(value={"application/json+nxentity", "application/json"})
public class JsonDocumentWriter
implements MessageBodyWriter<DocumentModel> {
    @Context
    protected HttpHeaders headers;

    public long getSize(DocumentModel arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4) {
        return -1L;
    }

    public boolean isWriteable(Class<?> arg0, Type arg1, Annotation[] arg2, MediaType arg3) {
        return DocumentModel.class.isAssignableFrom(arg0);
    }

    public void writeTo(DocumentModel doc, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4, MultivaluedMap<String, Object> arg5, OutputStream arg6) throws IOException, WebApplicationException {
        try {
            List props = this.headers.getRequestHeader("X-NXDocumentProperties");
            JSONObject obj = null;
            obj = props == null || props.isEmpty() ? JsonDocumentWriter.getJSON(doc, null) : JsonDocumentWriter.getJSON(doc, StringUtils.split((String)((String)props.get(0)), (char)',', (boolean)true));
            arg6.write(obj.toString(2).getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    public static JSONObject getJSON(DocumentModel doc, String[] schemas) throws Exception {
        JSONObject json = new JSONObject();
        json.element("entity-type", (Object)"document");
        json.element("repository", (Object)doc.getRepositoryName());
        json.element("uid", (Object)doc.getId());
        json.element("path", (Object)doc.getPathAsString());
        json.element("type", (Object)doc.getType());
        json.element("state", (Object)doc.getCurrentLifeCycleState());
        json.element("lock", (Object)doc.getLock());
        json.element("title", (Object)doc.getTitle());
        Calendar cal = (Calendar)doc.getPart("dublincore").getValue("modified");
        if (cal != null) {
            json.element("lastModified", (Object)DateParser.formatW3CDateTime((Date)cal.getTime()));
        }
        if (schemas == null || schemas.length == 0) {
            return json;
        }
        JSONObject props = new JSONObject();
        if (schemas.length == 1 && "*".equals(schemas[0])) {
            for (String schema : doc.getDeclaredSchemas()) {
                JsonDocumentWriter.addSchema(props, doc, schema);
            }
        } else {
            for (String schema : schemas) {
                JsonDocumentWriter.addSchema(props, doc, schema);
            }
        }
        json.element("properties", (Map)props);
        return json;
    }

    protected static void addSchema(JSONObject json, DocumentModel doc, String schema) throws Exception {
        DocumentPart part = doc.getPart(schema);
        if (part == null) {
            return;
        }
        String prefix = part.getSchema().getNamespace().prefix;
        if (prefix == null || prefix.length() == 0) {
            prefix = schema;
        }
        prefix = prefix + ':';
        String filesBaseUrl = "files/" + doc.getId() + "?path=";
        for (Property p : part.getChildren()) {
            json.element(prefix + p.getField().getName().getLocalName(), JsonDocumentWriter.propertyToJsonValue(filesBaseUrl, p));
        }
    }

    protected static Object propertyToJsonValue(String filesBaseUrl, Property prop) throws Exception {
        org.nuxeo.ecm.core.schema.types.Type type = prop.getType();
        if (prop.isScalar()) {
            Serializable v = prop.getValue();
            if (v == null) {
                return JSONNull.getInstance();
            }
            return type.encode((Object)v);
        }
        if (prop.isList()) {
            if (prop instanceof ArrayProperty) {
                Object[] ar = (Object[])prop.getValue();
                if (ar == null) {
                    return new JSONArray();
                }
                JSONArray jsar = new JSONArray();
                for (Object o : ar) {
                    jsar.add((Object)((ListType)type).getFieldType().encode(o));
                }
                return jsar;
            }
            ListProperty listp = (ListProperty)prop;
            JSONArray jsar = new JSONArray();
            for (Property p : listp.getChildren()) {
                jsar.add(JsonDocumentWriter.propertyToJsonValue(filesBaseUrl, p));
            }
            return jsar;
        }
        if (prop.isPhantom()) {
            return JSONNull.getInstance();
        }
        if (prop instanceof BlobProperty) {
            Blob blob = (Blob)((BlobProperty)prop).getValue();
            JSONObject jsob = new JSONObject();
            String v = blob.getFilename();
            jsob.element("name", v == null ? JSONNull.getInstance() : v);
            v = blob.getMimeType();
            jsob.element("mime-type", v == null ? JSONNull.getInstance() : v);
            v = blob.getEncoding();
            jsob.element("encoding", v == null ? JSONNull.getInstance() : v);
            v = blob.getDigest();
            jsob.element("digest", v == null ? JSONNull.getInstance() : v);
            v = Long.toString(blob.getLength());
            jsob.element("length", (Object)v);
            jsob.element("data", (Object)(filesBaseUrl + URLEncoder.encode(prop.getPath(), "UTF-8")));
            return jsob;
        }
        ComplexProperty cp = (ComplexProperty)prop;
        if (prop.isPhantom()) {
            return JSONNull.getInstance();
        }
        JSONObject jsob = new JSONObject();
        for (Property p : cp.getChildren()) {
            jsob.put((Object)p.getName(), JsonDocumentWriter.propertyToJsonValue(filesBaseUrl, p));
        }
        return jsob;
    }
}

