/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.jmx;

import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.javasimon.CallbackSkeleton;
import org.javasimon.Counter;
import org.javasimon.Simon;
import org.javasimon.Stopwatch;
import org.javasimon.jmx.CounterMXBeanImpl;
import org.javasimon.jmx.SimonSuperMXBean;
import org.javasimon.jmx.StopwatchMXBeanImpl;

public class JmxRegisterCallback
extends CallbackSkeleton {
    private MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
    private Set<String> registeredNames = new HashSet<String>();

    public void simonCreated(Simon simon) {
        if (simon.getName() == null) {
            return;
        }
        if (simon instanceof Counter) {
            this.register(new CounterMXBeanImpl((Counter)simon));
        } else if (simon instanceof Stopwatch) {
            this.register(new StopwatchMXBeanImpl((Stopwatch)simon));
        } else {
            this.warning("Unknown type of Simon! " + simon, null);
        }
    }

    public void simonDestroyed(Simon simon) {
        String name = simon.getName();
        try {
            ObjectName objectName = new ObjectName(name);
            this.mBeanServer.unregisterMBean(objectName);
            this.registeredNames.remove(name);
            this.message("Unregistered Simon with the name: " + objectName);
        }
        catch (JMException e) {
            this.warning("JMX unregistration failed for: " + name, e);
        }
    }

    public void clear() {
        Iterator<String> namesIter = this.registeredNames.iterator();
        while (namesIter.hasNext()) {
            String name = namesIter.next();
            try {
                ObjectName objectName = new ObjectName(name);
                this.mBeanServer.unregisterMBean(objectName);
                namesIter.remove();
                this.message("Unregistered Simon with the name: " + objectName);
            }
            catch (JMException e) {
                this.warning("JMX unregistration failed for: " + name, e);
            }
        }
    }

    private void register(SimonSuperMXBean simonMxBean) {
        String name = this.constructObjectName(simonMxBean);
        try {
            ObjectName objectName = new ObjectName(name);
            if (this.mBeanServer.isRegistered(objectName)) {
                this.mBeanServer.unregisterMBean(objectName);
            } else {
                this.registeredNames.add(name);
            }
            this.mBeanServer.registerMBean(simonMxBean, objectName);
            this.message("Simon registered under the name: " + objectName);
        }
        catch (JMException e) {
            this.warning("JMX registration failed for: " + name, e);
            this.registeredNames.remove(name);
        }
    }

    protected String constructObjectName(SimonSuperMXBean simonMxBean) {
        return simonMxBean.getName() + ":type=" + simonMxBean.getType();
    }
}

