/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.ImageWindow;
import ij.gui.Plot;
import ij.gui.ProfilePlot;
import ij.plugin.filter.Analyzer;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Button;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.CharArrayWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;

public class PlotWindow
extends ImageWindow
implements ActionListener,
ClipboardOwner {
    public static final int CIRCLE = 0;
    public static final int X = 1;
    public static final int BOX = 3;
    public static final int TRIANGLE = 4;
    public static final int CROSS = 5;
    public static final int LINE = 2;
    private static final int WIDTH = 450;
    private static final int HEIGHT = 200;
    private static final String MIN = "pp.min";
    private static final String MAX = "pp.max";
    private static final String PLOT_WIDTH = "pp.width";
    private static final String PLOT_HEIGHT = "pp.height";
    private static final String OPTIONS = "pp.options";
    private static final int SAVE_X_VALUES = 1;
    private static final int AUTO_CLOSE = 2;
    private static final int LIST_VALUES = 4;
    private static final int INTERPOLATE = 8;
    private static final int NO_GRID_LINES = 16;
    private Button list;
    private Button save;
    private Button copy;
    private Label coordinates;
    private static String defaultDirectory = null;
    private Font font = new Font("Helvetica", 0, 12);
    private static int options;
    private int defaultDigits = -1;
    private boolean realXValues;
    private int xdigits;
    private int ydigits;
    private int markSize = 5;
    private static Plot staticPlot;
    private Plot plot;
    public static boolean saveXValues;
    public static boolean autoClose;
    public static int plotWidth;
    public static int plotHeight;
    public static boolean listValues;
    public static boolean interpolate;
    public static boolean noGridLines;

    public PlotWindow(String title, String xLabel, String yLabel, float[] xValues, float[] yValues) {
        super(PlotWindow.createImage(title, xLabel, yLabel, xValues, yValues));
        this.plot = staticPlot;
    }

    public PlotWindow(String title, String xLabel, String yLabel, double[] xValues, double[] yValues) {
        this(title, xLabel, yLabel, Tools.toFloat(xValues), Tools.toFloat(yValues));
    }

    PlotWindow(Plot plot) {
        super(plot.getImagePlus());
        this.plot = plot;
        this.draw();
    }

    static ImagePlus createImage(String title, String xLabel, String yLabel, float[] xValues, float[] yValues) {
        staticPlot = new Plot(title, xLabel, yLabel, xValues, yValues);
        return new ImagePlus(title, staticPlot.getBlankProcessor());
    }

    public void setLimits(double xMin, double xMax, double yMin, double yMax) {
        this.plot.setLimits(xMin, xMax, yMin, yMax);
    }

    public void addPoints(float[] x, float[] y, int shape) {
        this.plot.addPoints(x, y, shape);
    }

    public void addPoints(double[] x, double[] y, int shape) {
        this.addPoints(Tools.toFloat(x), Tools.toFloat(y), shape);
    }

    public void addErrorBars(float[] errorBars) {
        this.plot.addErrorBars(errorBars);
    }

    public void addLabel(double x, double y, String label) {
        this.plot.addLabel(x, y, label);
    }

    public void setColor(Color c) {
        this.plot.setColor(c);
    }

    public void setLineWidth(int lineWidth) {
        this.plot.setLineWidth(lineWidth);
    }

    public void changeFont(Font font) {
        this.plot.changeFont(font);
    }

    public void draw() {
        Panel buttons = new Panel();
        buttons.setLayout(new FlowLayout(2));
        this.list = new Button(" List ");
        this.list.addActionListener(this);
        buttons.add(this.list);
        this.save = new Button("Save...");
        this.save.addActionListener(this);
        buttons.add(this.save);
        this.copy = new Button("Copy...");
        this.copy.addActionListener(this);
        buttons.add(this.copy);
        this.coordinates = new Label("X=12345678, Y=12345678");
        this.coordinates.setFont(new Font("Monospaced", 0, 12));
        buttons.add(this.coordinates);
        this.add(buttons);
        this.plot.draw();
        this.pack();
        this.coordinates.setText("");
        ImageProcessor ip = this.plot.getProcessor();
        if (ip instanceof ColorProcessor && this.imp.getProcessor() instanceof ByteProcessor) {
            this.imp.setProcessor(null, ip);
        } else {
            this.imp.updateAndDraw();
        }
        if (listValues) {
            this.showList();
        }
    }

    int getDigits(double n1, double n2) {
        if ((double)Math.round(n1) == n1 && (double)Math.round(n2) == n2) {
            return 0;
        }
        double n = (n1 = Math.abs(n1)) < (n2 = Math.abs(n2)) && n1 > 0.0 ? n1 : n2;
        double diff = Math.abs(n2 - n1);
        if (diff > 0.0 && diff < n) {
            n = diff;
        }
        int digits = 1;
        if (n < 10.0) {
            digits = 2;
        }
        if (n < 0.01) {
            digits = 3;
        }
        if (n < 0.001) {
            digits = 4;
        }
        if (n < 1.0E-4) {
            digits = 5;
        }
        return digits;
    }

    public void mouseMoved(int x, int y) {
        super.mouseMoved(x, y);
        if (this.plot != null && this.plot.frame != null && this.coordinates != null) {
            this.coordinates.setText(this.plot.getCoordinates(x, y));
        }
    }

    void showList() {
        String headings;
        StringBuffer sb = new StringBuffer();
        this.initDigits();
        if (this.plot.errorBars != null) {
            headings = saveXValues ? "X\tY\tErrorBar" : "Y\tErrorBar";
            for (int i = 0; i < this.plot.nPoints; ++i) {
                if (saveXValues) {
                    sb.append(IJ.d2s(this.plot.xValues[i], this.xdigits) + "\t" + IJ.d2s(this.plot.yValues[i], this.ydigits) + "\t" + IJ.d2s(this.plot.errorBars[i], this.ydigits) + "\n");
                    continue;
                }
                sb.append(IJ.d2s(this.plot.yValues[i], this.ydigits) + "\t" + IJ.d2s(this.plot.errorBars[i], this.ydigits) + "\n");
            }
        } else {
            headings = saveXValues ? "X\tY" : "Y";
            for (int i = 0; i < this.plot.nPoints; ++i) {
                if (saveXValues) {
                    sb.append(IJ.d2s(this.plot.xValues[i], this.xdigits) + "\t" + IJ.d2s(this.plot.yValues[i], this.ydigits) + "\n");
                    continue;
                }
                sb.append(IJ.d2s(this.plot.yValues[i], this.ydigits) + "\n");
            }
        }
        TextWindow tw = new TextWindow("Plot Values", headings, sb.toString(), 200, 400);
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    void saveAsText() {
        String directory;
        FileDialog fd = new FileDialog((Frame)this, "Save as Text...", 1);
        if (defaultDirectory != null) {
            fd.setDirectory(defaultDirectory);
        }
        fd.show();
        String name = fd.getFile();
        defaultDirectory = directory = fd.getDirectory();
        fd.dispose();
        PrintWriter pw = null;
        try {
            FileOutputStream fos = new FileOutputStream(directory + name);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            pw = new PrintWriter(bos);
        }
        catch (IOException e) {
            IJ.error("" + e);
            return;
        }
        IJ.wait(250);
        IJ.showStatus("Saving plot values...");
        this.initDigits();
        for (int i = 0; i < this.plot.nPoints; ++i) {
            if (saveXValues) {
                pw.println(IJ.d2s(this.plot.xValues[i], this.xdigits) + "\t" + IJ.d2s(this.plot.yValues[i], this.ydigits));
                continue;
            }
            pw.println(IJ.d2s(this.plot.yValues[i], this.ydigits));
        }
        pw.close();
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    void copyToClipboard() {
        Clipboard systemClipboard = null;
        try {
            systemClipboard = this.getToolkit().getSystemClipboard();
        }
        catch (Exception e) {
            systemClipboard = null;
        }
        if (systemClipboard == null) {
            IJ.error("Unable to copy to Clipboard.");
            return;
        }
        IJ.showStatus("Copying plot values...");
        this.initDigits();
        CharArrayWriter aw = new CharArrayWriter(this.plot.nPoints * 4);
        PrintWriter pw = new PrintWriter(aw);
        for (int i = 0; i < this.plot.nPoints; ++i) {
            if (saveXValues) {
                pw.print(IJ.d2s(this.plot.xValues[i], this.xdigits) + "\t" + IJ.d2s(this.plot.yValues[i], this.ydigits) + "\n");
                continue;
            }
            pw.print(IJ.d2s(this.plot.yValues[i], this.ydigits) + "\n");
        }
        String text = aw.toString();
        pw.close();
        StringSelection contents = new StringSelection(text);
        systemClipboard.setContents(contents, this);
        IJ.showStatus(text.length() + " characters copied to Clipboard");
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    void initDigits() {
        int digits = 2;
        int setDigits = Analyzer.getPrecision();
        if (this.ydigits != 9 || setDigits >= 6) {
            this.ydigits = setDigits;
            if (this.ydigits == 0) {
                this.ydigits = 2;
            }
            digits = this.ydigits;
        }
        if (this.ydigits != this.defaultDigits) {
            this.realXValues = false;
            for (int i = 0; i < this.plot.xValues.length; ++i) {
                if ((float)((int)this.plot.xValues[i]) == this.plot.xValues[i]) continue;
                this.realXValues = true;
                break;
            }
            boolean realYValues = false;
            for (int i = 0; i < this.plot.yValues.length; ++i) {
                if ((float)((int)this.plot.yValues[i]) == this.plot.yValues[i]) continue;
                realYValues = true;
                break;
            }
            if (setDigits < 6 && realYValues) {
                this.ydigits = 9;
            }
            if (!realYValues) {
                this.ydigits = 0;
            }
            this.defaultDigits = this.ydigits;
        }
        int n = this.xdigits = this.realXValues ? this.ydigits : 0;
        if (this.xdigits == 0 && this.plot.xValues.length >= 2 && (double)(this.plot.xValues[1] - this.plot.xValues[0]) < 1.0) {
            this.xdigits = digits;
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void actionPerformed(ActionEvent e) {
        Object b = e.getSource();
        if (b == this.list) {
            this.showList();
        } else if (b == this.save) {
            this.saveAsText();
        } else {
            this.copyToClipboard();
        }
    }

    public float[] getXValues() {
        return this.plot.xValues;
    }

    public float[] getYValues() {
        return this.plot.yValues;
    }

    public void drawPlot(Plot plot) {
        this.plot = plot;
        this.imp.setProcessor(null, plot.getProcessor());
    }

    public static void savePreferences(Properties prefs) {
        double min = ProfilePlot.getFixedMin();
        double max = ProfilePlot.getFixedMax();
        if ((min != 0.0 || max != 0.0) && min < max) {
            prefs.put(MIN, Double.toString(min));
            prefs.put(MAX, Double.toString(max));
        }
        if (plotWidth != 450 || plotHeight != 200) {
            prefs.put(PLOT_WIDTH, Integer.toString(plotWidth));
            prefs.put(PLOT_HEIGHT, Integer.toString(plotHeight));
        }
        int options = 0;
        if (saveXValues) {
            options |= 1;
        }
        if (autoClose && !listValues) {
            options |= 2;
        }
        if (listValues) {
            options |= 4;
        }
        if (!interpolate) {
            options |= 8;
        }
        if (noGridLines) {
            options |= 0x10;
        }
        prefs.put(OPTIONS, Integer.toString(options));
    }

    static {
        plotWidth = 450;
        plotHeight = 200;
        IJ.register(PlotWindow.class);
        options = Prefs.getInt(OPTIONS, 1);
        saveXValues = (options & 1) != 0;
        autoClose = (options & 2) != 0;
        listValues = (options & 4) != 0;
        plotWidth = Prefs.getInt(PLOT_WIDTH, 450);
        plotHeight = Prefs.getInt(PLOT_HEIGHT, 200);
        interpolate = (options & 8) == 0;
        noGridLines = (options & 0x10) != 0;
    }
}

