/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.sites.listeners;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.webengine.sites.utils.SitesRelationsWikiHelper;

public class SitesWikiListener
implements EventListener {
    private static final Log log = LogFactory.getLog(SitesWikiListener.class);
    private final String openBracket = "[";
    private final String closeBracket = "]";
    private final String imageTag = "image:";

    public void handleEvent(Event event) {
        String eventName = event.getName();
        if (!("documentModified".equals(eventName) || "documentCreated".equals(eventName) || "beforeDocumentModification".equals(eventName) || "aboutToCreate".equals(eventName))) {
            return;
        }
        if (!(event.getContext() instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
        DocumentModel webPage = docCtx.getSourceDocument();
        if (webPage == null || !"WebPage".equals(webPage.getType())) {
            return;
        }
        try {
            Boolean isRichText = (Boolean)webPage.getPropertyValue("webp:isRichtext");
            if (isRichText.booleanValue()) {
                return;
            }
            WikiProcessingResult result = new WikiProcessingResult();
            if ("beforeDocumentModification".equals(event.getName()) || "aboutToCreate".equals(event.getName())) {
                String wikiContent = (String)((Object)webPage.getPropertyValue("webp:content"));
                String basePath = (String)((Object)webPage.getContextData("basePath"));
                if (basePath == null) {
                    basePath = "/nuxeo/site/sites";
                }
                String targetObjectPath = (String)((Object)webPage.getContextData("targetObjectPath"));
                result = this.processWikiContent(wikiContent, basePath, targetObjectPath);
                webPage.setPropertyValue("webp:content", (Serializable)((Object)result.wikiContent));
                SitesRelationsWikiHelper.updateRelations((DocumentModel)webPage, result.relationLinks);
            }
        }
        catch (ClientException e) {
            log.error((Object)"SitesWikiListener error...", (Throwable)e);
        }
    }

    public WikiProcessingResult processWikiContent(String wikiContent, String basePath, String targetObjectPath) {
        WikiProcessingResult result = new WikiProcessingResult();
        String[] wikiLinks = this.getLinks(wikiContent);
        for (int i = 0; i < wikiLinks.length; ++i) {
            boolean isNamedLink;
            String[] splitWikiLinks = StringUtils.split((String)wikiLinks[i]);
            String linkString = splitWikiLinks[0];
            boolean isImageLink = false;
            String orgLinkString = linkString;
            if (linkString.startsWith("image:")) {
                isImageLink = true;
                linkString = linkString.substring(6);
            }
            boolean bl = isNamedLink = splitWikiLinks.length > 1;
            if (!(linkString.startsWith("http://") || linkString.startsWith("https://") || linkString.startsWith(basePath))) {
                String newLinkString;
                if (linkString.startsWith(".")) {
                    newLinkString = basePath + linkString.replace(".", "/");
                } else if (targetObjectPath != null) {
                    newLinkString = linkString.replace(".", "/");
                    newLinkString = targetObjectPath + "/" + newLinkString;
                } else {
                    newLinkString = linkString;
                }
                result.relationLinks.add(newLinkString);
                if (!isNamedLink) {
                    newLinkString = newLinkString + " " + linkString;
                }
                if (isImageLink) {
                    newLinkString = "image:" + newLinkString;
                }
                wikiContent = wikiContent.replace(orgLinkString, newLinkString);
            }
            if (!linkString.startsWith(basePath)) continue;
            result.relationLinks.add(linkString);
        }
        result.wikiContent = wikiContent;
        return result;
    }

    private String[] getLinks(String content) {
        int endPosition;
        int startPosition;
        if (content == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        int contentLength = content.length();
        if (contentLength == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> returnList = new ArrayList<String>();
        int currentPosition = 0;
        while (currentPosition < contentLength - 1 && (startPosition = content.indexOf("[", currentPosition)) >= 0 && (endPosition = content.indexOf("]", ++startPosition)) >= 0) {
            returnList.add(content.substring(startPosition, endPosition));
            currentPosition = endPosition + 1;
        }
        if (!returnList.isEmpty()) {
            return returnList.toArray(new String[returnList.size()]);
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public class WikiProcessingResult {
        protected List<String> relationLinks = new ArrayList<String>();
        protected String wikiContent;

        public List<String> getRelationLinks() {
            return this.relationLinks;
        }

        public String getWikiContent() {
            return this.wikiContent;
        }
    }
}

