/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.exceptionhandling;

import java.net.SocketException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import org.jboss.remoting.transport.coyote.ClientAbortException;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentSecurityException;

public class ExceptionHelper {
    public static List<String> possibleSecurityErrorMessages = Arrays.asList("java.lang.SecurityException", DocumentSecurityException.class.getName(), SecurityException.class.getName());

    private ExceptionHelper() {
    }

    public static Throwable unwrapException(Throwable t) {
        Throwable cause = null;
        if (t instanceof ServletException) {
            cause = ((ServletException)t).getRootCause();
        } else if (t instanceof ClientException) {
            cause = t.getCause();
        } else if (t instanceof Exception) {
            cause = t.getCause();
        }
        if (cause == null) {
            return t;
        }
        return ExceptionHelper.unwrapException(cause);
    }

    public static boolean isSecurityError(Throwable t) {
        if (t instanceof DocumentSecurityException) {
            return true;
        }
        if (t.getCause() instanceof DocumentSecurityException) {
            return true;
        }
        if (t.getCause() instanceof SecurityException) {
            return true;
        }
        if (t.getMessage() != null) {
            String message = t.getMessage();
            for (String errorMessage : possibleSecurityErrorMessages) {
                if (!message.contains(errorMessage)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isClientAbortError(Throwable t) {
        if (t instanceof ClientAbortException || t instanceof SocketException) {
            return true;
        }
        if (t.getCause() instanceof ClientAbortException || t.getCause() instanceof SocketException) {
            return true;
        }
        if (t != null) {
            if (ClientAbortException.class.getSimpleName().equals(t.getClass().getSimpleName())) {
                return true;
            }
            Throwable cause = t.getCause();
            if (cause != null && ClientAbortException.class.getSimpleName().equals(cause.getClass().getSimpleName())) {
                return true;
            }
        }
        return false;
    }
}

