/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.plugins.text.extractors;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.core.convert.plugins.text.extractors.HtmlParser;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Html2TextConverter
implements Converter {
    private static final Log log = LogFactory.getLog(Html2TextConverter.class);
    public static final String TAG_FILTER_PARAMETER = "tagFilter";

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        InputStream stream = null;
        try {
            stream = blobHolder.getBlob().getStream();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            String tagFilter = null;
            if (parameters != null) {
                tagFilter = (String)((Object)parameters.get(TAG_FILTER_PARAMETER));
            }
            HtmlParser parser = new HtmlParser(tagFilter);
            SAXResult result = new SAXResult(new DefaultHandler());
            InputSource inputSource = new InputSource(stream);
            String encoding = blobHolder.getBlob().getEncoding();
            if (encoding != null) {
                inputSource.setEncoding(encoding);
            }
            SAXSource source = new SAXSource((XMLReader)((Object)parser), inputSource);
            transformer.transform(source, result);
            String text = parser.getContents();
            SimpleCachableBlobHolder simpleCachableBlobHolder = new SimpleCachableBlobHolder((Blob)new StringBlob(text, "text/plain"));
            return simpleCachableBlobHolder;
        }
        catch (Exception e) {
            throw new ConversionException("Error during Html2Text conversion", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error while closing Blob stream", (Throwable)e);
                }
            }
        }
    }

    public void init(ConverterDescriptor descriptor) {
    }
}

