/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.nodevalue;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueVisitor;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NodeValueInteger
extends NodeValue {
    BigInteger integer;

    public NodeValueInteger(BigInteger i) {
        this.integer = i;
    }

    public NodeValueInteger(BigInteger i, Node n) {
        super(n);
        this.integer = i;
    }

    public NodeValueInteger(long i, Node n) {
        super(n);
        this.integer = new BigInteger(Long.toString(i));
    }

    public NodeValueInteger(long i) {
        this.integer = new BigInteger(Long.toString(i));
    }

    public boolean isNumber() {
        return true;
    }

    public boolean isInteger() {
        return true;
    }

    public boolean isDecimal() {
        return true;
    }

    public boolean isFloat() {
        return true;
    }

    public boolean isDouble() {
        return true;
    }

    public BigInteger getInteger() {
        return this.integer;
    }

    public double getDouble() {
        return this.integer.doubleValue();
    }

    public float getFloat() {
        return this.integer.floatValue();
    }

    public BigDecimal getDecimal() {
        return new BigDecimal(this.integer);
    }

    protected Node makeNode() {
        return Node.createLiteral((String)this.integer.toString(), null, (RDFDatatype)XSDDatatype.XSDinteger);
    }

    public String asString() {
        return this.toString();
    }

    public String toString() {
        if (this.getNode() != null) {
            return super.asString();
        }
        return this.integer.toString();
    }

    public void visit(NodeValueVisitor visitor) {
        visitor.visit(this);
    }
}

