/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.core.imagej;

import ij.ImagePlus;
import ij.io.FileSaver;
import ij.process.ImageProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.platform.picture.core.ImageUtils;
import org.nuxeo.runtime.api.Framework;

public class ImageJImageUtils
implements ImageUtils {
    private static final Log log = LogFactory.getLog(ImageJImageUtils.class);

    @Override
    @Deprecated
    public InputStream resize(InputStream in, int width, int height) {
        try {
            FileBlob fb = new FileBlob(in);
            String path = fb.getFile().getPath();
            ImagePlus f = new ImagePlus(path);
            String fileName = f.getFileInfo().fileName;
            ImageProcessor im = f.getProcessor();
            im.setInterpolate(true);
            ImageProcessor ip_small = im.resize(width, height);
            ImagePlus small = new ImagePlus("small", ip_small);
            File resultFile = this.save(small, fileName.split("\\.")[0], "tmp", f.getOriginalFileInfo().fileFormat);
            if (resultFile != null) {
                FileInputStream fis = new FileInputStream(resultFile);
                Framework.trackFile((File)resultFile, (Object)fis);
                return fis;
            }
        }
        catch (IOException e) {
            log.error((Object)"Cannot save the file", (Throwable)e);
        }
        return null;
    }

    @Override
    @Deprecated
    public InputStream crop(InputStream in, int x, int y, int width, int height) {
        try {
            FileBlob fb = new FileBlob(in);
            String path = fb.getFile().getPath();
            ImagePlus f = new ImagePlus(path);
            String fileName = f.getFileInfo().fileName;
            ImageProcessor im = f.getProcessor();
            im.setInterpolate(true);
            im.setRoi(x, y, width, height);
            ImageProcessor ip_crop = im.crop();
            ImagePlus cropImage = new ImagePlus("small", ip_crop);
            File resultFile = this.save(cropImage, fileName.split("\\.")[0], "tmp", f.getOriginalFileInfo().fileFormat);
            if (resultFile != null) {
                FileInputStream fis = new FileInputStream(resultFile);
                Framework.trackFile((File)resultFile, (Object)fis);
                return fis;
            }
        }
        catch (IOException e) {
            log.error((Object)"Cannot save the file", (Throwable)e);
        }
        return null;
    }

    @Override
    @Deprecated
    public InputStream rotate(InputStream in, int angle) {
        try {
            FileBlob fb = new FileBlob(in);
            String path = fb.getFile().getPath();
            ImagePlus f = new ImagePlus(path);
            String fileName = f.getFileInfo().fileName;
            ImageProcessor im = f.getProcessor();
            im.setInterpolate(true);
            ImageProcessor rotatedImage = angle < 0 ? im.rotateLeft() : im.rotateRight();
            ImagePlus newImage = new ImagePlus("small", rotatedImage);
            File resultFile = this.save(newImage, fileName.split("\\.")[0], "tmp", f.getOriginalFileInfo().fileFormat);
            if (resultFile != null) {
                FileInputStream fis = new FileInputStream(resultFile);
                Framework.trackFile((File)resultFile, (Object)fis);
                return fis;
            }
        }
        catch (IOException e) {
            log.error((Object)"Cannot save the file", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob crop(Blob blob, int x, int y, int width, int height) {
        File sourceFile = null;
        try {
            sourceFile = File.createTempFile("source", blob.getFilename());
            blob.transferTo(sourceFile);
            String path = sourceFile.getAbsolutePath();
            ImagePlus f = new ImagePlus(path);
            String fileName = f.getFileInfo().fileName;
            ImageProcessor im = f.getProcessor();
            im.setInterpolate(true);
            im.setRoi(x, y, width, height);
            ImageProcessor ip_crop = im.crop();
            ImagePlus cropImage = new ImagePlus("small", ip_crop);
            File resultFile = this.save(cropImage, fileName.split("\\.")[0], "tmp", f.getOriginalFileInfo().fileFormat);
            if (resultFile != null) {
                FileBlob resultBlob = new FileBlob(resultFile);
                Framework.trackFile((File)resultFile, (Object)resultBlob);
                FileBlob fileBlob = resultBlob;
                return fileBlob;
            }
        }
        catch (IOException e) {
            log.error((Object)"Cannot save the file", (Throwable)e);
        }
        finally {
            if (sourceFile != null) {
                sourceFile.delete();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob resize(Blob blob, String finalFormat, int width, int height, int depth) {
        File sourceFile = null;
        try {
            sourceFile = File.createTempFile("source", blob.getFilename());
            blob.transferTo(sourceFile);
            String path = sourceFile.getAbsolutePath();
            ImagePlus f = new ImagePlus(path);
            String fileName = f.getFileInfo().fileName;
            ImageProcessor im = f.getProcessor();
            im.setInterpolate(true);
            ImageProcessor ip_small = im.resize(width, height);
            ImagePlus small = new ImagePlus("small", ip_small);
            File resultFile = this.save(small, fileName.split("\\.")[0], finalFormat != null ? finalFormat : "tmp", finalFormat != null ? 0 : f.getOriginalFileInfo().fileFormat);
            if (resultFile != null) {
                FileBlob resultBlob = new FileBlob(resultFile);
                Framework.trackFile((File)resultFile, (Object)resultBlob);
                FileBlob fileBlob = resultBlob;
                return fileBlob;
            }
        }
        catch (IOException e) {
            log.error((Object)"Cannot save the file", (Throwable)e);
        }
        finally {
            if (sourceFile != null) {
                sourceFile.delete();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob rotate(Blob blob, int angle) {
        File sourceFile = null;
        try {
            sourceFile = File.createTempFile("source", blob.getFilename());
            blob.transferTo(sourceFile);
            String path = sourceFile.getAbsolutePath();
            ImagePlus f = new ImagePlus(path);
            String fileName = f.getFileInfo().fileName;
            ImageProcessor im = f.getProcessor();
            im.setInterpolate(true);
            ImageProcessor rotatedImage = angle < 0 ? im.rotateLeft() : im.rotateRight();
            ImagePlus newImage = new ImagePlus("small", rotatedImage);
            File resultFile = this.save(newImage, fileName.split("\\.")[0], "tmp", f.getOriginalFileInfo().fileFormat);
            if (resultFile != null) {
                FileBlob resultBlob = new FileBlob(resultFile);
                Framework.trackFile((File)resultFile, (Object)resultBlob);
                FileBlob fileBlob = resultBlob;
                return fileBlob;
            }
        }
        catch (IOException e) {
            log.error((Object)"Cannot save the file", (Throwable)e);
        }
        finally {
            if (sourceFile != null) {
                sourceFile.delete();
            }
        }
        return null;
    }

    private File save(ImagePlus imp, String name, String ext, int fileFormat) {
        String path = name;
        FileSaver fs = new FileSaver(imp);
        try {
            if (fileFormat == 2) {
                File resultFile = File.createTempFile(path, "tiff");
                fs.saveAsTiff(resultFile.getPath());
                return resultFile;
            }
            if (fileFormat == 1) {
                File resultFile = File.createTempFile(path, "raw");
                fs.saveAsRaw(resultFile.getPath());
                return resultFile;
            }
            if (fileFormat == 7) {
                File resultFile = File.createTempFile(path, "zip");
                fs.saveAsZip(resultFile.getPath());
                return resultFile;
            }
            if (fileFormat == 5) {
                File resultFile = File.createTempFile(path, "bmp");
                fs.saveAsBmp(resultFile.getPath());
                return resultFile;
            }
            if (ext.equals("tiff") || ext.equals("TIFF")) {
                File resultFile = File.createTempFile(path, "tiff");
                fs.saveAsTiff(resultFile.getPath());
                return resultFile;
            }
            if (ext.equals("gif") || ext.equals("GIF")) {
                File resultFile = File.createTempFile(path, "gif");
                fs.saveAsGif(resultFile.getPath());
                return resultFile;
            }
            if (ext.equals("jpg") || ext.equals("JPG") || ext.equals("jpeg") || ext.equals("JPEG")) {
                File resultFile = File.createTempFile(path, "jpg");
                fs.saveAsJpeg(resultFile.getPath());
                return resultFile;
            }
            if (ext.equals("raw") || ext.equals("RAW")) {
                File resultFile = File.createTempFile(path, "raw");
                fs.saveAsRaw(resultFile.getPath());
                return resultFile;
            }
            if (ext.equals("zip") || ext.equals("ZIP")) {
                File resultFile = File.createTempFile(path, "zip");
                fs.saveAsZip(resultFile.getPath());
                return resultFile;
            }
            if (ext.equals("bmp") || ext.equals("BMP")) {
                File resultFile = File.createTempFile(path, "bmp");
                fs.saveAsBmp(resultFile.getPath());
                return resultFile;
            }
            if (ext.equals("png")) {
                File resultFile = File.createTempFile(path, "PNG");
                fs.saveAsPng(resultFile.getPath());
                return resultFile;
            }
            if (ext.equals("fits")) {
                File resultFile = File.createTempFile(path, "fits");
                fs.saveAsFits(resultFile.getPath());
                return resultFile;
            }
            File resultFile = File.createTempFile(path, "jpg");
            fs.saveAsJpeg(resultFile.getPath());
            return resultFile;
        }
        catch (IOException e) {
            log.error((Object)"Cannot save the file", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean isAvailable() {
        return true;
    }
}

