/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.jsdoc;

import com.google.caja.ancillary.jsdoc.Updoc;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.JsTokenType;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.lexer.TokenStream;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.Parser;
import com.google.caja.reporting.MessageQueue;
import java.util.ArrayList;

final class UpdocParser {
    private final MessageQueue mq;

    UpdocParser(MessageQueue mq) {
        this.mq = mq;
    }

    Updoc parseComplete(CharProducer cp) throws ParseException {
        JsTokenQueue tq = new JsTokenQueue(new UpdocLexer(cp), cp.getCurrentPosition().source());
        tq.setInputRange(cp.filePositionForOffsets(cp.getOffset(), cp.getLimit()));
        Updoc updoc = this.parse(tq);
        tq.expectEmpty();
        return updoc;
    }

    Updoc parse(JsTokenQueue tq) throws ParseException {
        Parser jsParser = new Parser(tq, this.mq, false);
        ArrayList<Updoc.Run> runs = new ArrayList<Updoc.Run>();
        do {
            tq.expectToken("$");
            FilePosition start = tq.currentPosition();
            Expression input = jsParser.parseExpression(true);
            tq.checkToken(";");
            tq.expectToken("#");
            Expression result = jsParser.parseExpression(true);
            tq.checkToken(";");
            Updoc.Run run = new Updoc.Run(FilePosition.span(start, tq.lastPosition()), input, result);
            runs.add(run);
        } while (tq.lookaheadToken("$"));
        Updoc updoc = new Updoc(FilePosition.span(((Updoc.Run)runs.get(0)).getFilePosition(), ((Updoc.Run)runs.get(runs.size() - 1)).getFilePosition()), runs);
        return updoc;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class UpdocLexer
    implements TokenStream<JsTokenType> {
        private final JsLexer l;

        UpdocLexer(CharProducer cp) {
            this.l = new JsLexer(cp, false);
        }

        @Override
        public boolean hasNext() throws ParseException {
            return this.l.hasNext();
        }

        @Override
        public Token<JsTokenType> next() throws ParseException {
            return this.l.next();
        }
    }
}

