/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.demos.playground.client.ui;

import com.google.caja.demos.playground.client.Playground;
import com.google.caja.demos.playground.client.PlaygroundResource;
import com.google.caja.demos.playground.client.ui.Example;
import com.google.caja.demos.playground.client.ui.Menu;
import com.google.caja.demos.playground.client.ui.PlaygroundUI;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.RootLayoutPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class PlaygroundView {
    private Playground controller;
    private MultiWordSuggestOracle sourceExamples;
    private MultiWordSuggestOracle policyExamples;
    private PlaygroundUI playgroundUI;

    public void setVersion(String v) {
        this.playgroundUI.version.setText(v);
    }

    public void setPolicyUrl(String url) {
        this.playgroundUI.policyAddressField.setText(url);
        this.policyExamples.add(url);
    }

    public void setUrl(String url) {
        this.playgroundUI.addressField.setText(url);
        this.sourceExamples.add(url);
    }

    public void selectTab(Tabs tab) {
        this.playgroundUI.editorPanel.selectTab(tab.ordinal());
    }

    private void initSourcePanel() {
        for (Example eg : Example.values()) {
            this.sourceExamples.add(eg.url);
        }
        this.playgroundUI.addressField.getTextBox().addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                ((PlaygroundView)PlaygroundView.this).playgroundUI.addressField.showSuggestionList();
            }
        });
        this.playgroundUI.addressField.setText("http://");
        this.playgroundUI.goButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PlaygroundView.this.controller.loadSource(((PlaygroundView)PlaygroundView.this).playgroundUI.addressField.getText());
            }
        });
        this.playgroundUI.cajoleButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ((PlaygroundView)PlaygroundView.this).playgroundUI.runtimeMessages.clear();
                ((PlaygroundView)PlaygroundView.this).playgroundUI.compileMessages.clear();
                ((PlaygroundView)PlaygroundView.this).playgroundUI.cajoledSource.setText("");
                ((PlaygroundView)PlaygroundView.this).playgroundUI.renderPanel.setText("");
                PlaygroundView.this.controller.cajole(((PlaygroundView)PlaygroundView.this).playgroundUI.addressField.getText(), ((PlaygroundView)PlaygroundView.this).playgroundUI.sourceText.getText(), ((PlaygroundView)PlaygroundView.this).playgroundUI.policyText.getText(), true);
            }
        });
    }

    private void initFeedbackPanel() {
        this.playgroundUI.feedbackPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        for (Menu menu : Menu.values()) {
            Anchor menuItem = new Anchor();
            menuItem.setHTML(menu.description);
            menuItem.setHref(menu.url);
            menuItem.setWordWrap(false);
            menuItem.addStyleName("menuItems");
            this.playgroundUI.feedbackPanel.add((Widget)menuItem);
            this.playgroundUI.feedbackPanel.setCellWidth((Widget)menuItem, "100%");
        }
    }

    private void initPolicyPanel() {
        this.policyExamples = new MultiWordSuggestOracle();
        this.playgroundUI.policyAddressField = new SuggestBox((SuggestOracle)this.policyExamples);
        this.playgroundUI.policyAddressField.getTextBox().addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                ((PlaygroundView)PlaygroundView.this).playgroundUI.policyAddressField.showSuggestionList();
            }
        });
        this.playgroundUI.policyAddressField.setText("http://");
        this.playgroundUI.clearButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PlaygroundView.this.controller.clearPolicy();
            }
        });
        this.playgroundUI.loadButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PlaygroundView.this.controller.loadPolicy(((PlaygroundView)PlaygroundView.this).playgroundUI.policyAddressField.getText());
            }
        });
        this.playgroundUI.defaultButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PlaygroundView.this.setPolicySource(PlaygroundView.this.defaultPolicy());
            }
        });
        this.setPolicySource(this.defaultPolicy());
    }

    private String defaultPolicy() {
        return PlaygroundResource.INSTANCE.defaultPolicy().getText();
    }

    static native String encodeURIComponent(String var0);

    private static native boolean srcLocMapAndOriginalSrc(String var0, String[] var1);

    private native void setupNativeSelectLineBridge();

    private void initEditor() {
        this.setupNativeSelectLineBridge();
        this.selectTab(Tabs.SOURCE);
    }

    private static TreeItem addExampleItem(Map<Example.Type, TreeItem> menu, Example eg) {
        if (!menu.containsKey((Object)eg.type)) {
            TreeItem menuItem = new TreeItem(eg.type.description);
            menu.put(eg.type, menuItem);
        }
        TreeItem egItem = new TreeItem(eg.description);
        menu.get((Object)eg.type).addItem(egItem);
        return egItem;
    }

    private void initExamples() {
        EnumMap<Example.Type, TreeItem> menuMap = new EnumMap<Example.Type, TreeItem>(Example.Type.class);
        final HashMap<TreeItem, Example> entryMap = new HashMap<TreeItem, Example>();
        this.playgroundUI.exampleTree.setTitle("Select an example");
        for (Example eg : Example.values()) {
            TreeItem it = PlaygroundView.addExampleItem(menuMap, eg);
            entryMap.put(it, eg);
        }
        boolean first = true;
        for (TreeItem menuItem : menuMap.values()) {
            if (first) {
                first = false;
                menuItem.setState(true);
            }
            this.playgroundUI.exampleTree.addItem(menuItem);
        }
        this.playgroundUI.exampleTree.addSelectionHandler((SelectionHandler)new SelectionHandler<TreeItem>(){

            public void onSelection(SelectionEvent<TreeItem> event) {
                Example eg = (Example)((Object)entryMap.get(event.getSelectedItem()));
                if (null == eg) {
                    return;
                }
                PlaygroundView.this.controller.loadSource(eg.url);
            }
        });
    }

    public PlaygroundView(Playground controller) {
        this.controller = controller;
        this.sourceExamples = new MultiWordSuggestOracle();
        this.policyExamples = new MultiWordSuggestOracle();
        this.playgroundUI = new PlaygroundUI(this.sourceExamples, this.policyExamples);
        RootLayoutPanel.get().add((Widget)this.playgroundUI);
        this.initSourcePanel();
        this.initPolicyPanel();
        this.initFeedbackPanel();
        this.initExamples();
        this.initEditor();
    }

    public void setOriginalSource(String result) {
        if (result == null) {
            this.playgroundUI.sourceText.setText("");
        } else {
            this.playgroundUI.sourceText.setText(result);
        }
    }

    public void setPolicySource(String result) {
        if (result == null) {
            this.playgroundUI.policyText.setText("");
        } else {
            this.playgroundUI.policyText.setText(result);
        }
    }

    public void setCajoledSource(String html, String js) {
        if (html == null && js == null) {
            this.playgroundUI.cajoledSource.setText("There were cajoling errors");
            return;
        }
        this.playgroundUI.cajoledSource.setHTML(this.prettyPrint(html, "html") + "&lt;script&gt;" + this.prettyPrint(js, "lang-js") + "&lt;/script&gt;");
    }

    public void setLoading(boolean isLoading) {
        this.playgroundUI.loadingLabel.setVisible(isLoading);
    }

    private native String prettyPrint(String var1, String var2);

    public void setRenderedResult(String policy, String html, String js) {
        if (html == null && js == null) {
            this.playgroundUI.renderResult.setText("There were cajoling errors");
            return;
        }
        this.selectTab(Tabs.RENDER);
        this.setRenderedResultBridge(true, (Element)this.playgroundUI.renderPanel.getElement(), policy, html != null ? html : "", js != null ? js : "");
    }

    private void setRenderedResult(String result) {
        this.playgroundUI.renderResult.setText(result);
    }

    private void alert(String msg) {
        final DialogBox alertBox = new DialogBox();
        alertBox.setGlassEnabled(true);
        alertBox.setText("Cajoled gadget says");
        DockLayoutPanel dock = new DockLayoutPanel(Style.Unit.PX);
        dock.add((Widget)new ScrollPanel((Widget)new Label(msg)));
        dock.addSouth((Widget)new Button("Ok", new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                alertBox.hide();
            }
        }), 20.0);
        dock.setSize("200px", "200px");
        alertBox.add((Widget)dock);
        alertBox.center();
        alertBox.show();
    }

    private native void setRenderedResultBridge(boolean var1, Element var2, String var3, String var4, String var5);

    public void addCompileMessage(String item) {
        HTML i = new HTML(item);
        this.playgroundUI.compileMessages.add((Widget)i);
    }

    public void addRuntimeMessage(String message, String source, String lineNum) {
        Label i = new Label("Uncaught script error: '" + message + "' in source: '" + source + "' at line: " + lineNum + "\n");
        this.playgroundUI.runtimeMessages.add((Widget)i);
    }

    public void highlightSource(String uri, int start, int sOffset, int end, int eOffset) {
        this.playgroundUI.sourceText.setCursorPos(start);
        this.playgroundUI.sourceText.setSelectionRange(start, sOffset, end, eOffset);
    }

    public static enum Tabs {
        SOURCE,
        POLICY,
        CAJOLED_SOURCE,
        RENDER,
        COMPILE_WARNINGS,
        RUNTIME_WARNINGS,
        TAMING,
        MANIFEST;

    }
}

