/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lang.css;

import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.util.Lists;
import com.google.caja.util.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JSRE {
    JSRE() {
    }

    static JSRE cat(JSRE ... parts) {
        return new Concatenation(parts);
    }

    static JSRE cat(List<JSRE> parts) {
        return new Concatenation(parts);
    }

    static JSRE alt(JSRE ... parts) {
        return new Alternation(parts);
    }

    static JSRE alt(List<JSRE> parts) {
        return new Alternation(parts);
    }

    static JSRE rep(JSRE body, int min, int max) {
        return new Repetition(body, min, max);
    }

    static JSRE opt(JSRE body) {
        return JSRE.rep(body, 0, 1);
    }

    static JSRE any(JSRE body) {
        return JSRE.rep(body, 0, Integer.MAX_VALUE);
    }

    static JSRE many(JSRE body) {
        return JSRE.rep(body, 1, Integer.MAX_VALUE);
    }

    static JSRE raw(String atom) {
        return "".equals(atom) ? new Noop() : new Atom(atom);
    }

    static JSRE lit(String literal) {
        int n = literal.length();
        JSRE[] parts = new JSRE[n];
        StringBuilder sb = new StringBuilder();
        int i = n;
        while (--i >= 0) {
            sb.setLength(0);
            Escaping.escapeRegex((CharSequence)literal.substring(i, i + 1), false, false, sb);
            parts[i] = JSRE.raw(sb.toString());
        }
        return JSRE.cat(parts);
    }

    abstract JSRE optimize();

    abstract void render(StringBuilder var1);

    abstract Priority priority();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    JSRE without(List<JSRE> head, List<JSRE> tail) {
        switch (head.size() + tail.size()) {
            case 0: {
                return this;
            }
            case 1: {
                if (!(head.isEmpty() ? tail : head).get(0).equals(this)) break;
                return new Noop();
            }
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.render(sb);
        return sb.toString();
    }

    void renderChild(JSRE child, StringBuilder out) {
        if (child.priority().compareTo(this.priority()) <= 0) {
            out.append("(?:");
            child.render(out);
            out.append(')');
        } else {
            child.render(out);
        }
    }

    private static List<JSRE> asList(JSRE jsre) {
        if (jsre instanceof Concatenation) {
            return ((Concatenation)jsre).children;
        }
        if (jsre instanceof Noop) {
            return Collections.emptyList();
        }
        return Collections.singletonList(jsre);
    }

    private static <T> List<T> commonPrefix(List<T> a, List<T> b) {
        int i;
        int n = Math.min(a.size(), b.size());
        for (i = 0; i < n && a.get(i).equals(b.get(i)); ++i) {
        }
        return Lists.newArrayList(a.subList(0, i));
    }

    private static <T> List<T> commonSuffix(List<T> a, List<T> b) {
        int m = a.size();
        int n = b.size();
        int i = m;
        int j = n;
        while (--i >= 0 && --j >= 0 && a.get(i).equals(b.get(j))) {
        }
        return Lists.newArrayList(a.subList(i + 1, m));
    }

    static final class Atom
    extends JSRE {
        final String atom;

        private Atom(String atom) {
            this.atom = atom;
        }

        JSRE optimize() {
            return this;
        }

        Priority priority() {
            return Priority.MAX;
        }

        void render(StringBuilder sb) {
            sb.append(this.atom);
        }

        public boolean equals(Object o) {
            return o instanceof Atom && this.atom.equals(((Atom)o).atom);
        }

        public int hashCode() {
            return this.atom.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Concatenation
    extends JSRE {
        final List<JSRE> children;

        private Concatenation(JSRE ... children) {
            this(Arrays.asList(children));
        }

        private Concatenation(Collection<JSRE> children) {
            this.children = Collections.unmodifiableList(Lists.newArrayList(children));
        }

        @Override
        JSRE optimize() {
            boolean different = false;
            List<JSRE> optimized = Lists.newArrayList();
            for (JSRE child : this.children) {
                JSRE opt = child.optimize();
                if (opt instanceof Noop) {
                    different = true;
                    continue;
                }
                if (opt instanceof Concatenation) {
                    optimized.addAll(((Concatenation)opt).children);
                    different = true;
                    continue;
                }
                optimized.add(opt);
                different |= opt != child;
            }
            if (Concatenation.foldAdjacentReps(optimized)) {
                different = true;
            }
            if (Concatenation.foldOptMany(optimized)) {
                different = true;
            }
            switch (optimized.size()) {
                case 0: {
                    return new Noop();
                }
                case 1: {
                    return optimized.get(0);
                }
            }
            return different ? new Concatenation(optimized) : this;
        }

        private static boolean foldAdjacentReps(List<JSRE> items) {
            boolean changed = false;
            int n = items.size();
            for (int i = 1; i < n; ++i) {
                int max0;
                int min0;
                JSRE body0;
                int max1;
                int min1;
                JSRE body1;
                Repetition r;
                JSRE item = items.get(i);
                JSRE prior = items.get(i - 1);
                List<JSRE> parts0 = items.subList(i - 1, i);
                List<JSRE> parts1 = items.subList(i, i + 1);
                if (item instanceof Repetition) {
                    r = (Repetition)item;
                    body1 = r.body;
                    min1 = r.min;
                    max1 = r.max;
                } else if (prior instanceof Repetition && ((Repetition)prior).body instanceof Concatenation) {
                    int catn = ((Concatenation)((Repetition)prior).body).children.size();
                    if (i + catn <= n) {
                        parts1 = items.subList(i, i + catn);
                        body1 = new Concatenation(parts1);
                        max1 = 1;
                        min1 = 1;
                    } else {
                        body1 = item;
                        max1 = 1;
                        min1 = 1;
                    }
                } else {
                    body1 = item;
                    max1 = 1;
                    min1 = 1;
                }
                if (prior instanceof Repetition) {
                    r = (Repetition)prior;
                    body0 = r.body;
                    min0 = r.min;
                    max0 = r.max;
                } else if (body1 instanceof Concatenation) {
                    int catn = ((Concatenation)body1).children.size();
                    if (i >= catn) {
                        parts0 = items.subList(i - catn, i);
                        body0 = new Concatenation(parts0);
                        max0 = 1;
                        min0 = 1;
                    } else {
                        body0 = prior;
                        max0 = 1;
                        min0 = 1;
                    }
                } else {
                    body0 = prior;
                    max0 = 1;
                    min0 = 1;
                }
                if (!body0.equals(body1) || min0 == 1 && min1 == 1 && max0 == 1 && max1 == 1 && !Concatenation.shouldCombine(body0)) continue;
                long min = (long)min0 + (long)min1;
                long max = (long)max0 + (long)max1;
                if (min > Integer.MAX_VALUE) {
                    min = Integer.MAX_VALUE;
                }
                if (max > Integer.MAX_VALUE) {
                    max = Integer.MAX_VALUE;
                }
                items.set(i - parts0.size(), new Repetition(body0, (int)min, (int)max));
                int nexti = i - parts0.size() + 1;
                items.subList(nexti, i + parts1.size()).clear();
                i = nexti;
                n = items.size();
                changed = true;
            }
            return changed;
        }

        private static boolean foldOptMany(List<JSRE> items) {
            boolean changed = false;
            int n = items.size();
            for (int i = 1; i < n; ++i) {
                JSRE item = items.get(i);
                JSRE prior = items.get(i - 1);
                if (!(item instanceof Repetition) || !(prior instanceof Repetition)) continue;
                Repetition r0 = (Repetition)prior;
                Repetition r1 = (Repetition)item;
                if (r0.max != Integer.MAX_VALUE || r1.max != 1 || !(r1.body instanceof Concatenation)) continue;
                Concatenation b = (Concatenation)r1.body;
                JSRE r10 = b.children.get(0);
                if (!r0.equals(r10) && (!(r10 instanceof Repetition) || !((Repetition)r10).body.equals(r0))) continue;
                changed = true;
                items.set(i, JSRE.rep(JSRE.cat(b.children.subList(1, b.children.size())), r1.min, r1.max).optimize());
            }
            return changed;
        }

        private static boolean shouldCombine(JSRE p) {
            return p.toString().length() >= 3;
        }

        @Override
        Priority priority() {
            return Priority.CONCATENATION;
        }

        @Override
        void render(StringBuilder sb) {
            for (JSRE child : this.children) {
                this.renderChild(child, sb);
            }
        }

        @Override
        JSRE without(List<JSRE> head, List<JSRE> tail) {
            int n = this.children.size();
            int h = head.size();
            int t = tail.size();
            assert (((Object)head).equals(this.children.subList(0, h)));
            assert (((Object)tail).equals(this.children.subList(n - t, n)));
            if (h + t == n) {
                return new Noop();
            }
            return new Concatenation(this.children.subList(h, n - t));
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Concatenation)) {
                return false;
            }
            return ((Object)this.children).equals(((Concatenation)o).children);
        }

        @Override
        public int hashCode() {
            return this.getClass().hashCode() ^ ((Object)this.children).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Alternation
    extends JSRE {
        final List<JSRE> children;
        final boolean isCharSet;

        private Alternation(JSRE ... children) {
            this(Arrays.asList(children));
        }

        private Alternation(Collection<JSRE> children) {
            List<JSRE> clone = Lists.newArrayList(children);
            boolean isCharSet = true;
            for (JSRE child : clone) {
                String atom;
                if (child instanceof Atom && ((atom = ((Atom)child).atom).length() == 1 || atom.length() == 2 && '\\' == atom.charAt(0))) continue;
                isCharSet = false;
                break;
            }
            if (isCharSet) {
                int i = clone.size();
                while (--i >= 0) {
                    char ch;
                    JSRE child;
                    child = (Atom)clone.get(i);
                    if (((Atom)child).atom.length() != 2 || 'a' <= (ch = ((Atom)child).atom.charAt(1)) && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9') continue;
                    clone.set(i, new Atom(Character.toString(ch)));
                }
                Collections.sort(clone, new Comparator<JSRE>(){

                    @Override
                    public int compare(JSRE a, JSRE b) {
                        return ((Atom)a).atom.compareTo(((Atom)b).atom);
                    }
                });
            }
            this.isCharSet = isCharSet;
            this.children = Collections.unmodifiableList(clone);
        }

        @Override
        JSRE optimize() {
            JSRE out;
            boolean different = false;
            boolean optional = false;
            Set<JSRE> optimized = Sets.newLinkedHashSet();
            for (JSRE child : this.children) {
                JSRE opt = child.optimize();
                if (opt instanceof Alternation) {
                    optimized.addAll(((Alternation)opt).children);
                    different = true;
                    continue;
                }
                if (opt instanceof Noop) {
                    different = true;
                    optional = true;
                    continue;
                }
                if (!optimized.add(opt)) {
                    different = true;
                }
                different |= opt != child;
            }
            if (optimized.isEmpty()) {
                return new Noop();
            }
            if (optimized.size() == 1) {
                out = (JSRE)optimized.iterator().next();
            } else {
                List<JSRE> commonHead = null;
                List commonTail = null;
                int minParts = Integer.MAX_VALUE;
                for (JSRE child : optimized) {
                    List parts = JSRE.asList(child);
                    minParts = Math.min(minParts, parts.size());
                    if (commonHead == null) {
                        commonTail = parts;
                        commonHead = commonTail;
                        minParts = parts.size();
                        continue;
                    }
                    commonHead = JSRE.commonPrefix(commonHead, parts);
                    commonTail = JSRE.commonSuffix(commonTail, parts);
                    if (!commonHead.isEmpty() || !commonTail.isEmpty()) continue;
                    break;
                }
                assert (commonHead != null && commonTail != null) : "no children";
                if (!commonHead.isEmpty() || !commonTail.isEmpty()) {
                    if (commonHead.size() + commonTail.size() > minParts) {
                        commonHead = commonHead.subList(0, minParts - commonTail.size());
                    }
                    List<JSRE> reducedChildren = Lists.newArrayList();
                    for (JSRE child : optimized) {
                        reducedChildren.add(child.without(commonHead, commonTail));
                    }
                    List<JSRE> parts = Lists.newArrayList();
                    parts.addAll(commonHead);
                    parts.add(new Alternation(reducedChildren));
                    parts.addAll(commonTail);
                    out = new Concatenation(parts).optimize();
                } else {
                    out = different ? new Alternation(optimized) : this;
                }
            }
            return optional ? new Repetition(out, 0, 1) : out;
        }

        @Override
        Priority priority() {
            return this.isCharSet ? Priority.MAX : Priority.ALTERNATION;
        }

        private void renderCharInSet(char ch, StringBuilder out) {
            switch (ch) {
                case '-': 
                case '\\': 
                case ']': 
                case '^': {
                    out.append('\\').append(ch);
                    break;
                }
                default: {
                    out.append(ch);
                }
            }
        }

        private void renderRangeTail(int start, int last, StringBuilder out) {
            if (last != -1 && last != start) {
                if (last > start + 1) {
                    out.append('-');
                }
                this.renderCharInSet((char)last, out);
            }
        }

        @Override
        void render(StringBuilder sb) {
            if (this.isCharSet) {
                sb.append('[');
                int rangeStart = -1;
                int lastInRange = -1;
                for (JSRE child : this.children) {
                    String atom = ((Atom)child).atom;
                    if (atom.length() != 1) {
                        this.renderRangeTail(rangeStart, lastInRange, sb);
                        lastInRange = -1;
                        rangeStart = -1;
                        sb.append(atom);
                        continue;
                    }
                    char ch = atom.charAt(0);
                    if (lastInRange == -1 || ch != lastInRange + 1) {
                        this.renderRangeTail(rangeStart, lastInRange, sb);
                        char c = ch;
                        rangeStart = c;
                        lastInRange = c;
                        this.renderCharInSet(ch, sb);
                        continue;
                    }
                    lastInRange = ch;
                }
                this.renderRangeTail(rangeStart, lastInRange, sb);
                sb.append(']');
            } else {
                int n = this.children.size();
                for (int i = 0; i < n; ++i) {
                    if (i != 0) {
                        sb.append('|');
                    }
                    this.renderChild(this.children.get(i), sb);
                }
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Alternation)) {
                return false;
            }
            return ((Object)this.children).equals(((Alternation)o).children);
        }

        @Override
        public int hashCode() {
            return this.getClass().hashCode() ^ ((Object)this.children).hashCode();
        }
    }

    static final class Repetition
    extends JSRE {
        final JSRE body;
        final int min;
        final int max;

        private Repetition(JSRE body, int min, int max) {
            this.body = body;
            this.min = min;
            this.max = max;
        }

        JSRE optimize() {
            JSRE newBody = this.body.optimize();
            if (this.min == 1 && this.max == 1) {
                return newBody;
            }
            if (newBody instanceof Noop || this.max == 0) {
                return newBody;
            }
            if (newBody instanceof Repetition) {
                Repetition r = (Repetition)newBody;
                if (r.max == 1) {
                    return new Repetition(r.body, 0, this.max);
                }
                if (r.max == Integer.MAX_VALUE) {
                    if (r.min == 0) {
                        return new Repetition(r.body, 0, Integer.MAX_VALUE);
                    }
                    if (r.min == 1) {
                        return new Repetition(r.body, this.min, Integer.MAX_VALUE);
                    }
                }
            }
            return newBody == this.body ? this : new Repetition(newBody, this.min, this.max);
        }

        Priority priority() {
            return Priority.REPETITION;
        }

        void render(StringBuilder sb) {
            this.renderChild(this.body, sb);
            if (this.min == 0) {
                if (this.max == 1) {
                    sb.append('?');
                    return;
                }
                if (this.max == Integer.MAX_VALUE) {
                    sb.append('*');
                    return;
                }
            } else if (this.min == 1 && this.max == Integer.MAX_VALUE) {
                sb.append('+');
                return;
            }
            sb.append('{');
            sb.append(this.min);
            if (this.max != this.min) {
                sb.append(',');
                if (this.max != Integer.MAX_VALUE) {
                    sb.append(this.max);
                }
            }
            sb.append('}');
        }

        public boolean equals(Object o) {
            if (!(o instanceof Repetition)) {
                return false;
            }
            Repetition that = (Repetition)o;
            return this.min == that.min && this.max == that.max && this.body.equals(that.body);
        }

        public int hashCode() {
            return 31 * (this.min + 31 * this.max) + this.body.hashCode();
        }
    }

    static final class Noop
    extends JSRE {
        private Noop() {
        }

        public boolean equals(Object o) {
            return o instanceof Noop;
        }

        public int hashCode() {
            return 0;
        }

        JSRE optimize() {
            return this;
        }

        Priority priority() {
            return Priority.MAX;
        }

        void render(StringBuilder sb) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Priority {
        ALTERNATION,
        CONCATENATION,
        REPETITION,
        MAX;

    }
}

