/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessagePart;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Keyword implements MessagePart
{
    BREAK("break"),
    CASE("case"),
    CATCH("catch"),
    CLASS("class"),
    CONST("const"),
    CONTINUE("continue"),
    DEBUGGER("debugger"),
    DEFAULT("default"),
    DELETE("delete"),
    DO("do"),
    ELSE("else"),
    ENUM("enum"),
    EXPORT("export"),
    EXTENDS("extends"),
    FALSE("false"),
    FINALLY("finally"),
    FOR("for"),
    FUNCTION("function"),
    IF("if"),
    IMPLEMENTS("implements"),
    IMPORT("import"),
    IN("in"),
    INSTANCEOF("instanceof"),
    INTERFACE("interface"),
    LET("let"),
    NEW("new"),
    NULL("null"),
    PACKAGE("package"),
    PRIVATE("private"),
    PROTECTED("protected"),
    PUBLIC("public"),
    RETURN("return"),
    STATIC("static"),
    SUPER("super"),
    SWITCH("switch"),
    THIS("this"),
    THROW("throw"),
    TRUE("true"),
    TRY("try"),
    TYPEOF("typeof"),
    VAR("var"),
    VOID("void"),
    WHILE("while"),
    WITH("with"),
    YIELD("yield");

    private final String keywordText;
    private static final Map<String, Keyword> JAVASCRIPT_KEYWORDS;

    private Keyword(String keywordText) {
        this.keywordText = keywordText;
    }

    @Override
    public void format(MessageContext mc, Appendable out) throws IOException {
        out.append(this.keywordText);
    }

    public String toString() {
        return this.keywordText;
    }

    public static Keyword fromString(String keywordText) {
        return JAVASCRIPT_KEYWORDS.get(keywordText);
    }

    public static boolean isKeyword(String name) {
        return JAVASCRIPT_KEYWORDS.containsKey(name);
    }

    static {
        JAVASCRIPT_KEYWORDS = new HashMap<String, Keyword>();
        for (Keyword k : Keyword.values()) {
            JAVASCRIPT_KEYWORDS.put(k.toString(), k);
        }
    }
}

