/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import java.io.Serializable;

public final class SourceBreaks
implements Serializable {
    private static final long serialVersionUID = 7399048719164090106L;
    private final InputSource src;
    private int nLines;
    private int[] lineNums = new int[1024];
    private int lineNumberZero;
    private int cachedCharInFile = -1;
    private int cachedAnswer = -1;

    public SourceBreaks(InputSource src, int lineNumberZero) {
        this.src = src;
        this.lineNumberZero = lineNumberZero;
    }

    public InputSource source() {
        return this.src;
    }

    int charInLineAt(int charInFile) {
        int lineno = this.lineAt(charInFile) - this.lineNumberZero;
        if (lineno == 0) {
            return charInFile;
        }
        return charInFile - this.lineNums[lineno - 1] + 1;
    }

    int lineAt(int charInFile) {
        if (this.cachedCharInFile == charInFile) {
            return this.cachedAnswer + this.lineNumberZero;
        }
        this.cachedCharInFile = charInFile;
        int lineNum = SourceBreaks.boundedBinarySearch(this.lineNums, charInFile, this.nLines);
        lineNum = lineNum < 0 ? (lineNum ^= 0xFFFFFFFF) : ++lineNum;
        this.cachedAnswer = lineNum;
        return this.cachedAnswer + this.lineNumberZero;
    }

    public FilePosition toFilePosition(int charInFile) {
        return new FilePosition(this, charInFile, 0);
    }

    public FilePosition toFilePosition(int startCharInFile, int endCharInFile) {
        return new FilePosition(this, startCharInFile, endCharInFile - startCharInFile);
    }

    public void lineStartsAt(int charInFile) {
        assert (this.nLines == 0 || charInFile > this.lineNums[this.nLines - 1]);
        if (this.nLines == this.lineNums.length) {
            int[] newLineNums = new int[this.nLines * 2];
            System.arraycopy(this.lineNums, 0, newLineNums, 0, this.nLines);
            this.lineNums = newLineNums;
        }
        this.lineNums[this.nLines++] = charInFile;
        this.cachedCharInFile = -1;
    }

    private static int boundedBinarySearch(int[] arr, int target, int limit) {
        int lo = 0;
        int hi = limit - 1;
        while (lo <= hi) {
            int midpoint = lo + hi >>> 1;
            int el = arr[midpoint];
            if (target > el) {
                lo = midpoint + 1;
                continue;
            }
            if (target < el) {
                hi = midpoint - 1;
                continue;
            }
            return midpoint;
        }
        return ~lo;
    }
}

