/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser;

import com.google.caja.lexer.InputSource;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParserContext;
import com.google.caja.parser.css.CssParserTest;
import com.google.caja.parser.css.CssTree;
import com.google.caja.parser.html.Dom;
import com.google.caja.parser.html.DomParserTest;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.ParserTest;
import com.google.caja.reporting.DevNullMessageQueue;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.ContentType;
import com.google.caja.util.Maps;
import com.google.caja.util.TestUtil;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;

public class ParserContextTest
extends CajaTestCase {
    public final void testNotEnoughInput() {
        try {
            ParseTreeNode node = new ParserContext(DevNullMessageQueue.singleton()).build();
            ParserContextTest.fail();
        }
        catch (Throwable e) {
            ParserContextTest.assertTrue((boolean)(e instanceof IllegalStateException));
        }
    }

    public final void testContentCache() throws Exception {
        InputSource is = new InputSource(URI.create("test:///foo.js"));
        Map<InputSource, CharSequence> sourceMap = Maps.newHashMap();
        ParseTreeNode node = new ParserContext(DevNullMessageQueue.singleton()).withSourceMap(sourceMap).withInput(is).withInput("var j = 1;").build();
        ParserContextTest.assertTrue((boolean)sourceMap.containsKey(is));
        ParserContextTest.assertEquals((Object)"var j = 1;", (Object)sourceMap.get(is));
    }

    public final void testMinimalGuessHtmlContentType() throws Exception {
        ParseTreeNode node = new ParserContext(DevNullMessageQueue.singleton()).withInput("<b>hi mom</b>").build();
        ParserContextTest.assertEquals((Object)node.getFilePosition().source(), (Object)InputSource.UNKNOWN);
        ParserContextTest.assertTrue((boolean)(node instanceof Dom));
    }

    public final void testMinimalGuessJsContentType() throws Exception {
        ParseTreeNode node = new ParserContext(DevNullMessageQueue.singleton()).withInput("var x = 1;").build();
        ParserContextTest.assertEquals((Object)node.getFilePosition().source(), (Object)InputSource.UNKNOWN);
        ParserContextTest.assertTrue((boolean)(node instanceof Block));
    }

    public final void testMinimalGuessCssContentType() throws Exception {
        ParseTreeNode node = new ParserContext(DevNullMessageQueue.singleton()).withInput("div { color: red; }").build();
        ParserContextTest.assertEquals((Object)node.getFilePosition().source(), (Object)InputSource.UNKNOWN);
        ParserContextTest.assertTrue((boolean)(node instanceof CssTree.StyleSheet));
    }

    public final void testGuessCharProducer() throws Exception {
        InputStream css = TestUtil.getResource(CssParserTest.class, "cssparserinput1.css").toURL().openStream();
        InputStream html = TestUtil.getResource(DomParserTest.class, "amazon.com.html").toURL().openStream();
        InputStream js = TestUtil.getResource(ParserTest.class, "parsertest1.js").toURL().openStream();
        ParserContext ctx = new ParserContext(DevNullMessageQueue.singleton());
        ParseTreeNode cssNode = ctx.withInput(css).withInput(ContentType.CSS).build();
        ParserContextTest.assertTrue((boolean)(cssNode instanceof CssTree.StyleSheet));
        ParseTreeNode htmlNode = ctx.withInput(html).withInput(ContentType.HTML).build();
        ParserContextTest.assertTrue((boolean)(htmlNode instanceof Dom));
        ParseTreeNode jsNode = ctx.withInput(js).withInput(ContentType.JS).build();
        ParserContextTest.assertTrue((boolean)(jsNode instanceof Block));
    }
}

