/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.HtmlEntities;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.parser.html.DoctypeMaker;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.parser.html.Renderer;
import com.google.caja.render.Concatenator;
import com.google.caja.reporting.MarkupRenderMode;
import com.google.caja.reporting.RenderContext;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Nodes {
    private static final String FP_KEY = "caja:filePosition";
    private static final String RAW_TEXT_KEY = "caja:rawHtml";
    private static final String HAS_XMLNS_DECLARATION_KEY = "caja:hasXmlns";
    private static final UserDataHandler HAS_XMLNS_DECLARATION_DATA_HANDLER = new UserDataHandler(){

        public void handle(short operation, String key, Object data, Node src, Node dest) {
            switch (operation) {
                case 1: 
                case 2: {
                    dest.setUserData(Nodes.HAS_XMLNS_DECLARATION_KEY, Boolean.TRUE, this);
                }
            }
        }
    };
    private static final FilePosition UNKNOWN_START_OF_FILE = FilePosition.startOfFile(InputSource.UNKNOWN);

    public static Iterable<? extends Node> childrenOf(final Node n) {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new Iterator<Node>(){
                    Node child;
                    {
                        this.child = n.getFirstChild();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.child != null;
                    }

                    @Override
                    public Node next() {
                        if (this.child == null) {
                            throw new NoSuchElementException();
                        }
                        Node result = this.child;
                        this.child = this.child.getNextSibling();
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Iterable<? extends Attr> attributesOf(final Element el) {
        return new Iterable<Attr>(){

            @Override
            public Iterator<Attr> iterator() {
                return new Iterator<Attr>(){
                    NamedNodeMap attrs;
                    int i;
                    int n;
                    {
                        this.attrs = el.getAttributes();
                        this.i = 0;
                        this.n = this.attrs != null ? this.attrs.getLength() : 0;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i < this.n;
                    }

                    @Override
                    public Attr next() {
                        if (this.i == this.n) {
                            throw new NoSuchElementException();
                        }
                        return (Attr)this.attrs.item(this.i++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <T extends Node> Iterable<T> nodeListIterable(final NodeList nl, final Class<? extends T> outType) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    int i = 0;
                    int n;
                    {
                        this.n = nl != null ? nl.getLength() : 0;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i < this.n;
                    }

                    @Override
                    public T next() {
                        if (this.i == this.n) {
                            throw new NoSuchElementException();
                        }
                        return (Node)outType.cast(nl.item(this.i++));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static FilePosition getFilePositionFor(Node node) {
        FilePosition pos = (FilePosition)node.getUserData(FP_KEY);
        if (pos != null) {
            return pos;
        }
        return UNKNOWN_START_OF_FILE;
    }

    public static FilePosition getFilePositionForValue(Attr a) {
        return Nodes.getFilePositionFor(a.getFirstChild());
    }

    public static void setFilePositionFor(Node node, FilePosition pos) {
        node.setUserData(FP_KEY, pos, null);
    }

    public static void setFilePositionForValue(Attr a, FilePosition pos) {
        Nodes.setFilePositionFor(a.getFirstChild(), pos);
    }

    public static void markAsHavingXmlnsDeclaration(Element el) {
        el.setUserData(HAS_XMLNS_DECLARATION_KEY, Boolean.TRUE, HAS_XMLNS_DECLARATION_DATA_HANDLER);
    }

    public static boolean hasXmlnsDeclaration(Element el) {
        return Boolean.TRUE.equals(el.getUserData(HAS_XMLNS_DECLARATION_KEY));
    }

    public static void setRawValue(Attr a, String html) {
        Nodes.setRawText((Text)a.getFirstChild(), html);
    }

    public static String getRawValue(Attr a) {
        return Nodes.getRawText((Text)a.getFirstChild());
    }

    public static void setRawText(Text cd, String html) {
        cd.setUserData(RAW_TEXT_KEY, html, null);
    }

    public static String getRawText(Text cd) {
        return (String)cd.getUserData(RAW_TEXT_KEY);
    }

    public static String decode(String html) {
        if (html.indexOf(38) < 0) {
            return html;
        }
        char[] chars = html.toCharArray();
        int delta = 0;
        int n = chars.length;
        int i = 0;
        while (i < n) {
            char ch = chars[i];
            if (chars[i] == '&') {
                long packedEndAndCodepoint = HtmlEntities.decodeEntityAt(chars, i, n);
                int end = (int)(packedEndAndCodepoint >>> 32);
                if (end != i + 1) {
                    int codepoint = (int)packedEndAndCodepoint & 0xFFFFFF;
                    delta += end - (i + Character.toChars(codepoint, chars, i - delta));
                    i = end;
                    continue;
                }
                chars[i - delta] = ch;
                ++i;
                continue;
            }
            chars[i - delta] = ch;
            ++i;
        }
        if (delta == 0) {
            return html;
        }
        return String.valueOf(chars, 0, n - delta);
    }

    public static String encode(String raw) {
        StringBuilder sb = new StringBuilder(raw.length() * 3 / 2);
        Escaping.escapeXml((CharSequence)raw, false, sb);
        return sb.toString();
    }

    public static void render(Node node, Namespaces ns, RenderContext rc) {
        Nodes.render(node, ns, rc, false);
    }

    @Deprecated
    public static void renderUnsafe(DocumentType docType, Node node, Namespaces ns, RenderContext rc) {
        Nodes.render(docType, node, ns, rc, true);
    }

    public static void render(DocumentType docType, Node node, Namespaces ns, RenderContext rc) {
        Nodes.render(docType, node, ns, rc, false);
    }

    @Deprecated
    public static void renderUnsafe(Node node, Namespaces ns, RenderContext rc) {
        Nodes.render(node, ns, rc, true);
    }

    private static void render(Node node, Namespaces ns, RenderContext rc, boolean renderUnsafe) {
        Nodes.render(null, node, ns, rc, renderUnsafe);
    }

    private static void render(DocumentType docType, Node node, Namespaces ns, RenderContext rc, boolean renderUnsafe) {
        String rendering;
        StringBuilder sb = new StringBuilder(262144);
        if (null != docType && null != (rendering = Nodes.renderDocumentType(docType))) {
            sb.append(rendering);
        }
        new Renderer(sb, rc.markupRenderMode(), rc.isAsciiOnly(), ns).render(node, ns, renderUnsafe);
        TokenConsumer out = rc.getOut();
        FilePosition pos = Nodes.getFilePositionFor(node);
        out.mark(FilePosition.startOf(pos));
        out.consume(sb.toString());
        out.mark(FilePosition.endOf(pos));
    }

    @Nullable
    private static String renderDocumentType(DocumentType docType) {
        String publicId = docType.getPublicId();
        String systemId = docType.getSystemId();
        if (null == docType.getOwnerDocument() || null == docType.getOwnerDocument().getDocumentElement() || null == docType.getOwnerDocument().getDocumentElement().getNodeName()) {
            return null;
        }
        String nodeName = docType.getOwnerDocument().getDocumentElement().getNodeName();
        if (!DoctypeMaker.isHtml(nodeName, publicId, systemId)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE ").append(nodeName);
        if (null != publicId && publicId.length() > 0) {
            sb.append(" PUBLIC ").append('\"').append(publicId.replaceAll("\"", "%22")).append('\"');
        }
        if (null != systemId && systemId.length() > 0) {
            try {
                URI u = new URI(systemId);
                if (u.isAbsolute() && ("http".equals(u.getScheme()) || "https".equals(u.getScheme()))) {
                    sb.append(" ").append('\"').append(systemId.replaceAll("\"", "%22")).append('\"');
                }
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        sb.append(">");
        return sb.toString();
    }

    public static void render(Node node, RenderContext rc) {
        Nodes.render(node, rc, false);
    }

    @Deprecated
    public static void renderUnsafe(Node node, RenderContext rc) {
        Nodes.render(node, Namespaces.HTML_DEFAULT, rc, true);
    }

    private static void render(Node node, RenderContext rc, boolean renderUnsafe) {
        Nodes.render(node, Namespaces.HTML_DEFAULT, rc, renderUnsafe);
    }

    public static String render(Node node) {
        return Nodes.render(node, false);
    }

    @Deprecated
    public static String renderUnsafe(Node node) {
        return Nodes.renderUnsafe(node, MarkupRenderMode.HTML);
    }

    @Deprecated
    public static String render(Node node, boolean asXml) {
        return Nodes.render(node, asXml ? MarkupRenderMode.XML : MarkupRenderMode.HTML);
    }

    public static String render(Node node, MarkupRenderMode renderMode) {
        return Nodes.render(node, renderMode, false);
    }

    @Deprecated
    public static String renderUnsafe(Node node, MarkupRenderMode renderMode) {
        return Nodes.render(node, renderMode, true);
    }

    private static String render(Node node, MarkupRenderMode renderMode, boolean renderUnsafe) {
        StringBuilder sb = new StringBuilder();
        RenderContext rc = new RenderContext(new Concatenator(sb, null)).withMarkupRenderMode(renderMode);
        Nodes.render(node, rc, renderUnsafe);
        rc.getOut().noMoreTokens();
        return sb.toString();
    }

    public static String render(DocumentType docType, Node node, MarkupRenderMode renderMode) {
        return Nodes.render(docType, node, renderMode, false);
    }

    @Deprecated
    public static String renderUnsafe(DocumentType docType, Node node, MarkupRenderMode renderMode) {
        return Nodes.render(docType, node, renderMode, true);
    }

    private static String render(DocumentType docType, Node node, MarkupRenderMode renderMode, boolean renderUnsafe) {
        String rendering;
        StringBuilder sb = new StringBuilder();
        if (null != docType && null != (rendering = Nodes.renderDocumentType(docType))) {
            sb.append(rendering);
        }
        sb.append(Nodes.render(node, renderMode, renderUnsafe));
        return sb.toString();
    }

    private Nodes() {
    }
}

