/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.parser.AbstractParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.JsonMLCompatible;
import com.google.caja.parser.js.NoChildren;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Callback;
import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.TagAttr;
import com.google.javascript.jscomp.jsonml.TagType;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Directive
extends AbstractParseTreeNode
implements JsonMLCompatible {
    private static final long serialVersionUID = 946831596035589021L;
    private final String directiveString;

    @ParseTreeNode.ReflectiveCtor
    public Directive(FilePosition pos, String directiveString, List<NoChildren> children) {
        this(pos, directiveString);
    }

    public Directive(FilePosition pos, String directiveString) {
        super(pos);
        if (directiveString == null) {
            throw new NullPointerException();
        }
        this.directiveString = directiveString;
    }

    @Override
    protected void childrenChanged() {
        super.childrenChanged();
        if (!this.children().isEmpty()) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public String getValue() {
        return this.directiveString;
    }

    public String getDirectiveString() {
        return this.directiveString;
    }

    @Override
    public void render(RenderContext rc) {
        StringBuilder escaped = new StringBuilder();
        escaped.append('\'');
        Escaping.escapeJsString((CharSequence)this.getValue(), true, true, escaped);
        escaped.append('\'');
        String escapedString = escaped.toString();
        if (!escapedString.contains(this.directiveString)) {
            return;
        }
        rc.getOut().consume(escapedString);
        rc.getOut().consume(";");
    }

    @Override
    public final TokenConsumer makeRenderer(Appendable out, Callback<IOException> exHandler) {
        return new JsPrettyPrinter(new Concatenator(out, exHandler));
    }

    @Override
    public JsonML toJsonML() {
        return JsonMLCompatible.JsonMLBuilder.builder(TagType.PrologueDecl, this.getFilePosition()).setAttribute(TagAttr.VALUE, StringLiteral.unescapeJsString(this.getValue())).setAttribute(TagAttr.DIRECTIVE, this.getDirectiveString()).build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RecognizedValue {
        USE_STRICT("use strict"),
        USE_CAJITA("use cajita");

        private final String directiveString;

        private RecognizedValue(String directiveString) {
            this.directiveString = directiveString;
        }

        public String getDirectiveString() {
            return this.directiveString;
        }

        public static boolean isDirectiveStringRecognized(String directiveString) {
            for (RecognizedValue v : RecognizedValue.values()) {
                if (!v.directiveString.equals(directiveString)) continue;
                return true;
            }
            return false;
        }
    }
}

