/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.BooleanLiteral;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.JsonMLCompatible;
import com.google.caja.parser.js.Loop;
import com.google.caja.parser.js.MultiDeclaration;
import com.google.caja.parser.js.NestedScope;
import com.google.caja.parser.js.Noop;
import com.google.caja.parser.js.Statement;
import com.google.caja.render.JsMinimalPrinter;
import com.google.caja.reporting.RenderContext;
import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.TagType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ForLoop
extends Loop
implements NestedScope {
    private static final long serialVersionUID = 295928890053083020L;
    private Statement initializer;
    private Expression condition;
    private Statement increment;
    private Statement body;

    @ParseTreeNode.ReflectiveCtor
    public ForLoop(FilePosition pos, String value, List<? extends ParseTreeNode> children) {
        this(pos, value, (Statement)children.get(0), (Expression)children.get(1), (Statement)children.get(2), (Statement)children.get(3));
    }

    public ForLoop(FilePosition pos, String label, Statement initializer, Expression cond, Statement increment, Statement body) {
        super(pos, label, ParseTreeNode.class);
        this.createMutation().appendChild(initializer).appendChild(cond).appendChild(increment).appendChild(body).execute();
    }

    @Override
    protected void childrenChanged() {
        super.childrenChanged();
        List<? extends ParseTreeNode> children = this.children();
        this.initializer = (Statement)children.get(0);
        if (!(this.initializer instanceof Declaration || this.initializer instanceof ExpressionStmt || this.initializer instanceof MultiDeclaration || this.initializer instanceof Noop)) {
            throw new IllegalArgumentException("" + this.initializer);
        }
        this.condition = (Expression)children.get(1);
        this.increment = (Statement)children.get(2);
        this.body = (Statement)children.get(3);
    }

    @Override
    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public Statement getBody() {
        return this.body;
    }

    public Statement getInitializer() {
        return this.initializer;
    }

    public Statement getIncrement() {
        return this.increment;
    }

    @Override
    public void render(RenderContext rc) {
        TokenConsumer out = rc.getOut();
        out.mark(this.getFilePosition());
        String label = this.getRenderedLabel(rc);
        if (null != label) {
            out.consume(label);
            out.consume(":");
        }
        out.consume("for");
        out.consume("(");
        if (!(this.initializer instanceof Noop)) {
            this.initializer.render(rc);
        }
        out.consume(JsMinimalPrinter.NOOP);
        if (!(this.condition instanceof BooleanLiteral) || !((BooleanLiteral)this.condition).value) {
            this.condition.render(rc);
        }
        out.consume(JsMinimalPrinter.NOOP);
        if (!(this.increment instanceof Noop)) {
            this.increment.render(rc);
        }
        out.consume(")");
        this.getBody().renderBlock(rc, false);
    }

    @Override
    public boolean hasHangingConditional() {
        return this.body.hasHangingConditional();
    }

    @Override
    public JsonML toJsonML() {
        return this.wrapIfLabelled(JsonMLCompatible.JsonMLBuilder.builder(TagType.ForStmt, this.getFilePosition()).addChild(this.initializer).addChild(this.condition).addChild(this.increment).addChild(this.body).build());
    }
}

