/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.Keyword;
import com.google.caja.lexer.SourceBreaks;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodes;
import com.google.caja.parser.ParserBase;
import com.google.caja.parser.js.ArrayConstructor;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.BooleanLiteral;
import com.google.caja.parser.js.BreakStmt;
import com.google.caja.parser.js.CaseStmt;
import com.google.caja.parser.js.CatchStmt;
import com.google.caja.parser.js.Conditional;
import com.google.caja.parser.js.ContinueStmt;
import com.google.caja.parser.js.DebuggerStmt;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.DefaultCaseStmt;
import com.google.caja.parser.js.Directive;
import com.google.caja.parser.js.DirectivePrologue;
import com.google.caja.parser.js.DoWhileLoop;
import com.google.caja.parser.js.Elision;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.FinallyStmt;
import com.google.caja.parser.js.ForEachLoop;
import com.google.caja.parser.js.ForLoop;
import com.google.caja.parser.js.FormalParam;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.FunctionDeclaration;
import com.google.caja.parser.js.GetterProperty;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.LabeledStatement;
import com.google.caja.parser.js.LabeledStmtWrapper;
import com.google.caja.parser.js.MultiDeclaration;
import com.google.caja.parser.js.Noop;
import com.google.caja.parser.js.NullLiteral;
import com.google.caja.parser.js.ObjProperty;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.OperatorType;
import com.google.caja.parser.js.RealLiteral;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.RegexpLiteral;
import com.google.caja.parser.js.ReturnStmt;
import com.google.caja.parser.js.SetterProperty;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.SwitchCase;
import com.google.caja.parser.js.SwitchStmt;
import com.google.caja.parser.js.ThrowStmt;
import com.google.caja.parser.js.TryStmt;
import com.google.caja.parser.js.ValueProperty;
import com.google.caja.parser.js.WhileLoop;
import com.google.caja.parser.js.WithStmt;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.TagAttr;
import com.google.javascript.jscomp.jsonml.TagType;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonMLConverter {
    private static final Expression[] NO_EXPRS = new Expression[0];
    private final Map<String, SourceBreaks> breaksPerFile;

    public JsonMLConverter(Map<String, SourceBreaks> breaksPerFile) {
        this.breaksPerFile = Maps.newHashMap(breaksPerFile);
    }

    public ParseTreeNode toNode(JsonML jsonML) {
        return this.toNode(jsonML, ParseTreeNode.class);
    }

    public <T extends ParseTreeNode> T toNode(JsonML jsonML, Class<T> clazz) {
        ParseTreeNode node = this.toParseTreeNode(jsonML);
        if (Statement.class == clazz && node instanceof Expression) {
            node = new ExpressionStmt((Expression)node);
        }
        return (T)((ParseTreeNode)clazz.cast(node));
    }

    private ParseTreeNode toParseTreeNode(JsonML jsonML) {
        FilePosition pos = this.positionFrom(jsonML);
        List children = jsonML.getChildren();
        switch (jsonML.getType()) {
            case ArrayExpr: {
                List<Expression> elements = Lists.newArrayList(children.size());
                for (JsonML child : children) {
                    if (child.getType() == TagType.Empty) {
                        elements.add(new Elision(pos));
                        continue;
                    }
                    elements.add(this.toNode(child, Expression.class));
                }
                return new ArrayConstructor(pos, elements);
            }
            case ObjectExpr: {
                return new ObjectConstructor(pos, this.toNodes(children, ObjProperty.class));
            }
            case AssignExpr: 
            case BinaryExpr: 
            case CountExpr: 
            case MemberExpr: 
            case UnaryExpr: {
                OperatorType opType;
                String symbol = (String)jsonML.getAttribute(TagAttr.OP);
                if ("()".equals(symbol) || "[]".equals(symbol)) {
                    opType = OperatorType.BRACKET;
                    symbol = symbol.substring(0, 1);
                } else {
                    switch (children.size()) {
                        case 1: {
                            opType = Boolean.FALSE.equals(jsonML.getAttribute(TagAttr.IS_PREFIX)) ? OperatorType.POSTFIX : OperatorType.PREFIX;
                            break;
                        }
                        case 2: {
                            opType = OperatorType.INFIX;
                            break;
                        }
                        case 3: {
                            opType = OperatorType.TERNARY;
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
                Operator op = Operator.lookupOperation(symbol, opType);
                Expression[] operands = this.toNodes(children, Expression.class).toArray(NO_EXPRS);
                if (op == Operator.MEMBER_ACCESS) {
                    String member = ((StringLiteral)operands[1]).getUnquotedValue();
                    if (ParserBase.isJavascriptIdentifier(member) && !Keyword.isKeyword(member)) {
                        operands[1] = new Reference(new Identifier(operands[1].getFilePosition(), member));
                    } else {
                        op = Operator.SQUARE_BRACKET;
                    }
                }
                return Operation.create(pos, op, operands);
            }
            case CallExpr: {
                return Operation.create(pos, Operator.FUNCTION_CALL, this.toNodes(children, Expression.class).toArray(NO_EXPRS));
            }
            case ConditionalExpr: {
                return Operation.create(pos, Operator.TERNARY, this.toNodes(children, Expression.class).toArray(NO_EXPRS));
            }
            case DeleteExpr: {
                return Operation.create(pos, Operator.DELETE, this.toNodes(children, Expression.class).toArray(NO_EXPRS));
            }
            case EvalExpr: {
                Expression[] operands = new Expression[children.size() + 1];
                this.toNodes(children, Expression.class).toArray(operands);
                System.arraycopy(operands, 0, operands, 1, children.size());
                operands[0] = new Reference(new Identifier(FilePosition.startOf(pos), "eval"));
                return Operation.create(pos, Operator.FUNCTION_CALL, operands);
            }
            case InvokeExpr: {
                String name;
                Expression obj = this.toNode((JsonML)children.get(0), Expression.class);
                Expression key = this.toNode((JsonML)children.get(1), Expression.class);
                Operator op = Operator.SQUARE_BRACKET;
                if (".".equals(jsonML.getAttribute(TagAttr.OP)) && ParserBase.isJavascriptIdentifier(name = ((StringLiteral)key).getUnquotedValue()) && !Keyword.isKeyword(name)) {
                    key = new Reference(new Identifier(key.getFilePosition(), name));
                    op = Operator.MEMBER_ACCESS;
                }
                List<Expression> operands = Lists.newArrayList(children.size() - 1);
                operands.add(Operation.create(FilePosition.span(obj.getFilePosition(), key.getFilePosition()), op, obj, key));
                operands.addAll(this.toNodes(children.subList(2, children.size()), Expression.class));
                return Operation.create(pos, Operator.FUNCTION_CALL, operands.toArray(NO_EXPRS));
            }
            case LogicalAndExpr: {
                return Operation.create(pos, Operator.LOGICAL_AND, this.toNodes(children, Expression.class).toArray(NO_EXPRS));
            }
            case LogicalOrExpr: {
                return Operation.create(pos, Operator.LOGICAL_OR, this.toNodes(children, Expression.class).toArray(NO_EXPRS));
            }
            case NewExpr: {
                int n = children.size();
                Expression ctor = this.toNode((JsonML)children.get(0), Expression.class);
                List<Expression> operands = Lists.newArrayList(n);
                operands.add(Operation.create(ctor.getFilePosition(), Operator.CONSTRUCTOR, ctor));
                operands.addAll(this.toNodes(children.subList(1, n), Expression.class));
                return Operation.create(pos, Operator.FUNCTION_CALL, operands.toArray(NO_EXPRS));
            }
            case TypeofExpr: {
                return Operation.create(pos, Operator.TYPEOF, this.toNodes(children, Expression.class).toArray(NO_EXPRS));
            }
            case LiteralExpr: {
                String type = (String)jsonML.getAttribute(TagAttr.TYPE);
                if ("string".equals(type)) {
                    return new StringLiteral(pos, StringLiteral.toQuotedValue((String)jsonML.getAttribute(TagAttr.VALUE)));
                }
                if ("boolean".equals(type)) {
                    return new BooleanLiteral(pos, (Boolean)jsonML.getAttribute(TagAttr.VALUE));
                }
                if ("number".equals(type)) {
                    Number number = (Number)jsonML.getAttribute(TagAttr.VALUE);
                    if (number instanceof Integer) {
                        return new IntegerLiteral(pos, number.intValue());
                    }
                    return new RealLiteral(pos, number.doubleValue());
                }
                if ("null".equals(type)) {
                    return new NullLiteral(pos);
                }
                throw new IllegalArgumentException(type);
            }
            case RegExpExpr: {
                String flags = (String)jsonML.getAttribute(TagAttr.FLAGS);
                if (flags == null) {
                    flags = "";
                }
                String regex = "/" + jsonML.getAttribute(TagAttr.BODY) + "/" + flags;
                return new RegexpLiteral(pos, regex);
            }
            case ThisExpr: {
                return new Reference(new Identifier(pos, "this"));
            }
            case BlockStmt: 
            case Program: {
                return new Block(pos, this.toNodes(children, Statement.class));
            }
            case BreakStmt: {
                String label = (String)jsonML.getAttribute(TagAttr.LABEL);
                if (label == null) {
                    label = "";
                }
                return new BreakStmt(pos, label);
            }
            case ContinueStmt: {
                String label = (String)jsonML.getAttribute(TagAttr.LABEL);
                if (label == null) {
                    label = "";
                }
                return new ContinueStmt(pos, label);
            }
            case DebuggerStmt: {
                return new DebuggerStmt(pos);
            }
            case DoWhileStmt: {
                return new DoWhileLoop(pos, "", this.toNode((JsonML)children.get(0), Statement.class), this.toNode((JsonML)children.get(1), Expression.class));
            }
            case EmptyStmt: {
                return new Noop(pos);
            }
            case ForInStmt: {
                if (((JsonML)children.get(0)).getType() == TagType.VarDecl) {
                    return new ForEachLoop(pos, "", this.toNode((JsonML)children.get(0), Declaration.class), this.toNode((JsonML)children.get(1), Expression.class), this.toNode((JsonML)children.get(2), Statement.class));
                }
                return new ForEachLoop(pos, "", this.toNode((JsonML)children.get(0), Expression.class), this.toNode((JsonML)children.get(1), Expression.class), this.toNode((JsonML)children.get(2), Statement.class));
            }
            case ForStmt: {
                return new ForLoop(pos, "", this.toNodeOrNoop((JsonML)children.get(0)), this.toNodeOrTrue((JsonML)children.get(1)), this.toNodeOrNoop((JsonML)children.get(2)), this.toNode((JsonML)children.get(3), Statement.class));
            }
            case FunctionExpr: {
                return this.toFunctionConstructor(jsonML);
            }
            case IdExpr: {
                return new Reference(new Identifier(pos, (String)jsonML.getAttribute(TagAttr.NAME)));
            }
            case IfStmt: {
                Expression cond = this.toNode((JsonML)children.get(0), Expression.class);
                Statement thenClause = this.toNode((JsonML)children.get(1), Statement.class);
                Statement elseClause = ((JsonML)children.get(2)).getType() != TagType.EmptyStmt ? this.toNode((JsonML)children.get(2), Statement.class) : null;
                List<Object> childNodes = Lists.newArrayList();
                childNodes.add(cond);
                childNodes.add(thenClause);
                if (elseClause != null) {
                    if (elseClause instanceof Conditional) {
                        childNodes.addAll(elseClause.children());
                    } else {
                        childNodes.add(elseClause);
                    }
                }
                return new Conditional(pos, null, childNodes);
            }
            case LabelledStmt: {
                String label = (String)jsonML.getAttribute(TagAttr.LABEL);
                Statement body = this.toNode((JsonML)children.get(0), Statement.class);
                if (body instanceof LabeledStatement && !(body instanceof LabeledStmtWrapper)) {
                    return ParseTreeNodes.newNodeInstance(body.getClass(), body.getFilePosition(), label, body.children());
                }
                return new LabeledStmtWrapper(pos, label, body);
            }
            case ReturnStmt: {
                if (children.isEmpty()) {
                    return new ReturnStmt(pos, null);
                }
                return new ReturnStmt(pos, this.toNode((JsonML)children.get(0), Expression.class));
            }
            case SwitchStmt: {
                return new SwitchStmt(pos, "", this.toNode((JsonML)children.get(0), Expression.class), this.toNodes(children.subList(1, children.size()), SwitchCase.class));
            }
            case ThrowStmt: {
                return new ThrowStmt(pos, this.toNode((JsonML)children.get(0), Expression.class));
            }
            case TryStmt: {
                Block body = this.toNode((JsonML)children.get(0), Block.class);
                CatchStmt catchStmt = null;
                FinallyStmt finallyStmt = null;
                int i = 1;
                int n = children.size();
                if (((JsonML)children.get(i)).getType() == TagType.CatchClause) {
                    catchStmt = this.toNode((JsonML)children.get(i++), CatchStmt.class);
                } else if (((JsonML)children.get(i)).getType() == TagType.Empty) {
                    ++i;
                }
                if (i < n) {
                    Block block = this.toNode((JsonML)children.get(i), Block.class);
                    finallyStmt = new FinallyStmt(block.getFilePosition(), block);
                }
                return new TryStmt(pos, body, catchStmt, finallyStmt);
            }
            case WhileStmt: {
                return new WhileLoop(pos, "", this.toNode((JsonML)children.get(0), Expression.class), this.toNode((JsonML)children.get(1), Statement.class));
            }
            case WithStmt: {
                return new WithStmt(pos, this.toNode((JsonML)children.get(0), Expression.class), this.toNode((JsonML)children.get(1), Statement.class));
            }
            case FunctionDecl: {
                return new FunctionDeclaration(this.toFunctionConstructor(jsonML));
            }
            case ParamDecl: {
                throw new IllegalStateException("Orphaned param");
            }
            case PrologueDecl: {
                throw new IllegalStateException("Orphaned prologue");
            }
            case VarDecl: {
                List<Declaration> decls = Lists.newArrayList();
                for (JsonML child : children) {
                    FilePosition childPos = this.positionFrom(child);
                    if (child.getType() == TagType.InitPatt) {
                        List initPattParts = child.getChildren();
                        decls.add(new Declaration(childPos, this.toNode((JsonML)initPattParts.get(0), Identifier.class), this.toNode((JsonML)initPattParts.get(1), Expression.class)));
                        continue;
                    }
                    decls.add(new Declaration(childPos, this.toNode(child, Identifier.class), null));
                }
                if (decls.size() == 1) {
                    return (ParseTreeNode)decls.get(0);
                }
                return new MultiDeclaration(pos, decls);
            }
            case DataProp: {
                return new ValueProperty(pos, StringLiteral.valueOf(FilePosition.span(pos, this.positionFrom((JsonML)children.get(0))), (String)jsonML.getAttribute(TagAttr.NAME)), this.toNode((JsonML)children.get(0), Expression.class));
            }
            case GetterProp: {
                return new GetterProperty(pos, StringLiteral.valueOf(FilePosition.span(pos, this.positionFrom((JsonML)children.get(0))), (String)jsonML.getAttribute(TagAttr.NAME)), this.toFunctionConstructor((JsonML)children.get(0)));
            }
            case SetterProp: {
                return new SetterProperty(pos, StringLiteral.valueOf(FilePosition.span(pos, this.positionFrom((JsonML)children.get(0))), (String)jsonML.getAttribute(TagAttr.NAME)), this.toFunctionConstructor((JsonML)children.get(0)));
            }
            case IdPatt: {
                return new Identifier(pos, (String)jsonML.getAttribute(TagAttr.NAME));
            }
            case InitPatt: {
                throw new IllegalStateException("Orphaned init patt");
            }
            case Case: {
                Expression value = this.toNode((JsonML)children.get(0), Expression.class);
                int n = children.size();
                List<Statement> body = this.toNodes(children.subList(1, n), Statement.class);
                FilePosition bodyPos = body.isEmpty() ? FilePosition.span(FilePosition.endOf(value.getFilePosition()), pos) : FilePosition.span(FilePosition.startOf(body.get(0).getFilePosition()), pos);
                return new CaseStmt(pos, value, new Block(bodyPos, body));
            }
            case DefaultCase: {
                List<Statement> body = this.toNodes(children, Statement.class);
                FilePosition bodyPos = body.isEmpty() ? pos : FilePosition.span(FilePosition.startOf(body.get(0).getFilePosition()), pos);
                return new DefaultCaseStmt(pos, new Block(bodyPos, body));
            }
            case CatchClause: {
                Identifier exName = this.toNode((JsonML)children.get(0), Identifier.class);
                return new CatchStmt(pos, new Declaration(exName.getFilePosition(), exName, null), this.toNode((JsonML)children.get(1), Block.class));
            }
            case Empty: {
                throw new IllegalStateException("Orphaned empty");
            }
        }
        return null;
    }

    private FilePosition positionFrom(JsonML jsonML) {
        SourceBreaks breaks = this.breaksPerFile.get(jsonML.getAttribute(TagAttr.SOURCE));
        if (breaks == null) {
            return FilePosition.UNKNOWN;
        }
        int pos = (Integer)jsonML.getAttribute(TagAttr.OPAQUE_POSITION);
        int start = pos >>> 16;
        return breaks.toFilePosition(start, (pos & 0xFFF) + start);
    }

    private Expression toNodeOrTrue(JsonML jsonML) {
        if (jsonML.getType() == TagType.Empty) {
            return new BooleanLiteral(this.positionFrom(jsonML), true);
        }
        return this.toNode(jsonML, Expression.class);
    }

    private Statement toNodeOrNoop(JsonML jsonML) {
        if (jsonML.getType() == TagType.Empty) {
            return new Noop(this.positionFrom(jsonML));
        }
        return this.toNode(jsonML, Statement.class);
    }

    private <T extends ParseTreeNode> List<T> toNodes(List<? extends JsonML> jsonMLs, Class<T> clazz) {
        int n = jsonMLs.size();
        if (n == 0) {
            return Collections.emptyList();
        }
        List<T> out = Lists.newArrayList(n);
        int i = 0;
        if (jsonMLs.get(0).getType() == TagType.PrologueDecl) {
            FilePosition end;
            FilePosition start = null;
            List<Directive> directives = Lists.newArrayList();
            do {
                JsonML decl = jsonMLs.get(i++);
                end = this.positionFrom(decl);
                if (start == null) {
                    start = end;
                }
                directives.add(new Directive(end, (String)decl.getAttribute(TagAttr.DIRECTIVE)));
            } while (i < n && jsonMLs.get(i).getType() == TagType.PrologueDecl);
            DirectivePrologue directive = new DirectivePrologue(FilePosition.span(start, end), null, directives);
            out.add(clazz.cast(directive));
        }
        while (i < n) {
            out.add(this.toNode(jsonMLs.get(i++), clazz));
        }
        return out;
    }

    private FunctionConstructor toFunctionConstructor(JsonML jsonML) {
        FilePosition blockEnd;
        FilePosition pos = this.positionFrom(jsonML);
        List children = jsonML.getChildren();
        JsonML name = (JsonML)children.get(0);
        Identifier nameNode = name.getType() == TagType.Empty ? new Identifier(this.positionFrom(name), null) : this.toNode(name, Identifier.class);
        List<FormalParam> params = Lists.newArrayList();
        for (JsonML param : ((JsonML)children.get(1)).getChildren()) {
            params.add(new FormalParam(this.toNode(param, Identifier.class)));
        }
        FilePosition blockStart = blockEnd = FilePosition.endOf(pos);
        List<Statement> bodyParts = this.toNodes(children.subList(2, children.size()), Statement.class);
        if (!bodyParts.isEmpty()) {
            blockStart = bodyParts.get(0).getFilePosition();
        }
        Block body = new Block(FilePosition.span(blockStart, blockEnd), bodyParts);
        return new FunctionConstructor(pos, nameNode, params, body);
    }
}

