/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral.opt;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.CatchStmt;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ForEachLoop;
import com.google.caja.parser.js.FormalParam;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.NumberLiteral;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.quasiliteral.opt.ScopeTree;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayIndexOptimization {
    private static final EnumSet<Operator> NUMERIC_OPERATORS = EnumSet.noneOf(Operator.class);

    public static void optimize(ParseTreeNode root) {
        ScopeTree scopeRoot = ScopeTree.create(AncestorChain.instance(root));
        ArrayIndexOptimization.optimize(root, scopeRoot);
    }

    public static boolean hasNumericResult(Expression e) {
        return "number".equals(e.typeOf());
    }

    private static void optimize(ParseTreeNode node, ScopeTree t) {
        HashSet<String> expanding;
        Expression expression;
        Operation op;
        if (node instanceof Operation && (op = (Operation)node).getOperator() == Operator.SQUARE_BRACKET && ArrayIndexOptimization.isVisiblePropertyExpr(expression = op.children().get(1), t, expanding = new HashSet<String>())) {
            Operation numIndex = Operation.create(expression.getFilePosition(), Operator.TO_NUMBER, expression);
            numIndex.setFilePosition(expression.getFilePosition());
            op.replaceChild(numIndex, expression);
        }
        for (ParseTreeNode parseTreeNode : node.children()) {
            ArrayIndexOptimization.optimize(parseTreeNode, t.scopeForChild(parseTreeNode));
        }
    }

    static boolean doesVarReferenceVisibleProperty(Reference r, ScopeTree scopeTree, Set<String> identifiersExpanding) {
        if (!scopeTree.isSymbolDeclared(r.getIdentifierName())) {
            return false;
        }
        for (AncestorChain<Identifier> use : scopeTree.usesOf(r.getIdentifierName())) {
            Expression init;
            if (use.parent.node instanceof Reference) {
                Operation operation;
                Operator op;
                AncestorChain<? extends ParseTreeNode> gp = use.parent.parent;
                if (ArrayIndexOptimization.isKeyReceiver(use.parent)) {
                    return false;
                }
                if (!(gp.node instanceof Operation) || use.parent.node != gp.node.children().get(0) || !((op = (operation = (Operation)gp.cast(Operation.class).node).getOperator()) == Operator.ASSIGN ? !ArrayIndexOptimization.isVisiblePropertyExpr(operation.children().get(1), scopeTree, identifiersExpanding) : op.getAssignmentDelegate() != null && !ArrayIndexOptimization.isNumberOrUndefOperator(op.getAssignmentDelegate()))) continue;
                return false;
            }
            if (!(use.parent.node instanceof Declaration)) continue;
            Declaration d = (Declaration)use.parent.node;
            if (d instanceof FormalParam) {
                return false;
            }
            if (use.parent.parent.node instanceof CatchStmt) {
                return false;
            }
            if (!(d.getInitializer() != null ? !ArrayIndexOptimization.isVisiblePropertyExpr(init = d.getInitializer(), scopeTree, identifiersExpanding) : ArrayIndexOptimization.isKeyReceiver(use))) continue;
            return false;
        }
        return true;
    }

    static boolean isVisiblePropertyExpr(Expression e, ScopeTree scopeTree, Set<String> identifiersExpanding) {
        Reference r;
        String name;
        if (e instanceof NumberLiteral) {
            return true;
        }
        if (e instanceof Operation) {
            Operation op = (Operation)e;
            switch (op.getOperator()) {
                case COMMA: {
                    Expression last = op.children().get(1);
                    return ArrayIndexOptimization.isVisiblePropertyExpr(last, scopeTree, identifiersExpanding);
                }
                case LOGICAL_OR: 
                case LOGICAL_AND: 
                case ADDITION: {
                    return ArrayIndexOptimization.isVisiblePropertyExpr(op.children().get(0), scopeTree, identifiersExpanding) && ArrayIndexOptimization.isVisiblePropertyExpr(op.children().get(1), scopeTree, identifiersExpanding);
                }
                case TERNARY: {
                    return ArrayIndexOptimization.isVisiblePropertyExpr(op.children().get(1), scopeTree, identifiersExpanding) && ArrayIndexOptimization.isVisiblePropertyExpr(op.children().get(2), scopeTree, identifiersExpanding);
                }
                case ASSIGN: {
                    return ArrayIndexOptimization.isVisiblePropertyExpr(op.children().get(1), scopeTree, identifiersExpanding);
                }
            }
            if (ArrayIndexOptimization.isNumberOrUndefOperator(op.getOperator())) {
                return true;
            }
        } else if (e instanceof Reference && !identifiersExpanding.contains(name = (r = (Reference)e).getIdentifierName())) {
            identifiersExpanding.add(name);
            return ArrayIndexOptimization.doesVarReferenceVisibleProperty(r, scopeTree, identifiersExpanding);
        }
        return false;
    }

    static boolean isNumberOrUndefOperator(Operator o) {
        if (o.getAssignmentDelegate() != null) {
            o = o.getAssignmentDelegate();
        }
        return o == Operator.VOID || ArrayIndexOptimization.hasNumericResult(o);
    }

    static boolean hasNumericResult(Operator o) {
        return NUMERIC_OPERATORS.contains((Object)o);
    }

    static boolean isKeyReceiver(AncestorChain<?> ac) {
        if (ac == null || ac.parent == null) {
            return false;
        }
        if (!(ac.parent.node instanceof CatchStmt)) {
            ac = ac.parent;
            if (ac.parent == null) {
                return false;
            }
            if (!(ac.parent.node instanceof ForEachLoop)) {
                return false;
            }
        }
        return ac.node == ac.parent.node.children().get(0);
    }

    static {
        Reference xref = new Reference(new Identifier(FilePosition.UNKNOWN, "x"));
        for (Operator o : Operator.values()) {
            Object[] operands = new Reference[o.getType().getArity()];
            Arrays.fill(operands, xref);
            Operation operation = Operation.create(FilePosition.UNKNOWN, o, (Expression[])operands);
            if (!"number".equals(operation.typeOf())) continue;
            NUMERIC_OPERATORS.add(o);
        }
    }
}

