/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.Visitor;
import com.google.caja.parser.css.CssTree;
import com.google.caja.parser.js.ArrayConstructor;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.plugin.EmbeddedJsExpressionTokenConsumer;
import com.google.caja.plugin.JsExpressionUriLiteral;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.SuffixedClassOrIdLiteral;
import com.google.caja.plugin.UnsafeUriLiteral;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Strings;
import java.util.Collections;
import javax.annotation.Nullable;

public final class CssDynamicExpressionRewriter {
    @Nullable
    private final String gadgetNameSuffix;

    public CssDynamicExpressionRewriter(PluginMeta meta) {
        String idSuffix;
        this.gadgetNameSuffix = idSuffix = meta.getIdClass();
    }

    public void rewriteCss(CssTree.StyleSheet ss) {
        this.rewriteIds(ss);
        this.restrictRulesToSubtreeWithGadgetClass(ss);
        this.rewriteUnsafeUriLiteralsToExpressions(ss);
    }

    private void rewriteIds(CssTree.StyleSheet ss) {
        ss.acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ancestors) {
                Object node = ancestors.node;
                if (!(node instanceof CssTree.SimpleSelector)) {
                    return true;
                }
                CssTree.SimpleSelector ss = (CssTree.SimpleSelector)node;
                for (CssTree cssTree : ss.children()) {
                    if (!(cssTree instanceof CssTree.IdLiteral)) continue;
                    CssTree.IdLiteral idLit = (CssTree.IdLiteral)cssTree;
                    if (CssDynamicExpressionRewriter.this.gadgetNameSuffix != null) {
                        idLit.setValue("#" + idLit.getValue().substring(1) + "-" + CssDynamicExpressionRewriter.this.gadgetNameSuffix);
                        continue;
                    }
                    ss.replaceChild(new SuffixedClassOrIdLiteral(idLit.getFilePosition(), "#" + idLit.getValue().substring(1) + "-"), idLit);
                }
                return true;
            }
        }, null);
    }

    private void restrictRulesToSubtreeWithGadgetClass(CssTree.StyleSheet ss) {
        ss.acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ancestors) {
                CssTree.CssLiteral restrictClass;
                Object node = ancestors.node;
                if (!(node instanceof CssTree.Selector)) {
                    return true;
                }
                CssTree.Selector sel = (CssTree.Selector)node;
                CssTree.SimpleSelector baseSelector = (CssTree.SimpleSelector)sel.children().get(0);
                boolean baseIsDescendant = true;
                if (CssDynamicExpressionRewriter.selectorMatchesElement(baseSelector, "body")) {
                    CssTree.IdentLiteral elName = (CssTree.IdentLiteral)baseSelector.children().get(0);
                    baseSelector.replaceChild(new CssTree.ClassLiteral(elName.getFilePosition(), ".vdoc-body___"), elName);
                    baseIsDescendant = false;
                }
                FilePosition pos = FilePosition.endOf(baseSelector.getFilePosition());
                CssTree.CssLiteral cssLiteral = restrictClass = CssDynamicExpressionRewriter.this.gadgetNameSuffix != null ? new CssTree.ClassLiteral(pos, "." + CssDynamicExpressionRewriter.this.gadgetNameSuffix) : new SuffixedClassOrIdLiteral(pos, ".");
                if (baseIsDescendant) {
                    CssTree.Combination op = new CssTree.Combination(pos, CssTree.Combinator.DESCENDANT);
                    CssTree.SimpleSelector restrictSel = new CssTree.SimpleSelector(pos, Collections.singletonList(restrictClass));
                    sel.createMutation().insertBefore(op, baseSelector).insertBefore(restrictSel, op).execute();
                } else {
                    baseSelector.appendChild(restrictClass);
                }
                return false;
            }
        }, null);
    }

    private void rewriteUnsafeUriLiteralsToExpressions(CssTree.StyleSheet ss) {
        ss.acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ancestors) {
                Object node = ancestors.node;
                if (node instanceof UnsafeUriLiteral) {
                    UnsafeUriLiteral uul = (UnsafeUriLiteral)node;
                    CssTree parent = (CssTree)ancestors.parent.node;
                    assert (null != parent);
                    parent.replaceChild(new JsExpressionUriLiteral(uul.getFilePosition(), (Expression)QuasiBuilder.substV("IMPORTS___./*@synthetic*/rewriteUriInCss___(@uri)", "uri", StringLiteral.valueOf(uul.getFilePosition(), uul.getValue()))), uul);
                }
                return true;
            }
        }, null);
    }

    public static ArrayConstructor cssToJs(CssTree.StyleSheet ss) {
        EmbeddedJsExpressionTokenConsumer cssToJsArrayElements = new EmbeddedJsExpressionTokenConsumer();
        ss.render(new RenderContext(cssToJsArrayElements));
        cssToJsArrayElements.noMoreTokens();
        return new ArrayConstructor(ss.getFilePosition(), cssToJsArrayElements.getArrayMembers());
    }

    private static boolean selectorMatchesElement(CssTree.SimpleSelector t, String elementName) {
        return Strings.equalsIgnoreCase(elementName, t.getElementName());
    }
}

