/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.lang.css.CssSchema;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Noop;
import com.google.caja.parser.js.Statement;
import com.google.caja.plugin.JobEnvelope;
import com.google.caja.plugin.Placeholder;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.stages.JobCache;
import com.google.caja.plugin.templates.IhtmlRoot;
import com.google.caja.plugin.templates.SafeHtmlChunk;
import com.google.caja.plugin.templates.SafeJsChunk;
import com.google.caja.plugin.templates.ScriptPlaceholder;
import com.google.caja.plugin.templates.TemplateCompiler;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.ContentType;
import com.google.caja.util.Lists;
import com.google.caja.util.MoreAsserts;
import com.google.caja.util.Pair;
import com.google.caja.util.RhinoTestBed;
import com.google.caja.util.Strings;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlEmitterTest
extends CajaTestCase {
    public final void testJavascript() throws Exception {
        RhinoTestBed.runJsUnittestFromHtml(this.html(this.fromResource("html-emitter-test.html")));
    }

    public final void testCompiler() throws Exception {
        String input = "<p>Hi</p>\n<div><script>a()</script>Hello <script>b()</script>World!!!</div>\n<h1>Foo <b><script>c()</script>Bar</b> Baz</h1>\n<h2 id='x'>Boo</h2>\n";
        PluginMeta meta = new PluginMeta();
        List<ScriptPlaceholder> extractedScripts = Lists.newArrayList();
        TemplateCompiler tc = new TemplateCompiler(Collections.singletonList(new IhtmlRoot(new JobEnvelope(null, JobCache.none(), ContentType.HTML, false, null), this.htmlWithScriptsExtracted(input, extractedScripts), this.is.getUri())), Collections.emptyList(), extractedScripts, CssSchema.getDefaultCss21Schema(this.mq), HtmlSchema.getDefault(this.mq), meta, this.mc, this.mq);
        Pair<List<SafeHtmlChunk>, List<SafeJsChunk>> htmlAndJs = tc.getSafeHtml(DomParser.makeDocument(null, null));
        HtmlEmitterTest.assertEquals((String)"<p>Hi</p><div id=\"id_1___\">Hello <span id=\"id_2___\"></span>World!!!</div><h1>Foo <b id=\"id_3___\">Bar</b> Baz</h1><h2 id=\"id_4___\">Boo</h2>", (String)HtmlEmitterTest.renderAll((Iterable)htmlAndJs.a));
        List<String> jsLines = Arrays.asList("'use cajita'; /* Start translated code */", "throw 'Translated code must never be executed';", "{", "  var el___;", "  var emitter___ = IMPORTS___.htmlEmitter___;", "  el___ = emitter___.byId('id_1___');", "  emitter___.attach('id_1___');", "  el___.removeAttribute('id');", "} /* End translated code */", "try {", "  { a(); }", "} catch (ex___) {", "  ___.getNewModuleHandler().handleUncaughtException(ex___, onerror,", "    'testCompiler', '1');", "}", "'use cajita'; /* Start translated code */", "throw 'Translated code must never be executed';", "{", "  var el___;", "  var emitter___ = IMPORTS___.htmlEmitter___;", "  emitter___.discard(emitter___.attach('id_2___'));", "} /* End translated code */", "try {", "  { b(); }", "} catch (ex___) {", "  ___.getNewModuleHandler().handleUncaughtException(ex___, onerror,", "    'testCompiler', '1');", "}", "'use cajita'; /* Start translated code */", "throw 'Translated code must never be executed';", "{", "  var el___;", "  var emitter___ = IMPORTS___.htmlEmitter___;", "  el___ = emitter___.byId('id_3___');", "  emitter___.attach('id_3___');", "  el___.removeAttribute('id');", "} /* End translated code */", "try {", "  { c(); }", "} catch (ex___) {", "  ___.getNewModuleHandler().handleUncaughtException(ex___, onerror,", "    'testCompiler', '1');", "}", "'use cajita'; /* Start translated code */", "throw 'Translated code must never be executed';", "{", "  var el___;", "  var emitter___ = IMPORTS___.htmlEmitter___;", "  el___ = emitter___.byId('id_4___');", "  emitter___.setAttr(el___, 'id', 'x-' + IMPORTS___.getIdClass___());", "  el___ = emitter___.finish();", "  emitter___.signalLoaded();", "}", "/* End translated code */");
        MoreAsserts.assertListsEqual(jsLines, Arrays.asList(HtmlEmitterTest.renderConsolidated((List)htmlAndJs.b).split("\n")));
    }

    private Node htmlWithScriptsExtracted(String html, List<ScriptPlaceholder> extractedScripts) throws ParseException {
        return this.extract(this.htmlFragment(this.fromString(html)), extractedScripts);
    }

    private Node extract(Node n, List<ScriptPlaceholder> extractedScripts) throws ParseException {
        if (n.getNodeType() == 1 && Strings.equalsIgnoreCase("script", n.getNodeName())) {
            String HTML_NS = "http://www.w3.org/1999/xhtml";
            Element element = n.getOwnerDocument().createElementNS(HTML_NS, "span");
            String id = "$" + extractedScripts.size();
            element.setAttributeNS(Placeholder.ID_ATTR.ns.uri, Placeholder.ID_ATTR.localName, id);
            extractedScripts.add(new ScriptPlaceholder(new JobEnvelope(id, JobCache.none(), ContentType.JS, false, null), this.js(this.fromString(n.getFirstChild().getNodeValue()))));
            n.getParentNode().replaceChild(element, n);
            n = element;
        }
        for (Node node : Nodes.childrenOf(n)) {
            this.extract(node, extractedScripts);
        }
        return n;
    }

    private static String renderConsolidated(List<SafeJsChunk> blocks) {
        List<? extends Statement> statements = Lists.newArrayList();
        for (SafeJsChunk js : blocks) {
            for (Statement statement : ((Block)js.body).children()) {
                if (statement instanceof Noop) continue;
                if (statement instanceof Block) {
                    statements.addAll(((Block)statement).children());
                    continue;
                }
                statements.add(statement);
            }
        }
        StringBuilder sb = new StringBuilder();
        RenderContext rc = new RenderContext(new JsPrettyPrinter(new Concatenator(sb)));
        for (Statement statement : statements) {
            statement.render(rc);
            if (statement.isTerminal()) continue;
            rc.getOut().consume(";");
        }
        rc.getOut().noMoreTokens();
        return sb.toString();
    }

    private static String renderAll(Iterable<? extends SafeHtmlChunk> html) {
        StringBuilder sb = new StringBuilder();
        for (SafeHtmlChunk safeHtmlChunk : html) {
            sb.append(Nodes.render(safeHtmlChunk.root));
        }
        return sb.toString();
    }
}

