/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JsonTestServlet
extends HttpServlet {
    private static final Pair<String, String> UMP = Pair.pair("Access-Control-Allow-Origin", "*");

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        if (!"json".equals(req.getParameter("alt"))) {
            throw new ServletException("Expected alt=json");
        }
        this.respond(resp, req.getParameter("callback"), "sanityCheck", "sane", "testParam", req.getParameter("testParam"), "content", "", "contentType", "");
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        if (!"json".equals(req.getParameter("alt"))) {
            throw new ServletException("Expected alt=json");
        }
        this.respond(resp, req.getParameter("callback"), "sanityCheck", "sane", "testParam", req.getParameter("testParam"), "content", this.readInputStream(req), "contentType", req.getContentType());
    }

    private void respond(HttpServletResponse resp, String jsonpCallbackName, String ... keyValuePairs) throws ServletException {
        StringBuilder sb = new StringBuilder();
        if (jsonpCallbackName != null) {
            sb.append(jsonpCallbackName + "(");
        }
        sb.append("{");
        int i = 0;
        while (i < keyValuePairs.length) {
            sb.append("\"" + keyValuePairs[i++] + "\":");
            sb.append("\"" + keyValuePairs[i++] + "\"");
            if (i >= keyValuePairs.length) continue;
            sb.append(",");
        }
        sb.append("}");
        if (jsonpCallbackName != null) {
            sb.append(");");
        }
        this.respondString(resp, sb.toString());
    }

    private void respondString(HttpServletResponse resp, String response) throws ServletException {
        System.err.println(response);
        resp.setStatus(200);
        try {
            byte[] content = response.getBytes();
            resp.setContentType("application/json");
            resp.setContentLength(content.length);
            resp.setHeader((String)JsonTestServlet.UMP.a, (String)JsonTestServlet.UMP.b);
            resp.getOutputStream().write(content);
            resp.getOutputStream().close();
        }
        catch (IOException ex) {
            throw (ServletException)new ServletException().initCause((Throwable)ex);
        }
    }

    private String readInputStream(HttpServletRequest req) throws ServletException {
        try {
            int c;
            InputStreamReader r = new InputStreamReader((InputStream)req.getInputStream(), "UTF-8");
            StringWriter w = new StringWriter();
            while ((c = ((Reader)r).read()) != -1) {
                ((Writer)w).write((char)c);
            }
            return ((Object)w).toString();
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

