/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.lang.css.CssSchema;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.parser.quasiliteral.ModuleManager;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.PipelineMaker;
import com.google.caja.plugin.Planner;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.plugin.stages.StubJobCache;
import com.google.caja.reporting.TestBuildInfo;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.Lists;
import com.google.caja.util.MoreAsserts;
import com.google.caja.util.Pipeline;
import java.util.Arrays;
import java.util.List;

public class PipelineMakerTest
extends CajaTestCase {
    public final void testDefaultPipeline() throws Exception {
        this.assertPipeline(PipelineMaker.DEFAULT_PRECONDS, PipelineMaker.DEFAULT_GOALS, "LegacyNamespaceFixupStage", "ResolveUriStage", "RewriteHtmlStage", "InlineCssImportsStage", "SanitizeHtmlStage", "ValidateCssStage", "RewriteCssStage", "HtmlToBundleStage", "PipelineFetchStage", "OptimizeJavascriptStage", "ValidateJavascriptStage", "PipelineStoreStage", "ConsolidateCodeStage", "CheckForErrorsStage");
    }

    public final void testJsOnlyOutput() throws Exception {
        this.assertPipeline(PipelineMaker.DEFAULT_PRECONDS, PipelineMaker.DEFAULT_GOALS.without(PipelineMaker.HTML_SAFE_STATIC), "LegacyNamespaceFixupStage", "ResolveUriStage", "RewriteHtmlStage", "InlineCssImportsStage", "SanitizeHtmlStage", "ValidateCssStage", "RewriteCssStage", "HtmlToJsStage", "PipelineFetchStage", "OptimizeJavascriptStage", "ValidateJavascriptStage", "PipelineStoreStage", "ConsolidateCodeStage", "CheckForErrorsStage");
    }

    public final void testDebuggingModePipeline() throws Exception {
        this.assertPipeline(PipelineMaker.DEFAULT_PRECONDS, PipelineMaker.DEFAULT_GOALS.without(PipelineMaker.ONE_CAJOLED_MODULE).with(PipelineMaker.ONE_CAJOLED_MODULE_DEBUG), "LegacyNamespaceFixupStage", "ResolveUriStage", "RewriteHtmlStage", "InlineCssImportsStage", "SanitizeHtmlStage", "ValidateCssStage", "RewriteCssStage", "HtmlToBundleStage", "PipelineFetchStage", "OptimizeJavascriptStage", "ValidateJavascriptStage", "PipelineStoreStage", "ConsolidateCodeStage", "InferFilePositionsStage", "DebuggingSymbolsStage", "CheckForErrorsStage");
    }

    public final void testHtmlAlreadyNamespaced() throws Exception {
        this.assertPipeline(PipelineMaker.HTML_XMLNS.with(PipelineMaker.JS).with(PipelineMaker.CSS), PipelineMaker.DEFAULT_GOALS, "ResolveUriStage", "RewriteHtmlStage", "InlineCssImportsStage", "SanitizeHtmlStage", "ValidateCssStage", "RewriteCssStage", "HtmlToBundleStage", "PipelineFetchStage", "OptimizeJavascriptStage", "ValidateJavascriptStage", "PipelineStoreStage", "ConsolidateCodeStage", "CheckForErrorsStage");
    }

    public final void testJsOnly() throws Exception {
        this.assertPipeline(PipelineMaker.JS, PipelineMaker.ONE_CAJOLED_MODULE.with(PipelineMaker.SANITY_CHECK), "PipelineFetchStage", "OptimizeJavascriptStage", "ValidateJavascriptStage", "PipelineStoreStage", "ConsolidateCodeStage", "CheckForErrorsStage");
    }

    public final void testFailEarly() {
        try {
            PipelineMaker.planState("bogus");
        }
        catch (IllegalArgumentException ex) {
            PipelineMakerTest.assertEquals((String)"bogus", (String)ex.getMessage());
            return;
        }
        PipelineMakerTest.fail((String)"completed");
    }

    public final void testNoPath() {
        PipelineMaker pm = new PipelineMaker(CssSchema.getDefaultCss21Schema(this.mq), HtmlSchema.getDefault(this.mq), new ModuleManager(new PluginMeta(), TestBuildInfo.getInstance(), UriFetcher.NULL_NETWORK, false, this.mq), new StubJobCache(), PipelineMaker.HTML, PipelineMaker.CSS);
        long t0 = System.nanoTime();
        try {
            pm.populate(Lists.<Pipeline.Stage<Jobs>>newArrayList());
        }
        catch (Planner.UnsatisfiableGoalException ex) {
            long t1 = System.nanoTime();
            System.err.println("Took " + (double)(t1 - t0) / 1.0E9 + "s");
            return;
        }
        PipelineMakerTest.fail((String)"completed");
    }

    private void assertPipeline(Planner.PlanState preconds, Planner.PlanState goals, String ... expected) throws Exception {
        List<Pipeline.Stage<Jobs>> stages = Lists.newArrayList();
        PipelineMaker pm = new PipelineMaker(CssSchema.getDefaultCss21Schema(this.mq), HtmlSchema.getDefault(this.mq), new ModuleManager(new PluginMeta(), TestBuildInfo.getInstance(), UriFetcher.NULL_NETWORK, false, this.mq), new StubJobCache(), preconds, goals);
        long t0 = System.nanoTime();
        pm.populate(stages);
        long t1 = System.nanoTime();
        System.err.println("Took " + (double)(t1 - t0) / 1.0E9 + "s");
        List<String> classes = Lists.newArrayList();
        for (Pipeline.Stage<Jobs> stage : stages) {
            classes.add(stage.getClass().getSimpleName());
        }
        MoreAsserts.assertListsEqual(Arrays.asList(expected), classes);
    }
}

