/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lang.css.CssSchema;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.html.Dom;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.quasiliteral.ModuleManager;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.JobEnvelope;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.PipelineMaker;
import com.google.caja.plugin.Planner;
import com.google.caja.plugin.PluginMessageType;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.stages.JobCache;
import com.google.caja.plugin.stages.StubJobCache;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.ContentType;
import com.google.caja.util.Criterion;
import com.google.caja.util.Lists;
import com.google.caja.util.Pipeline;
import java.net.URI;
import java.util.List;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PluginCompiler {
    private final BuildInfo buildInfo;
    private final Jobs jobs;
    private Pipeline<Jobs> compilationPipeline;
    private CssSchema cssSchema;
    private HtmlSchema htmlSchema;
    private JobCache jobCache;
    private Planner.PlanState preconditions;
    private Planner.PlanState goals;

    public PluginCompiler(BuildInfo buildInfo, PluginMeta meta, MessageQueue mq) {
        this.buildInfo = buildInfo;
        this.jobs = new Jobs(new MessageContext(), mq, meta);
        this.cssSchema = CssSchema.getDefaultCss21Schema(mq);
        this.htmlSchema = HtmlSchema.getDefault(mq);
        this.jobCache = new StubJobCache();
        this.preconditions = PipelineMaker.DEFAULT_PRECONDS;
        this.goals = PipelineMaker.DEFAULT_GOALS;
    }

    public MessageQueue getMessageQueue() {
        return this.jobs.getMessageQueue();
    }

    public MessageContext getMessageContext() {
        return this.jobs.getMessageContext();
    }

    public void setMessageContext(MessageContext inputMessageContext) {
        assert (null != inputMessageContext);
        this.jobs.setMessageContext(inputMessageContext);
    }

    public PluginMeta getPluginMeta() {
        return this.jobs.getPluginMeta();
    }

    public final Planner.PlanState getPreconditions() {
        return this.preconditions;
    }

    public void setPreconditions(Planner.PlanState s) {
        this.preconditions = s;
    }

    public final Planner.PlanState getGoals() {
        return this.goals;
    }

    public void setGoals(Planner.PlanState s) {
        this.goals = s;
    }

    public final JobCache getJobCache() {
        return this.jobCache;
    }

    public void setJobCache(JobCache c) {
        this.jobCache = c;
    }

    public Jobs getJobs() {
        return this.jobs;
    }

    public void setCssSchema(CssSchema cssSchema) {
        this.cssSchema = cssSchema;
        this.compilationPipeline = null;
    }

    public void setHtmlSchema(HtmlSchema htmlSchema) {
        this.htmlSchema = htmlSchema;
        this.compilationPipeline = null;
    }

    public void addInput(ParseTreeNode input, URI baseUri) {
        this.jobs.getJobs().add(JobEnvelope.of(Job.job(input, baseUri)));
        this.jobs.getMessageContext().addInputSource(input.getFilePosition().source());
    }

    @Deprecated
    public void addInput(AncestorChain<?> input, URI baseUri) {
        this.addInput((ParseTreeNode)input.node, baseUri);
    }

    @Deprecated
    public void addInput(AncestorChain<?> input) {
        this.addInput(input, input.node.getFilePosition().source().getUri());
    }

    public List<? extends ParseTreeNode> getOutputs() {
        List<CajoledModule> outputs = Lists.newArrayList();
        CajoledModule js = this.getJavascript();
        if (js != null) {
            outputs.add(js);
        }
        return outputs;
    }

    private final void setupCompilationPipeline() throws Planner.UnsatisfiableGoalException {
        this.compilationPipeline = new Pipeline<Jobs>(){
            final long t0 = System.nanoTime();

            @Override
            protected boolean applyStage(Pipeline.Stage<? super Jobs> stage, Jobs jobs) {
                long t1 = System.nanoTime();
                jobs.getMessageQueue().addMessage((MessageTypeInt)MessageType.CHECKPOINT, MessagePart.Factory.valueOf(stage.getClass().getSimpleName()), MessagePart.Factory.valueOf((double)(t1 - this.t0) / 1.0E9));
                return super.applyStage(stage, jobs);
            }
        };
        ModuleManager moduleMgr = new ModuleManager(this.jobs.getPluginMeta(), this.buildInfo, this.jobs.getPluginMeta().getUriFetcher(), true, this.jobs.getMessageQueue());
        new PipelineMaker(this.cssSchema, this.htmlSchema, moduleMgr, this.jobCache, this.preconditions, this.goals).populate(this.compilationPipeline.getStages());
    }

    public final Pipeline<Jobs> getCompilationPipeline() throws Planner.UnsatisfiableGoalException {
        if (this.compilationPipeline == null) {
            this.setupCompilationPipeline();
        }
        return this.compilationPipeline;
    }

    public Node getStaticHtml() {
        List<JobEnvelope> htmlJobs = this.jobs.getJobsByType(ContentType.HTML, new ContentType[0]);
        if (htmlJobs.size() > 1) {
            htmlJobs = Lists.newArrayList(htmlJobs);
            Node fragment = null;
            for (JobEnvelope env : htmlJobs) {
                Node root = ((Dom)env.job.getRoot()).getValue();
                if (fragment == null) {
                    fragment = root.getOwnerDocument().getImplementation().createDocument(null, null, root.getOwnerDocument().getDoctype()).createDocumentFragment();
                }
                fragment.appendChild(fragment.getOwnerDocument().importNode(root, true));
            }
            return fragment;
        }
        Job soleHtmlJob = this.getConsolidatedOutput(new Criterion<Job>(){

            @Override
            public boolean accept(Job job) {
                return job.getType() == ContentType.HTML;
            }
        });
        return soleHtmlJob != null ? ((Dom)soleHtmlJob.getRoot()).getValue() : null;
    }

    public CajoledModule getJavascript() {
        Job soleJsJob = this.getConsolidatedOutput(new Criterion<Job>(){

            @Override
            public boolean accept(Job job) {
                return job.getType() == ContentType.JS;
            }
        });
        return soleJsJob != null ? (CajoledModule)soleJsJob.getRoot() : null;
    }

    private Job getConsolidatedOutput(Criterion<Job> filter) {
        Job match = null;
        for (JobEnvelope env : this.jobs.getJobs()) {
            if (!filter.accept(env.job)) continue;
            if (match != null) {
                throw new SomethingWidgyHappenedError("Not consolidated.  Check your pipeline.");
            }
            match = env.job;
        }
        return match;
    }

    public boolean run() {
        try {
            return this.getCompilationPipeline().apply(this.jobs);
        }
        catch (Planner.UnsatisfiableGoalException ex) {
            this.jobs.getMessageQueue().addMessage((MessageTypeInt)PluginMessageType.INVALID_PIPELINE, MessagePart.Factory.valueOf("" + this.preconditions), MessagePart.Factory.valueOf("" + this.goals));
            return false;
        }
    }
}

