/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.lexer.InputSource;
import com.google.caja.parser.html.Dom;
import com.google.caja.parser.html.DomParser;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.JobEnvelope;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.PluginMessageType;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.stages.LegacyNamespaceFixupStage;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.Lists;
import java.util.List;
import junit.framework.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LegacyNamespaceFixupStageTest
extends CajaTestCase {
    public final void testEmptyFragment() {
        this.assertFixed("", LegacyNamespaceFixupStageTest.builder().job());
        LegacyNamespaceFixupStageTest.assertTrue((boolean)this.mq.getMessages().isEmpty());
    }

    public final void testOneHtmlTag() {
        this.assertFixed("<b>Foo</b>", LegacyNamespaceFixupStageTest.builder().open("b").text("Foo").close().job());
        LegacyNamespaceFixupStageTest.assertTrue((boolean)this.mq.getMessages().isEmpty());
    }

    public final void testHtmlTagAndAttrib() {
        this.assertFixed("<a href=\"bar.html\">Foo</a>", LegacyNamespaceFixupStageTest.builder().open("a").attr("href", "bar.html").text("Foo").close().job());
        LegacyNamespaceFixupStageTest.assertTrue((boolean)this.mq.getMessages().isEmpty());
    }

    public final void testPrefixedAttribWithWellKnownPrefix() {
        this.assertFixed("<a href=\"bar.html\" xml:lang=\"en\">Foo</a>", LegacyNamespaceFixupStageTest.builder().open("a").attr("href", "bar.html").attr("xml:lang", "en").text("Foo").close().job());
        this.assertMessage(true, PluginMessageType.MISSING_XML_NAMESPACE, MessageLevel.LINT, MessagePart.Factory.valueOf("xml:lang"));
        LegacyNamespaceFixupStageTest.assertTrue((boolean)this.mq.getMessages().isEmpty());
    }

    public final void testNoXmlnsAttr() {
        this.assertFixed("<a href=\"bar.html\">Foo</a>", LegacyNamespaceFixupStageTest.builder().open("a").attr("href", "bar.html").text("Foo").close().job());
        LegacyNamespaceFixupStageTest.assertTrue((boolean)this.mq.getMessages().isEmpty());
    }

    public final void testSameXmlnsAttr() {
        this.assertFixed("<a href=\"bar.html\">Foo</a>", LegacyNamespaceFixupStageTest.builder().open("a").attr("href", "bar.html").attr("xmlns", "http://www.w3.org/1999/xhtml").text("Foo").close().job());
        LegacyNamespaceFixupStageTest.assertTrue((boolean)this.mq.getMessages().isEmpty());
    }

    public final void testNewXmlnsAttr() {
        this.assertFixed("<a href=\"bar.html\">Foo</a>", LegacyNamespaceFixupStageTest.builder().open("a").attr("href", "bar.html").attr("xmlns", "http://foo.com").text("Foo").close().job());
        this.assertMessage(true, PluginMessageType.CONFLICTING_XML_NAMESPACE, MessageLevel.WARNING, MessagePart.Factory.valueOf("a"));
        LegacyNamespaceFixupStageTest.assertTrue((boolean)this.mq.getMessages().isEmpty());
    }

    public final void testPrefixedAttribWithUnknownPrefix() {
        this.assertFixed("<a xmlns:baz=\"http://example.net/unknown-xml-namespace/\" baz:lang=\"en\" href=\"bar.html\">Foo</a>", LegacyNamespaceFixupStageTest.builder().open("a").attr("href", "bar.html").attr("baz:lang", "en").text("Foo").close().job());
        this.assertMessage(true, PluginMessageType.MISSING_XML_NAMESPACE, MessageLevel.ERROR, MessagePart.Factory.valueOf("baz:lang"));
        LegacyNamespaceFixupStageTest.assertTrue((boolean)this.mq.getMessages().isEmpty());
    }

    public final void testPrefixedElementWithKnownPrefix() {
        this.assertFixed("<svg:a href=\"foo.svg\">Foo</svg:a>", LegacyNamespaceFixupStageTest.builder().open("svg:a").attr("href", "foo.svg").text("Foo").close().job());
        this.assertMessage(true, PluginMessageType.MISSING_XML_NAMESPACE, MessageLevel.LINT, MessagePart.Factory.valueOf("svg:a"));
        LegacyNamespaceFixupStageTest.assertTrue((boolean)this.mq.getMessages().isEmpty());
    }

    public final void testPrefixedElementWithUnknownPrefix() {
        this.assertFixed("<foo:a xmlns:foo=\"http://example.net/unknown-xml-namespace/\" href=\"foo.svg\">Foo</foo:a>", LegacyNamespaceFixupStageTest.builder().open("foo:a").attr("href", "foo.svg").text("Foo").close().job());
        this.assertMessage(true, PluginMessageType.MISSING_XML_NAMESPACE, MessageLevel.ERROR, MessagePart.Factory.valueOf("foo:a"));
        LegacyNamespaceFixupStageTest.assertTrue((boolean)this.mq.getMessages().isEmpty());
    }

    private void assertFixed(String golden, Job ... inputs) {
        Jobs jobs = new Jobs(this.mc, this.mq, new PluginMeta());
        for (Job input : inputs) {
            jobs.getJobs().add(JobEnvelope.of(input));
        }
        new LegacyNamespaceFixupStage().apply(jobs);
        StringBuilder sb = new StringBuilder();
        for (JobEnvelope env : jobs.getJobs()) {
            sb.append(LegacyNamespaceFixupStageTest.render(env.job.getRoot()));
            sb.append('\n');
        }
        LegacyNamespaceFixupStageTest.assertEquals((String)golden, (String)sb.toString().trim());
    }

    static NamespaceUnawareBuilder builder() {
        return new NamespaceUnawareBuilder();
    }

    static final class NamespaceUnawareBuilder {
        final Document doc = DomParser.makeDocument(null, null);
        final DocumentFragment root = this.doc.createDocumentFragment();
        final List<Node> stack = Lists.newArrayList(this.root);

        NamespaceUnawareBuilder() {
        }

        private Node top() {
            return this.stack.get(this.stack.size() - 1);
        }

        Job job() {
            Assert.assertEquals(this.stack, Lists.newArrayList(this.root));
            return Job.domJob(new Dom(this.root), InputSource.UNKNOWN.getUri());
        }

        NamespaceUnawareBuilder open(String qname) {
            Element el = this.doc.createElement(qname);
            this.top().appendChild(el);
            this.stack.add(el);
            return this;
        }

        NamespaceUnawareBuilder close() {
            Assert.assertTrue((this.stack.size() > 1 ? 1 : 0) != 0);
            this.stack.remove(this.stack.size() - 1);
            return this;
        }

        NamespaceUnawareBuilder text(String s) {
            this.top().appendChild(this.doc.createTextNode(s));
            return this;
        }

        NamespaceUnawareBuilder attr(String name, String value) {
            ((Element)this.top()).setAttribute(name, value);
            return this;
        }
    }
}

