/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.lang.css.CssSchema;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.Statement;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.JobEnvelope;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.stages.OpenTemplateStage;
import com.google.caja.plugin.stages.ValidateCssStage;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.ContentType;
import com.google.caja.util.Pipeline;
import java.util.List;

public final class OpenTemplateStageTest
extends CajaTestCase {
    public final void testSimpleRewrite1() throws Exception {
        this.assertRewritten("new StringInterpolation([ 'foo ', bar, ' baz' ])", "eval(Template('foo $bar baz'))", true);
    }

    public final void testSimpleRewrite2() throws Exception {
        this.assertRewritten("new StringInterpolation([ 'foo', bar, 'baz' ])", "eval(Template('foo${bar}baz'))", true);
    }

    public final void testExpressionSubstitution() throws Exception {
        this.assertRewritten("new StringInterpolation([ 'foo', bar() * 3, 'baz' ])", "eval(Template('foo${bar() * 3}baz'))", true);
    }

    public final void testMaskedTemplate() throws Exception {
        this.assertRewritten("{\n  eval(Template('foo${bar}baz'));\n  var Template;\n}", "{\n  eval(Template('foo${bar}baz'));\n  var Template;\n}", true);
    }

    public final void testMaskedEval() throws Exception {
        this.assertRewritten("{\n  function eval() {}\n  eval(Template('foo${bar}baz'));\n}", "{\n  function eval() {}\n  eval(Template('foo${bar}baz'));\n}", true);
    }

    private void assertRewritten(String golden, String input, final boolean passes) throws Exception {
        this.mq.getMessages().clear();
        CssSchema cssSchema = CssSchema.getDefaultCss21Schema(this.mq);
        HtmlSchema htmlSchema = HtmlSchema.getDefault(this.mq);
        Pipeline<Jobs> pipeline = new Pipeline<Jobs>(){

            @Override
            public boolean applyStage(Pipeline.Stage<? super Jobs> stage, Jobs jobs) {
                boolean result = super.applyStage(stage, jobs);
                return passes ? result : true;
            }
        };
        pipeline.getStages().add(new OpenTemplateStage());
        pipeline.getStages().add(new ValidateCssStage(cssSchema, htmlSchema));
        pipeline.getStages().add(new Consolidator());
        Block node = this.js(this.fromString(input));
        PluginMeta meta = new PluginMeta();
        Jobs jobs = new Jobs(this.mc, this.mq, meta);
        jobs.getJobs().add(JobEnvelope.of(Job.jsJob(node, null)));
        OpenTemplateStageTest.assertTrue((boolean)pipeline.apply(jobs));
        OpenTemplateStageTest.assertEquals((String)("" + jobs.getMessageQueue().getMessages()), (boolean)passes, (boolean)jobs.hasNoErrors());
        OpenTemplateStageTest.assertEquals((String)("" + jobs.getJobs()), (int)1, (int)jobs.getJobs().size());
        ParseTreeNode bare = OpenTemplateStageTest.stripBoilerPlate(jobs.getJobs().get((int)0).job.getRoot());
        OpenTemplateStageTest.assertEquals((String)golden, (String)OpenTemplateStageTest.render(bare));
    }

    private static ParseTreeNode stripBoilerPlate(ParseTreeNode node) {
        while (node instanceof Block && node.children().size() == 1) {
            node = node.children().get(0);
        }
        if (node instanceof ExpressionStmt) {
            node = node.children().get(0);
        }
        return node;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Consolidator
    implements Pipeline.Stage<Jobs> {
        private Consolidator() {
        }

        @Override
        public boolean apply(Jobs jobs) {
            List<JobEnvelope> jsJobs = jobs.getJobsByType(ContentType.JS, new ContentType[0]);
            if (jsJobs.size() == 1) {
                return true;
            }
            jobs.getJobs().remove(jsJobs);
            Block block = new Block(FilePosition.UNKNOWN);
            for (JobEnvelope env : jsJobs) {
                Statement s = (Statement)env.job.getRoot();
                block.appendChild(s);
            }
            jobs.getJobs().add(JobEnvelope.of(Job.jsJob(block, null)));
            return true;
        }
    }
}

