/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.lexer.ParseException;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.ValueProperty;
import com.google.caja.parser.quasiliteral.ModuleManager;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.JobEnvelope;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.plugin.stages.OptimizeJavascriptStage;
import com.google.caja.plugin.stages.PipelineStageTestCase;
import com.google.caja.plugin.stages.ValidateJavascriptStage;
import com.google.caja.reporting.TestBuildInfo;
import com.google.caja.util.ContentType;
import com.google.caja.util.Join;

public class OptimizeJavascriptStageTest
extends PipelineStageTestCase {
    public final void testEmptyInput() throws Exception {
        this.assertPipeline(OptimizeJavascriptStageTest.job(";", ContentType.JS), OptimizeJavascriptStageTest.job(ContentType.JS, "{", "  var dis___ = IMPORTS___;", "  var moduleResult___;", "  moduleResult___ = ___.NO_RESULT;", "  return moduleResult___;", "}"));
    }

    public final void testLoopCounter() throws Exception {
        this.assertPipeline(OptimizeJavascriptStageTest.job(ContentType.JS, "(function (f, arr) {", "  for (var i = 0; i < arr.length; ++i) {", "    f(arr[i]);", "  }", "})(f, [1, 2, 3])"), OptimizeJavascriptStageTest.job(ContentType.JS, this.normJs("{", "  var dis___ = IMPORTS___;", "  var moduleResult___;", "  moduleResult___ = ___.NO_RESULT;", "  moduleResult___ = ___.f(function (f, arr) {", "      var i;", "      for (i = 0; i < arr.length; ++i) {", "        f.i___(arr[ +i ]);", "      }", "    }).i___(" + OptimizeJavascriptStageTest.outer("f") + ", [ 1, 2, 3 ]);", "  return moduleResult___;", "}")));
    }

    public final void testIndexOfUnknownProvenance() throws Exception {
        this.assertPipeline(OptimizeJavascriptStageTest.job(ContentType.JS, "(function (i) {", "  for (; i < a.length; ++i) {", "    f(a[i]);", "  }", "})(x)"), OptimizeJavascriptStageTest.job(ContentType.JS, this.normJs("{", "  var dis___ = IMPORTS___;", "  var moduleResult___;", "  moduleResult___ = ___.NO_RESULT;", "  moduleResult___ = ___.f(function (i) {", "      for (; i < " + OptimizeJavascriptStageTest.outer("a") + ".length; ++i) {", "        " + OptimizeJavascriptStageTest.outer("f") + ".i___(" + OptimizeJavascriptStageTest.outer("a") + ".v___(i));", "      }", "    }).i___(" + OptimizeJavascriptStageTest.outer("x") + ");", "  return moduleResult___;", "}")));
    }

    protected boolean runPipeline(Jobs jobs) {
        this.getMeta().setEnableES53(true);
        return new OptimizeJavascriptStage().apply(jobs) && new ValidateJavascriptStage(new ModuleManager(new PluginMeta(), TestBuildInfo.getInstance(), UriFetcher.NULL_NETWORK, false, this.mq)).apply(jobs) && this.discardBoilerPlate(jobs);
    }

    private boolean discardBoilerPlate(Jobs jobs) {
        for (JobEnvelope env : jobs.getJobsByType(ContentType.JS, new ContentType[0])) {
            Job job = env.job;
            if (!(job.getRoot() instanceof CajoledModule)) continue;
            jobs.getJobs().remove(env);
            ObjectConstructor cs = ((CajoledModule)job.getRoot()).getModuleBody();
            FunctionConstructor instantiate = (FunctionConstructor)((ValueProperty)cs.propertyWithName("instantiate")).getValueExpr();
            jobs.getJobs().add(JobEnvelope.of(Job.jsJob(instantiate.getBody(), null)));
        }
        return true;
    }

    private static final String outer(String id) {
        return "(IMPORTS___." + id + "_v___? IMPORTS___." + id + ": ___.ri(IMPORTS___, '" + id + "'))";
    }

    private String[] normJs(String ... lines) throws ParseException {
        return OptimizeJavascriptStageTest.renderProgram(this.js(this.fromString(Join.join((CharSequence)"\n", lines)))).split("\n");
    }
}

