/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.plugin.Job;
import com.google.caja.plugin.JobEnvelope;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.stages.JobCache;
import com.google.caja.util.ContentType;
import com.google.caja.util.Pipeline;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ParametersAreNonnullByDefault
public final class PipelineFetchStage
implements Pipeline.Stage<Jobs> {
    private final JobCache cache;

    public PipelineFetchStage(JobCache cache) {
        this.cache = cache;
    }

    @Override
    public boolean apply(Jobs jobs) {
        ListIterator<JobEnvelope> it = jobs.getJobs().listIterator();
        while (it.hasNext()) {
            JobEnvelope env = it.next();
            if (env.fromCache || env.job.getType() != ContentType.JS || env.job.getRoot().getAttributes().is(JobCache.NO_CACHE)) continue;
            Job job = env.job;
            JobCache.Key key = this.cache.forJob(job.getType(), job.getRoot());
            List<? extends Job> fromCache = this.cache.fetch(key);
            if (fromCache != null) {
                it.remove();
                for (Job job2 : fromCache) {
                    JobEnvelope replacement = new JobEnvelope(env.placeholderId, env.cacheKeys, env.sourceType, true, job2);
                    it.add(replacement);
                }
                continue;
            }
            it.set(new JobEnvelope(env.placeholderId, key.asSingleton(), env.sourceType, false, job));
        }
        return jobs.hasNoFatalErrors();
    }
}

