/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.templates;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lang.css.CssSchema;
import com.google.caja.lang.html.HTML;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.Keyword;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.escaping.UriUtil;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodeContainer;
import com.google.caja.parser.Visitor;
import com.google.caja.parser.css.CssTree;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.AbstractExpression;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.SyntheticNodes;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.plugin.CssRewriter;
import com.google.caja.plugin.CssValidator;
import com.google.caja.plugin.JobEnvelope;
import com.google.caja.plugin.PluginMessageType;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.UriPolicyHintKey;
import com.google.caja.plugin.stages.EmbeddedContent;
import com.google.caja.plugin.templates.EventHandler;
import com.google.caja.plugin.templates.IhtmlMessageType;
import com.google.caja.plugin.templates.JsConcatenator;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import com.google.caja.util.SyntheticAttributeKey;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HtmlAttributeRewriter {
    private final PluginMeta meta;
    private final CssSchema cssSchema;
    private final HtmlSchema htmlSchema;
    private final MessageQueue mq;
    private final Map<Attr, EmbeddedContent> attributeContent;
    private final Map<String, String> handlerCache = Maps.newHashMap();
    private final List<EventHandler> handlers = Lists.newArrayList();
    public static final SyntheticAttributeKey<String> HANDLER_NAME = new SyntheticAttributeKey<String>(String.class, "handlerName");
    private static final Pattern FORBIDDEN_ID = Pattern.compile("__\\s*$");
    private static final Pattern VALID_ID = Pattern.compile("^[\\p{Alnum}_$\\-.:;=()\\[\\]]+$");

    public HtmlAttributeRewriter(PluginMeta meta, CssSchema cssSchema, HtmlSchema htmlSchema, Map<Attr, EmbeddedContent> attributeContent, MessageQueue mq) {
        this.meta = meta;
        this.cssSchema = cssSchema;
        this.htmlSchema = htmlSchema;
        this.attributeContent = attributeContent;
        this.mq = mq;
    }

    public PluginMeta getPluginMeta() {
        return this.meta;
    }

    public CssSchema getCssSchema() {
        return this.cssSchema;
    }

    public HtmlSchema getHtmlSchema() {
        return this.htmlSchema;
    }

    public List<EventHandler> getHandlers() {
        return Collections.unmodifiableList(this.handlers);
    }

    public static AttrValue fromAttr(final Attr a, HTML.Attribute attr, JobEnvelope source) {
        return new AttrValue(source, a, Nodes.getFilePositionForValue(a), attr){

            Expression getValueExpr() {
                return StringLiteral.valueOf(this.valuePos, this.getPlainValue());
            }

            String getPlainValue() {
                return a.getValue();
            }

            String getRawValue() {
                return Nodes.getRawValue(a);
            }
        };
    }

    public SanitizedAttr sanitizeStringValue(AttrValue attr) {
        Expression dynamicValue = null;
        FilePosition pos = attr.valuePos;
        String value = attr.getPlainValue();
        switch (attr.attrInfo.getType()) {
            case CLASSES: {
                if (this.checkForbiddenIdList(value, pos)) break;
                return HtmlAttributeRewriter.noResult(attr);
            }
            case FRAME_TARGET: 
            case LOCAL_NAME: {
                if (this.checkValidId(value, pos)) break;
                return HtmlAttributeRewriter.noResult(attr);
            }
            case GLOBAL_NAME: 
            case ID: 
            case IDREF: {
                if (!this.checkValidId(value, pos)) {
                    return HtmlAttributeRewriter.noResult(attr);
                }
                dynamicValue = this.rewriteIdentifiers(pos, value);
                break;
            }
            case IDREFS: {
                if (!this.checkValidIdList(value, pos)) {
                    return HtmlAttributeRewriter.noResult(attr);
                }
                dynamicValue = this.rewriteIdentifiers(pos, value);
                break;
            }
            case NONE: {
                if (attr.attrInfo.getValueCriterion().accept(value)) break;
                this.mq.addMessage((MessageTypeInt)IhtmlMessageType.BAD_ATTRIB, pos, attr.attrInfo.getKey().el, attr.attrInfo.getKey(), MessagePart.Factory.valueOf(value));
                return HtmlAttributeRewriter.noResult(attr);
            }
            case SCRIPT: {
                String handlerFnName = this.handlerCache.get(value);
                if (handlerFnName == null) {
                    Block b = this.jsFromAttrib(attr);
                    if (b == null || b.children().isEmpty()) {
                        return HtmlAttributeRewriter.noResult(attr);
                    }
                    HtmlAttributeRewriter.rewriteEventHandlerReferences(b);
                    handlerFnName = this.meta.generateUniqueName("c");
                    Declaration handler = (Declaration)QuasiBuilder.substV("var @handlerName = ___./*@synthetic*/markFuncFreeze(    /*@synthetic*/function (        event, thisNode___) { @body*; });", "handlerName", SyntheticNodes.s(new Identifier(FilePosition.UNKNOWN, handlerFnName)), "body", new ParseTreeNodeContainer(b.children()));
                    this.handlers.add(new EventHandler(attr.env, handler));
                    this.handlerCache.put(value, handlerFnName);
                }
                FunctionConstructor eventAdapter = (FunctionConstructor)QuasiBuilder.substV("(/*@synthetic*/ function (event) {  return /*@synthetic*/ (plugin_dispatchEvent___(      /*@synthetic*/this, event,       ___./*@synthetic*/getId(IMPORTS___), @tail));})", "tail", new Reference(SyntheticNodes.s(new Identifier(pos, handlerFnName))));
                eventAdapter.setFilePosition(pos);
                eventAdapter.getAttributes().set(HANDLER_NAME, handlerFnName);
                dynamicValue = eventAdapter;
                break;
            }
            case STYLE: {
                CssTree.DeclarationGroup decls = this.styleFromAttrib(attr);
                if (decls == null || decls.children().isEmpty()) {
                    return HtmlAttributeRewriter.noResult(attr);
                }
                CssValidator v = new CssValidator(this.cssSchema, this.htmlSchema, this.mq).withInvalidNodeMessageLevel(MessageLevel.WARNING);
                v.validateCss(AncestorChain.instance(decls));
                new CssRewriter(this.meta.getUriPolicy(), this.cssSchema, this.mq).withInvalidNodeMessageLevel(MessageLevel.WARNING).rewrite(AncestorChain.instance(decls));
                StringBuilder css = new StringBuilder();
                RenderContext rc = new RenderContext(decls.makeRenderer(css, null));
                decls.render(rc);
                rc.getOut().noMoreTokens();
                dynamicValue = StringLiteral.valueOf(pos, css);
                break;
            }
            case URI: {
                URI uri;
                if (this.attributeContent.containsKey(attr.src)) {
                    Block b = this.jsFromAttrib(attr);
                    if (b == null || b.children().isEmpty()) {
                        return HtmlAttributeRewriter.noResult(attr);
                    }
                    String handlerIndexName = this.meta.generateUniqueName("c");
                    Identifier handlerIndex = SyntheticNodes.s(new Identifier(FilePosition.UNKNOWN, handlerIndexName));
                    Statement handler = (Statement)QuasiBuilder.substV("var @handlerIndex = IMPORTS___.handlers___.push(    ___./*@synthetic*/markFuncFreeze(        /*@synthetic*/function () { @body*; })) - 1;", "handlerIndex", handlerIndex, "body", new ParseTreeNodeContainer(b.children()));
                    this.handlers.add(new EventHandler(attr.env, handler));
                    this.handlerCache.put(value, handlerIndexName);
                    Operation urlAdapter = (Operation)QuasiBuilder.substV("'javascript:' + /*@synthetic*/encodeURIComponent(   'try{void plugin_dispatchToHandler___('    + ___./*@synthetic*/getId(IMPORTS___)    + ',' + @handlerIndex + ',[{}])}catch(_){}')", "handlerIndex", new Reference(handlerIndex));
                    urlAdapter.setFilePosition(pos);
                    urlAdapter.getAttributes().set(HANDLER_NAME, handlerIndexName);
                    dynamicValue = urlAdapter;
                    break;
                }
                try {
                    uri = new URI(UriUtil.normalizeUri(value));
                }
                catch (URISyntaxException ex) {
                    this.mq.addMessage((MessageTypeInt)IhtmlMessageType.MALFORMED_URI, pos, MessagePart.Factory.valueOf(value));
                    return HtmlAttributeRewriter.noResult(attr);
                }
                if (this.meta.getUriPolicy() != null) {
                    ExternalReference ref = new ExternalReference(uri, pos);
                    String rewrittenUri = this.meta.getUriPolicy().rewriteUri(ref, attr.attrInfo.getUriEffect(), attr.attrInfo.getLoaderType(), Collections.singletonMap(UriPolicyHintKey.XML_ATTR.key, attr.attrInfo.getKey().toString()));
                    if (rewrittenUri == null) {
                        this.mq.addMessage((MessageTypeInt)PluginMessageType.DISALLOWED_URI, pos, MessagePart.Factory.valueOf(uri.toString()));
                        return HtmlAttributeRewriter.noResult(attr);
                    }
                    dynamicValue = StringLiteral.valueOf(ref.getReferencePosition(), rewrittenUri);
                    break;
                }
                dynamicValue = (Expression)QuasiBuilder.substV("IMPORTS___./*@synthetic*/rewriteUriInAttribute___(    @value, @tagName, @attribName)", "value", new StringLiteral(pos, uri.toString()), "tagName", new StringLiteral(pos, attr.src.getOwnerElement().getTagName()), "attribName", new StringLiteral(pos, attr.src.getName()));
                break;
            }
            case URI_FRAGMENT: {
                if (value.length() < 2 || !value.startsWith("#")) {
                    this.mq.addMessage((MessageTypeInt)IhtmlMessageType.BAD_ATTRIB, pos, attr.attrInfo.getKey().el, attr.attrInfo.getKey(), MessagePart.Factory.valueOf(value));
                    return HtmlAttributeRewriter.noResult(attr);
                }
                String id = value.substring(1);
                if (!this.checkValidId(id, pos)) {
                    return HtmlAttributeRewriter.noResult(attr);
                }
                JsConcatenator out = new JsConcatenator();
                out.append(FilePosition.startOf(pos), "#");
                this.rewriteIdentifiers(pos, id, out);
                dynamicValue = out.toExpression(false);
                break;
            }
            default: {
                throw new SomethingWidgyHappenedError(attr.attrInfo.getType().name());
            }
        }
        return new SanitizedAttr(true, dynamicValue);
    }

    private boolean checkForbiddenId(String value, FilePosition pos) {
        if (!FORBIDDEN_ID.matcher(value).find()) {
            return true;
        }
        this.mq.addMessage((MessageTypeInt)IhtmlMessageType.ILLEGAL_NAME, MessageLevel.WARNING, pos, MessagePart.Factory.valueOf(value));
        return false;
    }

    private boolean checkForbiddenIdList(String value, FilePosition pos) {
        boolean ok = true;
        for (String ident : HtmlAttributeRewriter.identifiers(value)) {
            ok &= this.checkForbiddenId(ident, pos);
        }
        return ok;
    }

    private boolean checkValidId(String value, FilePosition pos) {
        if (!this.checkForbiddenId(value, pos)) {
            return false;
        }
        if ("".equals(value)) {
            return true;
        }
        if (VALID_ID.matcher(value).find()) {
            return true;
        }
        this.mq.addMessage((MessageTypeInt)IhtmlMessageType.ILLEGAL_NAME, pos, MessagePart.Factory.valueOf(value));
        return false;
    }

    private boolean checkValidIdList(String value, FilePosition pos) {
        boolean ok = true;
        for (String ident : HtmlAttributeRewriter.identifiers(value)) {
            ok &= this.checkValidId(ident, pos);
        }
        return ok;
    }

    private Expression rewriteIdentifiers(FilePosition pos, String names) {
        if ("".equals(names)) {
            return null;
        }
        JsConcatenator concat = new JsConcatenator();
        this.rewriteIdentifiers(pos, names, concat);
        Expression result = concat.toExpression(false);
        ((AbstractExpression)result).setFilePosition(pos);
        return result;
    }

    private void rewriteIdentifiers(FilePosition pos, String names, JsConcatenator concat) {
        String idClass = this.meta.getIdClass();
        Expression idClassExpr = idClass != null ? StringLiteral.valueOf(FilePosition.UNKNOWN, idClass) : (Expression)QuasiBuilder.substV("IMPORTS___.getIdClass___()", new Object[0]);
        boolean first = true;
        for (String ident : HtmlAttributeRewriter.identifiers(names)) {
            if ("".equals(ident)) continue;
            concat.append(pos, (first ? "" : " ") + ident + "-");
            concat.append(idClassExpr);
            first = false;
            pos = FilePosition.endOf(pos);
        }
    }

    private static void rewriteEventHandlerReferences(Block block) {
        block.acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ancestors) {
                Object node = ancestors.node;
                if (node instanceof FunctionConstructor) {
                    return false;
                }
                if (node instanceof Reference) {
                    Reference r = (Reference)node;
                    if (Keyword.THIS.toString().equals(r.getIdentifierName())) {
                        Identifier oldRef = r.getIdentifier();
                        Identifier thisNode = new Identifier(oldRef.getFilePosition(), "thisNode___");
                        r.replaceChild(SyntheticNodes.s(thisNode), oldRef);
                    }
                    return false;
                }
                return true;
            }
        }, null);
    }

    static SanitizedAttr noResult(AttrValue a) {
        String safeValue = a.attrInfo.getSafeValue();
        String defaultValue = a.attrInfo.getDefaultValue();
        if (safeValue != null && defaultValue != null && !safeValue.equals(defaultValue)) {
            return new SanitizedAttr(true, StringLiteral.valueOf(a.valuePos, safeValue));
        }
        return new SanitizedAttr(false, null);
    }

    private static Iterable<String> identifiers(String idents) {
        return "".equals(idents = idents.trim()) ? Collections.emptyList() : Arrays.asList(idents.trim().split("\\s+"));
    }

    private Block jsFromAttrib(AttrValue v) {
        EmbeddedContent c = this.attributeContent.get(v.src);
        if (c == null) {
            return null;
        }
        try {
            ParseTreeNode n = c.parse(this.meta.getUriFetcher(), this.mq);
            if (n instanceof Block) {
                return (Block)n;
            }
        }
        catch (ParseException ex) {
            ex.toMessageQueue(this.mq);
        }
        return null;
    }

    private CssTree.DeclarationGroup styleFromAttrib(AttrValue v) {
        EmbeddedContent c = this.attributeContent.get(v.src);
        if (c == null) {
            return null;
        }
        try {
            ParseTreeNode n = c.parse(this.meta.getUriFetcher(), this.mq);
            if (n instanceof CssTree.DeclarationGroup) {
                return (CssTree.DeclarationGroup)n;
            }
        }
        catch (ParseException ex) {
            ex.toMessageQueue(this.mq);
        }
        return null;
    }

    public static final class SanitizedAttr {
        public final boolean isSafe;
        public final Expression result;

        SanitizedAttr(boolean isSafe, Expression result) {
            this.isSafe = isSafe;
            this.result = result;
        }
    }

    public static abstract class AttrValue {
        final JobEnvelope env;
        final Attr src;
        final FilePosition valuePos;
        final HTML.Attribute attrInfo;

        abstract Expression getValueExpr();

        abstract String getPlainValue();

        abstract String getRawValue();

        AttrValue(JobEnvelope env, Attr src, FilePosition valuePos, HTML.Attribute attr) {
            this.env = env;
            this.src = src;
            this.valuePos = valuePos;
            this.attrInfo = attr;
        }
    }
}

