/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.templates;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.HtmlTextEscapingMode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.html.AttribKey;
import com.google.caja.parser.html.ElKey;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.Directive;
import com.google.caja.parser.js.DirectivePrologue;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.Noop;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.SyntheticNodes;
import com.google.caja.parser.js.TranslatedCode;
import com.google.caja.plugin.JobEnvelope;
import com.google.caja.plugin.Placeholder;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.stages.JobCache;
import com.google.caja.plugin.templates.EventHandler;
import com.google.caja.plugin.templates.HtmlAttributeRewriter;
import com.google.caja.plugin.templates.IhtmlRoot;
import com.google.caja.plugin.templates.QuasiUtil;
import com.google.caja.plugin.templates.SafeHtmlChunk;
import com.google.caja.plugin.templates.SafeJsChunk;
import com.google.caja.plugin.templates.SafeStylesheet;
import com.google.caja.plugin.templates.ScriptPlaceholder;
import com.google.caja.reporting.MessageContext;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import com.google.caja.util.Pair;
import com.google.caja.util.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SafeHtmlMaker {
    private static final AttribKey ID = AttribKey.forHtmlAttrib(ElKey.HTML_WILDCARD, "id");
    private static final JobEnvelope SYNTHETIC_SOURCE = new JobEnvelope(null, JobCache.none(), null, false, null);
    private final PluginMeta meta;
    private final MessageContext mc;
    private final Document doc;
    private final List<SafeJsChunk> js = Lists.newArrayList();
    private final Map<Node, ParseTreeNode> scriptsPerNode;
    private final Map<String, ScriptPlaceholder> scriptsPerPlaceholder;
    private final List<IhtmlRoot> roots;
    private final Map<String, Pair<JobEnvelope, Declaration>> handlers = Maps.newHashMap();
    private final List<EventHandler> unnamedHandlers = Lists.newArrayList();
    private final Set<String> handlersUsedInModule = Sets.newHashSet();
    private Block currentBlock = null;
    private boolean currentBlockStyle;
    private JobEnvelope currentSource;
    private boolean started = false;
    private boolean moduleDefs = false;
    private boolean finished = false;
    private static final Pattern DYNID_PATTERN = Pattern.compile("id_\\d+___");

    SafeHtmlMaker(PluginMeta meta, MessageContext mc, Document doc, Map<Node, ParseTreeNode> scriptsPerNode, Map<String, ScriptPlaceholder> scriptsPerPlaceholder, List<IhtmlRoot> roots, List<EventHandler> handlers) {
        this.meta = meta;
        this.mc = mc;
        this.doc = doc;
        this.scriptsPerNode = scriptsPerNode;
        this.scriptsPerPlaceholder = scriptsPerPlaceholder;
        this.roots = roots;
        for (EventHandler handler : handlers) {
            if (handler.handler instanceof Declaration) {
                Declaration d = (Declaration)handler.handler;
                this.handlers.put(d.getIdentifierName(), Pair.pair(handler.source, d));
                continue;
            }
            this.unnamedHandlers.add(handler);
        }
    }

    Pair<List<SafeHtmlChunk>, List<SafeJsChunk>> make(List<SafeStylesheet> css) {
        this.js.clear();
        this.currentBlock = null;
        List<SafeHtmlChunk> safe = Lists.newArrayList(this.roots.size() + css.size() + 1);
        for (SafeStylesheet ss : css) {
            if (ss.jsVersion != null) {
                this.emitStatement(ss.jsVersion, true, ss.source);
                continue;
            }
            if (ss.htmlVersion == null) continue;
            safe.add(new SafeHtmlChunk(ss.source, ss.htmlVersion, ss.baseUri));
        }
        for (EventHandler handler : this.unnamedHandlers) {
            this.emitHandler(handler.handler, handler.source);
        }
        List<DomBone> domSkeleton = Lists.newArrayList();
        for (IhtmlRoot root : this.roots) {
            Node one = this.makeSkeleton(root.root, root.source, domSkeleton);
            if (one == null) continue;
            safe.add(new SafeHtmlChunk(root.source, one, root.baseUri));
        }
        this.fleshOutSkeleton(domSkeleton);
        return Pair.pair(safe, Lists.newArrayList(this.js));
    }

    private Node makeSkeleton(Node n, JobEnvelope src, List<DomBone> bones) {
        Node safe;
        String placeholderId = SafeHtmlMaker.getPlaceholderId(n);
        if (placeholderId != null) {
            ScriptPlaceholder ph = this.scriptsPerPlaceholder.get(placeholderId);
            bones.add(new ScriptBone(ph.source, ph.body));
            return null;
        }
        if (!this.scriptsPerNode.containsKey(n)) {
            return null;
        }
        switch (n.getNodeType()) {
            case 1: {
                Element el = (Element)n;
                FilePosition pos = Nodes.getFilePositionFor(el);
                safe = this.doc.createElementNS(el.getNamespaceURI(), el.getTagName());
                Nodes.setFilePositionFor(safe, pos);
                bones.add(new NodeBone(src, n, safe));
                for (Node node : Nodes.childrenOf(el)) {
                    Node safeChild = this.makeSkeleton(node, src, bones);
                    if (safeChild == null) continue;
                    safe.appendChild(safeChild);
                }
                break;
            }
            case 3: {
                safe = this.doc.createTextNode(n.getNodeValue());
                Nodes.setFilePositionFor(safe, Nodes.getFilePositionFor(n));
                bones.add(new NodeBone(src, n, safe));
                break;
            }
            case 11: {
                safe = this.doc.createDocumentFragment();
                for (Node node : Nodes.childrenOf(n)) {
                    Node safeChild = this.makeSkeleton(node, src, bones);
                    if (safeChild == null) continue;
                    safe.appendChild(safeChild);
                }
                break;
            }
            default: {
                return null;
            }
        }
        return safe;
    }

    private void fleshOutSkeleton(List<DomBone> bones) {
        int n;
        int firstDeferredScriptIndex;
        for (firstDeferredScriptIndex = n = bones.size(); firstDeferredScriptIndex > 0 && bones.get(firstDeferredScriptIndex - 1) instanceof ScriptBone; --firstDeferredScriptIndex) {
        }
        for (int i = 0; i < n; ++i) {
            boolean splitDom;
            DomBone bone;
            if (i == firstDeferredScriptIndex) {
                this.finish();
            }
            if ((bone = bones.get(i)) instanceof ScriptBone) {
                this.fleshOutScriptBlock((ScriptBone)bone);
                continue;
            }
            NodeBone nb = (NodeBone)bone;
            boolean bl = splitDom = i + 1 < n && bones.get(i + 1) instanceof ScriptBone && i + 1 != firstDeferredScriptIndex;
            if (splitDom) {
                this.requireModuleDefs(bone.source);
            }
            if (nb.node instanceof Text) {
                if (!splitDom) continue;
                this.insertPlaceholderAfter(nb);
                continue;
            }
            this.fleshOutElement(nb, splitDom);
        }
        this.finish();
        this.signalLoaded();
    }

    private void requireModuleDefs(JobEnvelope source) {
        this.maybeBreakBlock(true, source);
        if (!this.moduleDefs) {
            this.emitStatement(SafeHtmlMaker.quasiStmt("var el___;", new Object[0]), source);
            this.emitStatement(SafeHtmlMaker.quasiStmt("var emitter___ = IMPORTS___.htmlEmitter___;", new Object[0]), source);
            this.moduleDefs = true;
            this.started = true;
        }
    }

    private void finish() {
        if (this.started && !this.finished) {
            this.requireModuleDefs(SYNTHETIC_SOURCE);
            this.emitStatement(SafeHtmlMaker.quasiStmt("el___ = emitter___./*@synthetic*/finish();", new Object[0]), SYNTHETIC_SOURCE);
            this.finished = true;
        }
    }

    private void signalLoaded() {
        this.maybeBreakBlock(true, SYNTHETIC_SOURCE);
        if (this.moduleDefs) {
            this.emitStatement(SafeHtmlMaker.quasiStmt("emitter___./*@synthetic*/signalLoaded();", new Object[0]), SYNTHETIC_SOURCE);
        } else if (!this.js.isEmpty()) {
            this.emitStatement(SafeHtmlMaker.quasiStmt("IMPORTS___.htmlEmitter___./*@synthetic*/signalLoaded();", new Object[0]), SYNTHETIC_SOURCE);
        }
    }

    private void fleshOutScriptBlock(ScriptBone bone) {
        FilePosition unk = FilePosition.UNKNOWN;
        FilePosition pos = bone.body.getFilePosition();
        String sourcePath = this.mc.abbreviate(pos.source());
        if (bone.source.fromCache) {
            CajoledModule scriptFromCache = (CajoledModule)bone.body;
            this.finishBlock();
            this.js.add(new SafeJsChunk(bone.source, scriptFromCache));
        } else {
            Block scriptToWrapAndProcess = (Block)bone.body;
            this.emitStatement(SafeHtmlMaker.quasiStmt("try {  @scriptBody;} catch (ex___) {  ___./*@synthetic*/ getNewModuleHandler()      ./*@synthetic*/ handleUncaughtException(          ex___, onerror, @sourceFile, @line);}", "scriptBody", scriptToWrapAndProcess, "sourceFile", StringLiteral.valueOf(unk, sourcePath), "line", StringLiteral.valueOf(unk, String.valueOf(pos.startLineNo()))), false, bone.source);
        }
    }

    private void insertPlaceholderAfter(NodeBone preceder) {
        String dynId = this.meta.generateUniqueName(SafeHtmlMaker.ID.localName);
        this.emitStatement(SafeHtmlMaker.quasiStmt("emitter___./*@synthetic*/discard(    emitter___./*@synthetic*/attach(@id));", "id", StringLiteral.valueOf(FilePosition.UNKNOWN, dynId)), preceder.source);
        Node follower = preceder.safeNode.getNextSibling();
        Node parent = preceder.safeNode.getParentNode();
        if (SafeHtmlMaker.containsOnlyText(parent)) {
            assert (follower == null);
            follower = parent.getNextSibling();
            parent = parent.getParentNode();
            assert (!SafeHtmlMaker.containsOnlyText(parent));
        }
        Element placeholder = this.doc.createElementNS("http://www.w3.org/1999/xhtml", "span");
        placeholder.setAttributeNS("http://www.w3.org/1999/xhtml", SafeHtmlMaker.ID.localName, dynId);
        parent.insertBefore(placeholder, follower);
    }

    private static boolean containsOnlyText(Node n) {
        if (!(n instanceof Element)) {
            return false;
        }
        Element el = (Element)n;
        ElKey schemaKey = ElKey.forElement(el);
        if (schemaKey.isHtml()) {
            HtmlTextEscapingMode mode = HtmlTextEscapingMode.getModeForTag(schemaKey.localName);
            return mode != HtmlTextEscapingMode.PCDATA;
        }
        return false;
    }

    private void fleshOutElement(NodeBone bone, boolean splitDom) {
        Element el = (Element)bone.node;
        Element safe = (Element)bone.safeNode;
        FilePosition pos = Nodes.getFilePositionFor(el);
        String dynId = null;
        if (splitDom) {
            dynId = this.makeDynamicId(null, pos, bone.source);
            this.emitStatement(SafeHtmlMaker.quasiStmt("emitter___./*@synthetic*/attach(@id);", "id", StringLiteral.valueOf(FilePosition.UNKNOWN, dynId)), bone.source);
        }
        Nodes.setFilePositionFor(safe, pos);
        ElKey elKey = ElKey.forElement(el);
        Attr id = null;
        for (Attr attr : Nodes.attributesOf(el)) {
            if (!this.scriptsPerNode.containsKey(attr)) continue;
            AttribKey attrKey = AttribKey.forAttribute(elKey, attr);
            Expression dynamicValue = (Expression)this.scriptsPerNode.get(attr);
            if (SafeHtmlMaker.ID.ns.uri != attrKey.ns.uri || !SafeHtmlMaker.ID.localName.equals(attrKey.localName)) {
                if (dynamicValue == null || dynamicValue instanceof StringLiteral) {
                    this.emitStaticAttr(attr, (StringLiteral)dynamicValue, safe);
                    continue;
                }
                dynId = this.makeDynamicId(dynId, pos, bone.source);
                String handlerName = dynamicValue.getAttributes().get(HtmlAttributeRewriter.HANDLER_NAME);
                if (handlerName != null && this.handlers.containsKey(handlerName) && this.handlersUsedInModule.add(handlerName)) {
                    this.emitHandler(handlerName);
                }
                this.emitDynamicAttr(attr, dynamicValue, bone.source);
                continue;
            }
            assert (id == null);
            id = attr;
        }
        if (id != null) {
            Expression dynamicValue = (Expression)this.scriptsPerNode.get(id);
            if (dynId == null && (dynamicValue == null || dynamicValue instanceof StringLiteral)) {
                this.emitStaticAttr(id, (StringLiteral)dynamicValue, safe);
            } else {
                dynId = this.makeDynamicId(dynId, pos, bone.source);
                this.emitDynamicAttr(id, dynamicValue, bone.source);
            }
        }
        if (dynId != null) {
            assert (!safe.hasAttributeNS(SafeHtmlMaker.ID.ns.uri, SafeHtmlMaker.ID.localName));
            safe.setAttributeNS(SafeHtmlMaker.ID.ns.uri, SafeHtmlMaker.ID.localName, dynId);
            if (id == null) {
                this.emitStatement(SafeHtmlMaker.quasiStmt("el___./*@synthetic*/removeAttribute('id');", new Object[0]), bone.source);
            }
        }
    }

    private void emitStaticAttr(Attr a, StringLiteral dynamicValue, Element safe) {
        Attr safeAttr = this.doc.createAttributeNS(a.getNamespaceURI(), a.getName());
        safeAttr.setValue(dynamicValue == null ? a.getValue() : dynamicValue.getUnquotedValue());
        Nodes.setFilePositionFor(safeAttr, Nodes.getFilePositionFor(a));
        Nodes.setFilePositionForValue(safeAttr, Nodes.getFilePositionForValue(a));
        safe.setAttributeNodeNS(safeAttr);
    }

    private void emitDynamicAttr(Attr a, Expression dynamicValue, JobEnvelope source) {
        FilePosition pos = Nodes.getFilePositionFor(a);
        String name = a.getName();
        if (dynamicValue instanceof FunctionConstructor) {
            this.emitStatement(SafeHtmlMaker.quasiStmt("el___.@name = @eventAdapter;", "name", new Reference(SyntheticNodes.s(new Identifier(pos, name))), "eventAdapter", dynamicValue), source);
        } else {
            this.emitStatement(SafeHtmlMaker.quasiStmt("emitter___./*@synthetic*/setAttr(el___, @name, @value);", "name", StringLiteral.valueOf(pos, name), "value", dynamicValue), source);
        }
    }

    private String makeDynamicId(String dynId, FilePosition pos, JobEnvelope source) {
        this.requireModuleDefs(source);
        if (dynId == null) {
            dynId = this.meta.generateUniqueName(SafeHtmlMaker.ID.localName);
            this.emitStatement(SafeHtmlMaker.quasiStmt("el___ = emitter___./*@synthetic*/byId(@id);", "id", StringLiteral.valueOf(pos, dynId)), source);
        }
        assert (SafeHtmlMaker.isDynamicId(dynId));
        return dynId;
    }

    private static boolean isDynamicId(String id) {
        return DYNID_PATTERN.matcher(id).matches();
    }

    private static Statement quasiStmt(String quasi, Object ... args) {
        return QuasiUtil.quasiStmt(quasi, args);
    }

    private void emitStatement(Statement s, JobEnvelope source) {
        this.emitStatement(s, true, source);
    }

    private void maybeBreakBlock(boolean translated, JobEnvelope source) {
        if (translated != this.currentBlockStyle || !source.areFromSameSource(this.currentSource)) {
            this.finishBlock();
        }
    }

    private void emitStatement(Statement s, boolean translated, JobEnvelope src) {
        this.maybeBreakBlock(translated, src);
        if (this.currentBlock == null) {
            this.handlersUsedInModule.clear();
            Block block = new Block();
            this.js.add(new SafeJsChunk(src, block));
            if (translated) {
                block.appendChild(new DirectivePrologue(FilePosition.UNKNOWN, Lists.newArrayList(new Directive(FilePosition.UNKNOWN, "use cajita"))));
                this.currentBlock = new Block();
                TranslatedCode code = new TranslatedCode(this.currentBlock);
                block.appendChild(code);
            } else {
                this.currentBlock = block;
            }
            this.currentSource = src;
            this.currentBlockStyle = translated;
            this.moduleDefs = false;
        }
        this.currentBlock.appendChild(s);
    }

    private void emitHandler(String handlerName) {
        Pair<JobEnvelope, Declaration> handler = this.handlers.get(handlerName);
        this.emitHandler((Statement)handler.b, (JobEnvelope)handler.a);
    }

    private void emitHandler(Statement handler, JobEnvelope source) {
        Block block;
        Statement s;
        this.emitStatement(handler, true, source);
        if (SafeHtmlMaker.hasNonStrictFn(handler) && (s = (block = (Block)this.js.get((int)(this.js.size() - 1)).body).children().get(0)) instanceof DirectivePrologue) {
            block.replaceChild(new Noop(s.getFilePosition()), s);
        }
    }

    private void finishBlock() {
        this.currentBlock = null;
        this.moduleDefs = false;
    }

    private static boolean hasNonStrictFn(ParseTreeNode n) {
        if (n instanceof FunctionConstructor) {
            Statement statement;
            Block body = ((FunctionConstructor)n).getBody();
            if (!body.children().isEmpty() && (statement = body.children().get(0)) instanceof DirectivePrologue) {
                DirectivePrologue dp = (DirectivePrologue)statement;
                for (Directive directive : dp.children()) {
                    if (!"use cajita".equals(directive.getDirectiveString())) continue;
                    return false;
                }
            }
            return true;
        }
        for (ParseTreeNode parseTreeNode : n.children()) {
            if (!SafeHtmlMaker.hasNonStrictFn(parseTreeNode)) continue;
            return true;
        }
        return false;
    }

    private static String getPlaceholderId(Node n) {
        if (n.getNodeType() != 1) {
            return null;
        }
        if (!"span".equals(n.getLocalName())) {
            return null;
        }
        Attr a = ((Element)n).getAttributeNodeNS(Placeholder.ID_ATTR.ns.uri, Placeholder.ID_ATTR.localName);
        return a != null ? a.getValue() : null;
    }

    private static final class ScriptBone
    extends DomBone {
        final ParseTreeNode body;

        ScriptBone(JobEnvelope source, ParseTreeNode body) {
            super(source);
            this.body = body;
        }

        public String toString() {
            return "(" + this.getClass().getSimpleName() + ")";
        }
    }

    private static final class NodeBone
    extends DomBone {
        final Node node;
        final Node safeNode;

        NodeBone(JobEnvelope source, Node node, Node safeNode) {
            super(source);
            this.node = node;
            this.safeNode = safeNode;
        }

        public String toString() {
            return "(" + this.getClass().getSimpleName() + " " + this.safeNode.getNodeName() + ")";
        }
    }

    private static class DomBone {
        final JobEnvelope source;

        DomBone(JobEnvelope source) {
            this.source = source;
        }
    }
}

