/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.tools;

import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.tools.BuildCommand;
import com.google.caja.util.Charsets;
import com.google.caja.util.Lists;
import com.google.caja.util.Strings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnumsToJs
implements BuildCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean build(List<File> inputs, List<File> dependencies, Map<String, Object> options, File output) {
        List<Class<? extends Enum<?>>> enumClasses = this.loadEnumClasses(inputs, System.err);
        if (enumClasses == null) {
            return false;
        }
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(output), Charsets.UTF_8);
            try {
                this.generateJavaScriptForEnums(enumClasses, out);
            }
            finally {
                ((Writer)out).close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    private List<Class<? extends Enum<?>>> loadEnumClasses(Iterable<? extends File> inputs, PrintStream err) {
        List<Class<Enum<?>>> enumClasses = Lists.newArrayList();
        for (File file : inputs) {
            Class<Enum> enumClass;
            String path = file.getPath();
            int start = path.indexOf(File.separator + "com" + File.separator);
            path = path.substring(start + 1);
            String className = path.replaceFirst("\\.class$", "").replace(File.separatorChar, '.');
            ClassLoader loader = this.getClass().getClassLoader();
            try {
                Class<Enum> clazz;
                Class<?> cl = loader != null ? loader.loadClass(className) : Class.forName(className);
                enumClass = clazz = cl.asSubclass(Enum.class);
            }
            catch (ClassNotFoundException ex) {
                err.println("Could not find class " + className + " for " + path);
                return null;
            }
            catch (ClassCastException ex) {
                err.println("Class " + className + " for " + path + " is not an enum");
                return null;
            }
            enumClasses.add(enumClass);
        }
        return enumClasses;
    }

    void generateJavaScriptForEnums(Iterable<Class<? extends Enum<?>>> enumClasses, Appendable out) throws IOException {
        out.append("// Autogenerated by ").append(this.getClass().getName()).append("\n");
        for (Class<Enum<?>> enumClass : enumClasses) {
            String classNameUnderscored = Strings.toUpperCase(enumClass.getSimpleName().replaceAll("([a-z0-9$])([A-Z])", "$1_$2"));
            out.append("\n// From ").append(enumClass.getName()).append("\n");
            Class<Enum<?>> raw = enumClass;
            EnumSet<Enum<?>> values = EnumSet.allOf(raw);
            out.append("var ").append(classNameUnderscored).append(" = [");
            boolean first = true;
            for (Object e : values) {
                Enum enumValue = (Enum)e;
                out.append(first ? "'" : ", '");
                Escaping.escapeJsString((CharSequence)enumValue.name(), false, false, out);
                out.append('\'');
                first = false;
            }
            out.append("];\n");
            for (Object e : values) {
                Enum enum_ = (Enum)e;
                String name = classNameUnderscored + "$" + enum_.name();
                out.append("var ").append(name).append(" = ").append(Integer.toString(enum_.ordinal())).append(";\n");
            }
        }
    }
}

