/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.CssTokenType;
import com.google.caja.lexer.FetchedData;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.GuessContentType;
import com.google.caja.lexer.HtmlLexer;
import com.google.caja.lexer.HtmlTokenType;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.JsTokenType;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.lexer.TokenQueue;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.css.CssParser;
import com.google.caja.parser.css.CssTree;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.Parser;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsMinimalPrinter;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.ContentType;
import com.google.caja.util.Criterion;
import com.google.caja.util.FailureIsAnOption;
import com.google.caja.util.Join;
import com.google.caja.util.TestUtil;
import java.awt.GraphicsEnvironment;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URI;
import junit.framework.TestCase;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CajaTestCase
extends TestCase {
    protected InputSource is;
    protected MessageContext mc;
    protected MessageQueue mq;
    protected static final long SEED = Long.parseLong(System.getProperty("junit.seed", "" + System.currentTimeMillis()));
    private static boolean dumpedSeed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() throws Exception {
        Class<CajaTestCase> clazz = CajaTestCase.class;
        synchronized (CajaTestCase.class) {
            if (!dumpedSeed) {
                dumpedSeed = true;
                System.err.println("junit.seed=" + SEED);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.is = new InputSource(URI.create("test://example.org/" + this.getName()));
            this.mc = new MessageContext();
            this.mc.addInputSource(this.is);
            this.mq = TestUtil.createTestMessageQueue(this.mc);
            return;
        }
    }

    protected void tearDown() throws Exception {
        this.is = null;
        this.mc = null;
        this.mq = null;
    }

    protected CharProducer fromString(String ... content) {
        return this.fromString(Join.join((CharSequence)"\n", content), this.is);
    }

    protected CharProducer fromString(String content, InputSource is) {
        this.mc.addInputSource(is);
        return CharProducer.Factory.create(new StringReader(content), is);
    }

    protected CharProducer fromString(String content, FilePosition pos) {
        this.mc.addInputSource(this.is);
        return CharProducer.Factory.create(new StringReader(content), pos);
    }

    protected CharProducer fromResource(String resourcePath) throws IOException {
        URI resource = TestUtil.getResource(((Object)((Object)this)).getClass(), resourcePath);
        if (resource == null) {
            throw new FileNotFoundException(resourcePath);
        }
        return this.fromResource(resourcePath, new InputSource(resource));
    }

    protected CharProducer fromResource(String resourcePath, InputSource is) throws IOException {
        return this.dataFromResource(resourcePath, is).getTextualContent();
    }

    protected FetchedData dataFromResource(String resourcePath, InputSource is) throws IOException {
        ContentType guess = GuessContentType.guess(null, resourcePath, null);
        InputStream in = TestUtil.getResourceAsStream(((Object)((Object)this)).getClass(), resourcePath);
        this.mc.addInputSource(is);
        return FetchedData.fromStream(in, guess != null ? guess.mimeType : "", "UTF-8", is);
    }

    protected String plain(CharProducer cp) {
        return cp.toString(cp.getOffset(), cp.getLimit());
    }

    protected Block js(CharProducer cp) throws ParseException {
        return this.js(cp, false);
    }

    protected Expression jsExpr(CharProducer cp) throws ParseException {
        return this.jsExpr(cp, false);
    }

    protected Block js(CharProducer cp, boolean quasi) throws ParseException {
        return this.js(cp, JsTokenQueue.NO_COMMENT, quasi);
    }

    protected Block js(CharProducer cp, Criterion<Token<JsTokenType>> filt, boolean quasi) throws ParseException {
        JsLexer lexer = new JsLexer(cp);
        JsTokenQueue tq = new JsTokenQueue(lexer, this.sourceOf(cp), filt);
        Parser p = new Parser(tq, this.mq, quasi);
        Block b = p.parse();
        tq.expectEmpty();
        return b;
    }

    protected Expression jsExpr(CharProducer cp, boolean quasi) throws ParseException {
        JsLexer lexer = new JsLexer(cp);
        JsTokenQueue tq = new JsTokenQueue(lexer, this.sourceOf(cp), JsTokenQueue.NO_COMMENT);
        Parser p = new Parser(tq, this.mq, quasi);
        Expression e = p.parseExpression(true);
        tq.expectEmpty();
        return e;
    }

    protected Block quasi(CharProducer cp) throws ParseException {
        return this.js(cp, true);
    }

    protected Element xml(CharProducer cp) throws ParseException {
        return (Element)this.parseMarkup(cp, true, true);
    }

    protected DocumentFragment xmlFragment(CharProducer cp) throws ParseException {
        return (DocumentFragment)this.parseMarkup(cp, true, false);
    }

    protected Element html(CharProducer cp) throws ParseException {
        return (Element)this.parseMarkup(cp, false, true);
    }

    protected DocumentFragment htmlFragment(CharProducer cp) throws ParseException {
        return (DocumentFragment)this.parseMarkup(cp, false, false);
    }

    private Node parseMarkup(CharProducer cp, boolean asXml, boolean asDoc) throws ParseException {
        InputSource is = this.sourceOf(cp);
        HtmlLexer lexer = new HtmlLexer(cp);
        lexer.setTreatedAsXml(asXml);
        TokenQueue<HtmlTokenType> tq = new TokenQueue<HtmlTokenType>(lexer, is, DomParser.SKIP_COMMENTS);
        DomParser p = new DomParser(tq, asXml, this.mq);
        Node t = asDoc ? p.parseDocument() : p.parseFragment();
        tq.expectEmpty();
        return t;
    }

    protected Element markup(CharProducer cp) throws ParseException {
        return new DomParser(new HtmlLexer(cp), false, this.sourceOf(cp), this.mq).parseDocument();
    }

    protected DocumentFragment markupFragment(CharProducer cp) throws ParseException {
        return new DomParser(new HtmlLexer(cp), false, this.sourceOf(cp), this.mq).parseFragment();
    }

    protected CssTree.StyleSheet css(CharProducer cp) throws ParseException {
        return this.css(cp, false);
    }

    protected CssTree.StyleSheet css(CharProducer cp, boolean substs) throws ParseException {
        TokenQueue<CssTokenType> tq = this.cssTokenQueue(cp, substs);
        CssTree.StyleSheet ss = new CssParser(tq, this.mq, MessageLevel.FATAL_ERROR).parseStyleSheet();
        tq.expectEmpty();
        return ss;
    }

    protected CssTree.DeclarationGroup cssDecls(CharProducer cp) throws ParseException {
        return this.cssDecls(cp, false);
    }

    protected CssTree.DeclarationGroup cssDecls(CharProducer cp, boolean substs) throws ParseException {
        TokenQueue<CssTokenType> tq = this.cssTokenQueue(cp, substs);
        CssTree.DeclarationGroup dg = new CssParser(tq, this.mq, MessageLevel.FATAL_ERROR).parseDeclarationGroup();
        tq.expectEmpty();
        return dg;
    }

    private TokenQueue<CssTokenType> cssTokenQueue(CharProducer cp, boolean substs) {
        return CssParser.makeTokenQueue(cp, this.mq, substs);
    }

    public static String render(MessageQueue mq) {
        StringBuilder sb = new StringBuilder();
        for (Message m : mq.getMessages()) {
            try {
                m.format(new MessageContext(), sb);
            }
            catch (IOException e) {
                sb.append(e.toString());
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String render(ParseTreeNode node) {
        if (node == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        TokenConsumer tc = node.makeRenderer(sb, null);
        node.render(new RenderContext(tc));
        tc.noMoreTokens();
        return sb.toString();
    }

    public static String renderProgram(Block program) {
        StringBuilder sb = new StringBuilder();
        TokenConsumer tc = program.makeRenderer(sb, null);
        program.renderBody(new RenderContext(tc));
        tc.noMoreTokens();
        return sb.toString();
    }

    protected String formatShort(FilePosition p) {
        StringBuilder sb = new StringBuilder();
        try {
            p.formatShort(sb);
        }
        catch (IOException ex) {
            throw new SomethingWidgyHappenedError("IOException from StringBuilder", (Throwable)ex);
        }
        return sb.toString();
    }

    protected String minify(ParseTreeNode node) {
        if (node == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (!(node.makeRenderer(sb, null) instanceof JsPrettyPrinter)) {
            throw new ClassCastException(node.getClass().getName());
        }
        JsMinimalPrinter tc = new JsMinimalPrinter(new Concatenator(sb));
        node.render(new RenderContext(tc));
        tc.noMoreTokens();
        return sb.toString();
    }

    protected void assertCloneable(ParseTreeNode node) {
        this.assertDeepEquals(node, node.clone());
    }

    protected void assertDeepEquals(ParseTreeNode a, ParseTreeNode b) {
        CajaTestCase.assertEquals((Object)a.getValue(), (Object)b.getValue());
        CajaTestCase.assertEquals((Object)a.getFilePosition(), (Object)b.getFilePosition());
        CajaTestCase.assertEquals((int)a.children().size(), (int)b.children().size());
        for (int i = 0; i < a.children().size(); ++i) {
            this.assertDeepEquals(a.children().get(i), b.children().get(i));
        }
    }

    protected static void assertArrayEquals(Object[] a, Object[] b) {
        CajaTestCase.assertEquals((int)a.length, (int)b.length);
        for (int i = 0; i < a.length; ++i) {
            if (a[i] instanceof String && b[i] instanceof String) {
                CajaTestCase.assertEquals((String)((String)a[i]), (String)((String)b[i]));
                continue;
            }
            CajaTestCase.assertEquals((Object)a[i], (Object)b[i]);
        }
    }

    protected void assertMessagesLessSevereThan(MessageLevel level) {
        for (Message msg : this.mq.getMessages()) {
            if (level.compareTo(msg.getMessageLevel()) > 0) continue;
            CajaTestCase.fail((String)msg.format(this.mc));
        }
    }

    protected void assertNoErrors() {
        this.assertMessagesLessSevereThan(MessageLevel.ERROR);
    }

    protected void assertNoWarnings() {
        this.assertMessagesLessSevereThan(MessageLevel.WARNING);
    }

    protected void assertMessage(MessageTypeInt type, MessageLevel level, MessagePart ... expectedParts) {
        this.assertMessage(false, type, level, expectedParts);
    }

    protected void assertMessage(boolean consume, MessageTypeInt type, MessageLevel level, MessagePart ... expectedParts) {
        Message closest = null;
        int closestScore = Integer.MIN_VALUE;
        for (Message msg : this.mq.getMessages()) {
            int score = 0;
            if (msg.getMessageType() == type) {
                ++score;
            }
            if (msg.getMessageLevel() == level) {
                ++score;
            }
            if ((score -= CajaTestCase.partsMissing(msg, expectedParts)) == 2) {
                if (consume) {
                    this.mq.getMessages().remove(msg);
                }
                return;
            }
            if (score <= closestScore) continue;
            closest = msg;
            closestScore = score;
        }
        if (closest == null) {
            CajaTestCase.fail((String)("No message found of type " + type + " and level " + (Object)((Object)level)));
        } else {
            CajaTestCase.fail((String)("Failed to find message.  Closest match was " + closest.format(this.mc) + " with parts " + closest.getMessageParts()));
        }
    }

    protected void assertNoMessage(MessageTypeInt type) {
        for (Message msg : this.mq.getMessages()) {
            if (msg.getMessageType() != type) continue;
            CajaTestCase.fail((String)msg.format(this.mc));
        }
    }

    private static int partsMissing(Message msg, MessagePart ... parts) {
        int missing = 0;
        block0: for (MessagePart expectedPart : parts) {
            for (MessagePart candidate : msg.getMessageParts()) {
                if (candidate.equals(expectedPart)) continue block0;
                if (!(candidate instanceof FilePosition) || !(expectedPart instanceof FilePosition)) continue;
                FilePosition a = (FilePosition)candidate;
                FilePosition b = (FilePosition)expectedPart;
                if (!a.source().equals(b.source()) || a.startLineNo() != b.startLineNo() || a.startCharInLine() != b.startCharInLine() || a.endLineNo() != b.endLineNo() || a.endCharInLine() != b.endCharInLine()) continue;
                continue block0;
            }
            ++missing;
        }
        return missing;
    }

    private InputSource sourceOf(CharProducer cp) {
        return cp.getSourceBreaks(0).source();
    }

    protected boolean checkHeadless() {
        if (Boolean.getBoolean("test.headless")) {
            CajaTestCase.assertTrue((String)"test.headless==true in non-headless environment", (boolean)GraphicsEnvironment.isHeadless());
            System.err.println(this.getName() + " skipped in headless testing");
            return true;
        }
        CajaTestCase.assertFalse((String)"test.headless==false in headless environment", (boolean)GraphicsEnvironment.isHeadless());
        return false;
    }

    protected void runTest() throws Throwable {
        if ("true".equals("test.suppressKnownFailures")) {
            try {
                Method method = ((Object)((Object)this)).getClass().getMethod(this.getName(), new Class[0]);
                if (method.isAnnotationPresent(FailureIsAnOption.class)) {
                    try {
                        super.runTest();
                    }
                    catch (Throwable th) {
                        System.err.println("Suppressing known failure of " + this.getName());
                        th.printStackTrace();
                    }
                }
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        super.runTest();
    }
}

