/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import java.util.Formatter;
import java.util.List;
import java.util.ListIterator;
import junit.framework.Assert;
import junit.framework.ComparisonFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MoreAsserts {
    public static <T> void assertListsEqual(List<? extends T> expected, List<? extends T> actual) {
        MoreAsserts.assertListsEqual(expected, actual, 2);
    }

    public static <T> void assertListsEqual(List<? extends T> expected, List<? extends T> actual, int diffContext) {
        int commonSuffix;
        int m = expected.size();
        int n = actual.size();
        int commonPrefix = 0;
        ListIterator<T> i = expected.listIterator();
        ListIterator<T> j = actual.listIterator();
        while (i.hasNext() && j.hasNext() && MoreAsserts.areEqual(i.next(), j.next())) {
            ++commonPrefix;
        }
        if (commonPrefix == Math.max(m, n)) {
            return;
        }
        if (commonPrefix != Math.min(m, n)) {
            ListIterator<T> i2 = expected.listIterator(m);
            ListIterator<T> j2 = actual.listIterator(n);
            int max = Math.min(m, n) - commonPrefix;
            for (commonSuffix = 0; commonSuffix < max && i2.hasPrevious() && j2.hasPrevious() && MoreAsserts.areEqual(i2.previous(), j2.previous()); ++commonSuffix) {
            }
        }
        throw new ComparisonFailure("Expected: {{{\n" + MoreAsserts.snippet(expected, Math.max(commonPrefix - diffContext, 0), Math.min(m, m - commonSuffix + diffContext), 84) + "\n}}} != {{{\n" + MoreAsserts.snippet(actual, Math.max(commonPrefix - diffContext, 0), Math.min(n, n - commonSuffix + diffContext), 84) + "\n}}}", MoreAsserts.snippet(expected, 0, expected.size(), Integer.MAX_VALUE), MoreAsserts.snippet(actual, 0, actual.size(), Integer.MAX_VALUE));
    }

    public static void assertStartsWith(String expected, String actual) {
        if (expected.length() > actual.length()) {
            Assert.fail((String)("Expected string that starts with: {{{\n" + expected + "\n}}} != {{{\n" + actual + "\n}}}"));
        } else {
            Assert.assertEquals((String)expected, (String)actual.substring(0, expected.length()));
        }
    }

    private static String snippet(List<?> a, int start, int end, int maxlen) {
        StringBuilder sb = new StringBuilder();
        if (start != 0) {
            sb.append("\t...");
        }
        Formatter f = new Formatter(sb);
        int index = start;
        for (Object item : a.subList(start, end)) {
            if (sb.length() != 0) {
                sb.append('\n');
            }
            if (item != null) {
                String type = item.getClass().getSimpleName();
                f.format("\t%3d %s: %s", index, MoreAsserts.abbreviatedString("" + item, maxlen - type.length()), type);
            } else {
                f.format("\t%3d <null>", index);
            }
            ++index;
        }
        if (end < a.size()) {
            if (sb.length() != 0) {
                sb.append('\n');
            }
            sb.append("\t...");
        }
        return sb.toString();
    }

    private static String abbreviatedString(String s, int maxLen) {
        if ((s = s.replace("\\", "\\\\").replace("\n", "\\n").replace("\r", "\\r")).length() > maxLen) {
            System.err.println("<<<" + s + ">>>");
            int headLen = (maxLen - 3) / 2;
            int tailLen = maxLen - 3 - headLen;
            s = s.substring(0, headLen) + "..." + s.substring(s.length() - tailLen);
        }
        return "`" + s + "`";
    }

    private static boolean areEqual(Object a, Object b) {
        return a != null ? a.equals(b) : b == null;
    }

    private MoreAsserts() {
    }
}

