/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public class CachingTokenFilter
extends TokenFilter {
    private List cache;
    private Iterator iterator;

    public CachingTokenFilter(TokenStream input) {
        super(input);
    }

    public Token next() throws IOException {
        if (this.cache == null) {
            this.cache = new LinkedList();
            this.fillCache();
            this.iterator = this.cache.iterator();
        }
        if (!this.iterator.hasNext()) {
            return null;
        }
        return (Token)this.iterator.next();
    }

    public void reset() throws IOException {
        if (this.cache != null) {
            this.iterator = this.cache.iterator();
        }
    }

    private void fillCache() throws IOException {
        Token token;
        while ((token = this.input.next()) != null) {
            this.cache.add(token);
        }
    }
}

