/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

public class BitBuffer {
    private int currentByte;
    private int currentBit;
    private byte[] byteBuffer;
    private int eofByte;
    private int[] backMask;
    private int[] frontMask;
    private boolean eofFlag;

    public BitBuffer(byte[] byteBuffer) {
        this.byteBuffer = byteBuffer;
        this.currentByte = 0;
        this.currentBit = 0;
        this.eofByte = byteBuffer.length;
        this.backMask = new int[]{0, 1, 3, 7, 15, 31, 63, 127};
        this.frontMask = new int[]{0, 128, 192, 224, 240, 248, 252, 254};
    }

    public int getBits(int bitsToRead) {
        if (bitsToRead == 0) {
            return 0;
        }
        if (this.eofFlag) {
            return -1;
        }
        int toStore = 0;
        while (bitsToRead != 0 && !this.eofFlag) {
            int cb;
            if (bitsToRead >= 8 - this.currentBit) {
                if (this.currentBit == 0) {
                    toStore <<= 8;
                    cb = this.byteBuffer[this.currentByte];
                    toStore += cb < 0 ? 256 + cb : cb;
                    bitsToRead -= 8;
                    ++this.currentByte;
                } else {
                    toStore <<= 8 - this.currentBit;
                    toStore += this.byteBuffer[this.currentByte] & this.backMask[8 - this.currentBit];
                    bitsToRead -= 8 - this.currentBit;
                    this.currentBit = 0;
                    ++this.currentByte;
                }
            } else {
                toStore <<= bitsToRead;
                cb = this.byteBuffer[this.currentByte];
                cb = cb < 0 ? 256 + cb : cb;
                toStore += (cb & 255 - this.frontMask[this.currentBit]) >> 8 - (this.currentBit + bitsToRead);
                this.currentBit += bitsToRead;
                bitsToRead = 0;
            }
            if (this.currentByte != this.eofByte) continue;
            this.eofFlag = true;
            return toStore;
        }
        return toStore;
    }
}

