/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.IJ;
import ij.ImageJ;
import ij.WindowManager;
import ij.plugin.frame.Editor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class FunctionFinder
implements TextListener,
WindowListener,
KeyListener,
ItemListener {
    Dialog d;
    TextField prompt;
    List completions;
    String[] commands;

    public FunctionFinder() {
        String exists = IJ.runMacro("return File.exists(getDirectory('macros')+'functions.html');");
        if (exists == "0") {
            String installLocalMacroFunctionsFile = "functions = File.openUrlAsString('http://rsb.info.nih.gov/ij/developer/macro/functions.html');\nf = File.open(getDirectory('macros')+'functions.html');\nprint (f, functions);\nFile.close(f);";
            try {
                IJ.runMacro(installLocalMacroFunctionsFile);
            }
            catch (Throwable e) {
                IJ.error("Problem downloading functions.html");
                return;
            }
        }
        String f = IJ.runMacro("return File.openAsString(getDirectory('macros')+'functions.html');");
        String[] l = f.split("\n");
        this.commands = new String[l.length];
        int c = 0;
        for (int i = 0; i < l.length; ++i) {
            String line = l[i];
            if (!line.startsWith("<b>")) continue;
            this.commands[c] = line.substring(line.indexOf("<b>") + 3, line.indexOf("</b>"));
            ++c;
        }
        if (c == 0) {
            IJ.error("Image/macros/functions.html is corrupted");
            return;
        }
        ImageJ imageJ = IJ.getInstance();
        this.d = new Dialog((Frame)imageJ, "Built-in Functions");
        this.d.setLayout(new BorderLayout());
        this.d.addWindowListener(this);
        Panel northPanel = new Panel();
        this.prompt = new TextField("", 30);
        this.prompt.addTextListener(this);
        this.prompt.addKeyListener(this);
        northPanel.add(this.prompt);
        this.d.add((Component)northPanel, "North");
        this.completions = new List(12);
        this.completions.addKeyListener(this);
        this.populateList("");
        this.d.add((Component)this.completions, "Center");
        this.d.pack();
        Frame frame = WindowManager.getFrontWindow();
        if (frame == null) {
            return;
        }
        Point posi = frame.getLocationOnScreen();
        int initialX = (int)posi.getX() + 38;
        int initialY = (int)posi.getY() + 84;
        this.d.setLocation(initialX, initialY);
        this.d.setVisible(true);
        this.d.toFront();
    }

    public void populateList(String matchingSubstring) {
        String substring = matchingSubstring.toLowerCase();
        this.completions.removeAll();
        try {
            for (int i = 0; i < this.commands.length; ++i) {
                String lowerCommandName;
                String commandName = this.commands[i];
                if (commandName.length() == 0 || (lowerCommandName = commandName.toLowerCase()).indexOf(substring) < 0) continue;
                this.completions.add(this.commands[i]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void edPaste(String arg) {
        Frame frame = WindowManager.getFrontWindow();
        try {
            TextArea ta = ((Editor)frame).getTextArea();
            int start = ta.getSelectionStart();
            int end = ta.getSelectionEnd();
            try {
                ta.replaceRange(arg.substring(0, arg.length()), start, end);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (IJ.isMacOSX()) {
                ta.setCaretPosition(start + arg.length());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void itemStateChanged(ItemEvent ie) {
        this.populateList(this.prompt.getText());
    }

    protected void runFromLabel(String listLabel) {
        this.edPaste(listLabel);
        this.d.dispose();
    }

    public void keyPressed(KeyEvent ke) {
        String selected;
        int key = ke.getKeyCode();
        int items = this.completions.getItemCount();
        Object source = ke.getSource();
        if (source == this.prompt) {
            if (key == 10) {
                if (1 == items) {
                    String selected2 = this.completions.getItem(0);
                    this.runFromLabel(selected2);
                }
            } else if (key == 38) {
                this.completions.requestFocus();
                if (items > 0) {
                    this.completions.select(this.completions.getItemCount() - 1);
                }
            } else if (key == 27) {
                this.d.dispose();
            } else if (key == 40) {
                this.completions.requestFocus();
                if (items > 0) {
                    this.completions.select(0);
                }
            }
        } else if (source == this.completions && key == 10 && (selected = this.completions.getSelectedItem()) != null) {
            this.runFromLabel(selected);
        }
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void keyTyped(KeyEvent ke) {
    }

    public void textValueChanged(TextEvent te) {
        this.populateList(this.prompt.getText());
    }

    public void windowClosing(WindowEvent e) {
        this.d.dispose();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }
}

