/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.contentbrowser;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remove;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.contexts.Context;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.interfaces.ejb.ECContentRoot;
import org.nuxeo.ecm.platform.ui.web.api.UserAction;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.contentbrowser.ContentRootsActions;
import org.nuxeo.ecm.webapp.table.cell.AbstractTableCell;
import org.nuxeo.ecm.webapp.table.cell.DateTableCell;
import org.nuxeo.ecm.webapp.table.cell.DocModelTableCell;
import org.nuxeo.ecm.webapp.table.cell.IconTableCell;
import org.nuxeo.ecm.webapp.table.cell.SelectionTableCell;
import org.nuxeo.ecm.webapp.table.cell.TableCell;
import org.nuxeo.ecm.webapp.table.header.CheckBoxColHeader;
import org.nuxeo.ecm.webapp.table.header.DocModelColHeader;
import org.nuxeo.ecm.webapp.table.header.IconColHeader;
import org.nuxeo.ecm.webapp.table.header.TableColHeader;
import org.nuxeo.ecm.webapp.table.model.DocModelTableModel;
import org.nuxeo.ecm.webapp.table.row.DocModelTableRow;
import org.nuxeo.ecm.webapp.table.row.TableRow;

@Name(value="contentRootsActions")
@Scope(value=ScopeType.SESSION)
@Deprecated
public class ContentRootsActionsBean
extends InputController
implements ContentRootsActions,
Serializable {
    private static final long serialVersionUID = 2464516767262727931L;
    private static final Log log = LogFactory.getLog(ContentRootsActionsBean.class);
    @In(create=true, required=false)
    transient CoreSession documentManager;
    @RequestParameter(value="tabParam")
    String tabParam;
    @In(required=false)
    DocumentModel currentDomain;
    @In(required=false)
    DocumentModel changeableDocument;
    @In
    protected transient Context sessionContext;
    @In(create=true)
    protected transient ECContentRoot ecContentRoot;
    DocumentModel currentItem;
    List<DocumentModel> workspacesChildren = null;
    List<DocumentModel> sectionsChildren = null;
    protected DocModelTableModel workspacesTableModel;
    protected DocModelTableModel sectionsTableModel;
    protected Blob logo;
    protected DocumentModel logoHolder;
    @DataModel(value="contentRootDocumentList")
    protected List<DocumentModel> contentRootDocuments;

    @Override
    @Create
    public void initialize() {
        this.sessionContext.set("useTemplateFlag", (Object)true);
        this.logo = null;
    }

    @Override
    @Destroy
    @Remove
    public void destroy() {
        log.debug((Object)"Removing Seam action listener...");
    }

    @Override
    public String display() {
        try {
            DocumentModel doc = this.getContentRootWithType(this.tabParam);
            return this.navigationContext.getActionResult(doc, UserAction.VIEW);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public String selectWorkspace() throws ClientException {
        try {
            DocumentModel doc = this.getWorkspacesTableModel().getSelectedDocModel();
            return this.navigationContext.getActionResult(doc, UserAction.VIEW);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    @Override
    public String selectSection() throws ClientException {
        try {
            DocumentModel doc = this.getWorkspacesTableModel().getSelectedDocModel();
            return this.navigationContext.getActionResult(doc, UserAction.VIEW);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    @Override
    public String editWorkspace() throws ClientException {
        this.sessionContext.set("changeableDocument", (Object)this.getWorkspacesTableModel().getSelectedDocModel());
        return "edit_workspace";
    }

    @Override
    public String updateWorkspace() throws ClientException {
        try {
            this.documentManager.saveDocument(this.changeableDocument);
            this.documentManager.save();
            DocumentModel doc = this.changeableDocument;
            return this.navigationContext.getActionResult(doc, UserAction.AFTER_EDIT);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    @Override
    public void resetTableModel() {
        this.workspacesTableModel = null;
        this.sectionsTableModel = null;
    }

    protected List<DocumentModel> getWorkspacesChildren() throws ClientException {
        if (null == this.workspacesChildren) {
            this.getWorkspaces();
        }
        return this.workspacesChildren;
    }

    protected List<DocumentModel> getSectionsChildren() throws ClientException {
        if (null == this.sectionsChildren) {
            this.getSections();
        }
        return this.sectionsChildren;
    }

    @Override
    public void getWorkspaces() throws ClientException {
        try {
            String selectedTab = "";
            DocumentModel dc = (DocumentModel)this.sessionContext.get("contentRootDocument");
            selectedTab = null == dc ? "Workspace" : (String)dc.getProperty("dublincore", "description");
            this.workspacesChildren = this.ecContentRoot.getContentRootChildren(selectedTab, this.currentDomain.getRef(), this.documentManager);
            log.debug((Object)("Retrieved workspace type children for domain: " + this.currentDomain + ' ' + this.workspacesChildren));
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    @Override
    public void getSections() throws ClientException {
        try {
            String selectedTab = "";
            DocumentModel dc = (DocumentModel)this.sessionContext.get("contentRootDocument");
            selectedTab = null == dc ? "Section" : (String)dc.getProperty("dublincore", "description");
            this.sectionsChildren = this.ecContentRoot.getContentRootChildren(selectedTab, this.currentDomain.getRef(), this.documentManager);
            log.debug((Object)("Retrieved workspace type children for domain: " + this.currentDomain + ' ' + this.sectionsChildren));
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    @Override
    public void resetContentRootDocuments() {
        this.contentRootDocuments = null;
    }

    protected List<DocumentModel> getContentRoots() throws ClientException {
        if (null == this.contentRootDocuments) {
            this.getContentRootDocuments();
        }
        return this.contentRootDocuments;
    }

    @Override
    public List<DocumentModel> getContentRootDocuments() throws ClientException {
        try {
            this.contentRootDocuments = this.ecContentRoot.getContentRootDocuments(this.currentDomain.getRef(), this.documentManager);
            this.logDocumentWithTitle("Retrieving content roots for domain: ", this.currentDomain);
            return this.contentRootDocuments;
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    protected DocumentModel getContentRootWithType(String type) throws ClientException {
        for (DocumentModel rightDocModel : this.getContentRoots()) {
            if (!type.equalsIgnoreCase((String)rightDocModel.getProperty("dublincore", "description"))) continue;
            return rightDocModel;
        }
        return null;
    }

    @Override
    @Deprecated
    public Boolean getCanAddWorkspaces() throws ClientException {
        return this.documentManager.hasPermission(this.currentDomain.getRef(), "AddChildren");
    }

    @Override
    public String cancel() {
        return "view_workspaces";
    }

    @PrePassivate
    public void saveState() {
        log.info((Object)"PrePassivate");
    }

    @PostActivate
    public void readState() {
        log.info((Object)"PostActivate");
    }

    public boolean getCanCopy() throws ClientException {
        try {
            return (!this.getWorkspacesTableModel().getSelectedRows().isEmpty() || !this.getSectionsTableModel().getSelectedRows().isEmpty()) && this.currentItem.isFolder();
        }
        catch (Exception e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public List<DocumentModel> copy() throws ClientException {
        ArrayList<DocumentModel> selectedDocs = new ArrayList<DocumentModel>();
        selectedDocs.addAll(this.getWorkspacesTableModel().getSelectedDocs());
        selectedDocs.addAll(this.getSectionsTableModel().getSelectedDocs());
        return selectedDocs;
    }

    public void removeDocumentFromList(DocumentModel doc) {
        this.removeDocumentFromList(this.workspacesChildren, doc);
    }

    @Override
    public DocModelTableModel reconstructWorkspacesTableModel() throws ClientException {
        ArrayList<TableColHeader> headers = new ArrayList<TableColHeader>();
        TableColHeader header = new CheckBoxColHeader("label.content.header.selection", "c0", false);
        headers.add(header);
        header = new IconColHeader("", "", "c1");
        headers.add(header);
        header = new DocModelColHeader("label.content.header.title", "c2");
        headers.add(header);
        header = new TableColHeader("label.content.header.modified", "c4");
        headers.add(header);
        header = new TableColHeader("label.content.header.author", "c5");
        headers.add(header);
        this.getWorkspaces();
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        for (DocumentModel doc : this.workspacesChildren) {
            rows.add(this.createDataTableRow(doc));
        }
        this.workspacesTableModel = new DocModelTableModel(headers, rows);
        this.workspacesTableModel.setSort("label.content.header.title");
        return this.workspacesTableModel;
    }

    @Override
    public DocModelTableModel reconstructSectionsTableModel() throws ClientException {
        ArrayList<TableColHeader> headers = new ArrayList<TableColHeader>();
        TableColHeader header = new CheckBoxColHeader("label.content.header.selection", "c0", false);
        headers.add(header);
        header = new IconColHeader("", "", "c1");
        headers.add(header);
        header = new DocModelColHeader("label.content.header.title", "c2");
        headers.add(header);
        header = new TableColHeader("label.content.header.modified", "c4");
        headers.add(header);
        header = new TableColHeader("label.content.header.author", "c5");
        headers.add(header);
        this.getSections();
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        for (DocumentModel doc : this.sectionsChildren) {
            rows.add(this.createDataTableRow(doc));
        }
        this.sectionsTableModel = new DocModelTableModel(headers, rows);
        this.sectionsTableModel.setSort("label.content.header.title");
        return this.sectionsTableModel;
    }

    @Override
    public DocModelTableModel getWorkspacesTableModel() throws ClientException {
        if (null == this.workspacesTableModel) {
            this.workspacesTableModel = this.reconstructWorkspacesTableModel();
        }
        return this.workspacesTableModel;
    }

    @Override
    public DocModelTableModel getSectionsTableModel() throws ClientException {
        if (null == this.sectionsTableModel) {
            this.sectionsTableModel = this.reconstructSectionsTableModel();
        }
        return this.sectionsTableModel;
    }

    protected DocModelTableRow createDataTableRow(DocumentModel doc) throws ClientException {
        ArrayList<AbstractTableCell> cells = new ArrayList<AbstractTableCell>();
        cells.add(new SelectionTableCell(false));
        String iconPath = (String)doc.getProperty("common", "icon");
        if (iconPath == null || iconPath.length() == 0) {
            iconPath = this.typeManager.getType(doc.getType()).getIcon();
        }
        cells.add(new IconTableCell(iconPath, "", "docRef:" + doc.getRef(), doc.isFolder()));
        cells.add(new DocModelTableCell(doc, "dublincore", "title"));
        Calendar modified = (Calendar)doc.getProperty("dublincore", "modified");
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy (HH:mm)");
        if (modified != null) {
            Date modifiedDate = modified.getTime();
            String modifiedStr = df.format(modifiedDate);
            cells.add(new DateTableCell(modifiedStr, modifiedDate));
        } else {
            cells.add(new TableCell(""));
        }
        String[] contributors = (String[])doc.getProperty("dublincore", "contributors");
        String author = "";
        if (null != contributors) {
            author = contributors[0];
        }
        cells.add(new TableCell(author));
        DocModelTableRow row = new DocModelTableRow(doc, cells);
        return row;
    }

    @Override
    public void selectAllRows(boolean checked) throws ClientException {
        this.getWorkspacesTableModel().selectAllRows(checked);
        this.getSectionsTableModel().selectAllRows(checked);
    }
}

