/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.osgi.BundleImpl;
import org.nuxeo.osgi.BundleRegistration;
import org.osgi.framework.BundleException;

public class BundleRegistry {
    private static final Log log = LogFactory.getLog(BundleRegistry.class);
    private final Map<Long, BundleRegistration> bundlesById = new HashMap<Long, BundleRegistration>();
    private final Map<String, BundleRegistration> bundles = new HashMap<String, BundleRegistration>();
    private final Map<String, Set<BundleRegistration>> pendings = new HashMap<String, Set<BundleRegistration>>();

    public void addBundleAlias(String alias, String symbolicName) {
        BundleRegistration breg = this.bundles.get(symbolicName);
        if (breg != null) {
            this.bundles.put(alias, breg);
        }
    }

    public synchronized BundleImpl getBundle(long id) {
        BundleRegistration reg = this.bundlesById.get(id);
        return reg == null ? null : reg.bundle;
    }

    public synchronized BundleImpl getBundle(String symbolicName) {
        BundleRegistration reg = this.bundles.get(symbolicName);
        return reg == null ? null : reg.bundle;
    }

    public synchronized BundleImpl[] getInstalledBundles() {
        BundleImpl[] bundles = new BundleImpl[this.bundles.size()];
        int i = 0;
        for (BundleRegistration reg : this.bundles.values()) {
            bundles[i++] = reg.bundle;
        }
        return bundles;
    }

    public synchronized void install(BundleImpl bundle) throws BundleException {
        if (bundle.getState() == 1) {
            BundleRegistration reg = this.bundles.get(bundle.getSymbolicName());
            if (reg == null) {
                this.register(new BundleRegistration(bundle));
            } else {
                this.register(reg);
            }
        }
    }

    public synchronized void uninstall(BundleImpl bundle) throws BundleException {
        BundleRegistration reg;
        if (bundle.getState() != 1 && (reg = this.bundles.get(bundle.getSymbolicName())) != null) {
            this.unregister(reg);
        }
    }

    private void register(BundleRegistration reg) throws BundleException {
        String str = null;
        if (str != null) {
            String name = reg.bundle.getSymbolicName();
            StringTokenizer tokenizer = new StringTokenizer(str.trim(), ", \t\n\r\f");
            while (tokenizer.hasMoreTokens()) {
                BundleRegistration depReg;
                String token = tokenizer.nextToken();
                int p = token.indexOf(59);
                if (p > -1) {
                    token = token.substring(0, p).trim();
                }
                if ((depReg = this.bundles.get(token)) != null) {
                    depReg.addDependent(name);
                } else {
                    reg.addUnresolvedDependency(token);
                }
                reg.addDependency(token);
            }
        }
        if (reg.hasUnresolvedDependencies()) {
            this.doPostpone(reg);
        } else {
            this.doRegister(reg);
        }
    }

    protected void unregister(BundleRegistration reg) throws BundleException {
        reg.bundle.stop();
        reg.bundle.setUnResolved();
        this.bundles.remove(reg.bundle.getSymbolicName());
        this.bundlesById.remove(reg.bundle.getBundleId());
        reg.bundle.setUninstalled();
        if (reg.dependsOnMe != null) {
            for (String depOnMe : reg.dependsOnMe) {
                BundleRegistration depReg = this.bundles.get(depOnMe);
                if (depReg == null) continue;
                depReg.bundle.setUnResolved();
            }
        }
        reg.bundle = null;
    }

    protected void doPostpone(BundleRegistration reg) {
        String name = reg.bundle.getSymbolicName();
        log.info((Object)("Registering unresolved bundle: " + name));
        this.bundles.put(name, reg);
        this.bundlesById.put(reg.bundle.getBundleId(), reg);
        for (String dep : reg.waitingFor) {
            Set<BundleRegistration> regs = this.pendings.get(dep);
            if (regs == null) {
                regs = new HashSet<BundleRegistration>();
                this.pendings.put(dep, regs);
            }
            regs.add(reg);
        }
        reg.bundle.setInstalled();
    }

    protected void doRegister(BundleRegistration reg) throws BundleException {
        String name = reg.bundle.getSymbolicName();
        log.info((Object)("Registering resolved bundle: " + name));
        this.bundles.put(name, reg);
        this.bundlesById.put(reg.bundle.getBundleId(), reg);
        reg.bundle.setResolved();
        reg.bundle.start();
        Set<BundleRegistration> regs = this.pendings.remove(name);
        if (regs != null) {
            for (BundleRegistration pendingReg : regs) {
                pendingReg.removeUnresolvedDependency(name);
                if (pendingReg.hasUnresolvedDependencies()) continue;
                this.doRegister(pendingReg);
            }
        }
    }

    public void shutdown() {
        BundleRegistration[] regs;
        for (BundleRegistration reg : regs = this.bundles.values().toArray(new BundleRegistration[this.bundles.size()])) {
            try {
                if (reg.bundle == null) continue;
                reg.bundle.shutdown();
            }
            catch (BundleException e) {
                log.error((Object)("Failed to stop bundle " + reg.bundle.getSymbolicName()), (Throwable)e);
            }
        }
    }
}

