/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.repository.cache;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.repository.cache.DocumentModelCache;

public class DocumentChildrenList
implements DocumentModelList {
    private static final long serialVersionUID = 6370206124496509919L;
    private final List<DocumentModel> list;
    private final DocumentModelCache cache;

    public DocumentChildrenList(DocumentModelCache cache, List<DocumentModel> list) {
        this.list = list;
        this.cache = cache;
    }

    @Override
    public boolean add(DocumentModel o) {
        return this.list.add(o);
    }

    @Override
    public void add(int index, DocumentModel element) {
        this.list.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends DocumentModel> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends DocumentModel> c) {
        return this.addAll(index, c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public DocumentModel get(int index) {
        return this.cache.cacheDocument(this.list.get(index));
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<DocumentModel> iterator() {
        return this.list.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<DocumentModel> listIterator() {
        return new CachingIterator(this.list.listIterator());
    }

    @Override
    public ListIterator<DocumentModel> listIterator(int index) {
        return new CachingIterator(this.list.listIterator(index));
    }

    @Override
    public DocumentModel remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public DocumentModel set(int index, DocumentModel element) {
        return this.list.set(index, element);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public long totalSize() {
        return this.size();
    }

    @Override
    public List<DocumentModel> subList(int fromIndex, int toIndex) {
        return new DocumentChildrenList(this.cache, this.list.subList(fromIndex, toIndex));
    }

    @Override
    public Object[] toArray() {
        Object[] ar = this.list.toArray();
        for (int i = ar.length - 1; i >= 0; --i) {
            ar[i] = this.cache.cacheDocument((DocumentModel)ar[i]);
        }
        return ar;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        T[] ar = this.list.toArray(a);
        for (int i = ar.length - 1; i >= 0; --i) {
            ar[i] = this.cache.cacheDocument((DocumentModel)ar[i]);
        }
        return ar;
    }

    static class CachingIterator
    implements ListIterator<DocumentModel> {
        final ListIterator<DocumentModel> it;

        CachingIterator(ListIterator<DocumentModel> it) {
            this.it = it;
        }

        @Override
        public void add(DocumentModel o) {
            this.it.add(o);
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasPrevious();
        }

        @Override
        public DocumentModel next() {
            return this.it.next();
        }

        @Override
        public int nextIndex() {
            return this.it.nextIndex();
        }

        @Override
        public DocumentModel previous() {
            return this.it.previous();
        }

        @Override
        public int previousIndex() {
            return this.it.previousIndex();
        }

        @Override
        public void remove() {
            this.it.remove();
        }

        @Override
        public void set(DocumentModel o) {
            this.it.set(o);
        }
    }
}

