/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs;

import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.doc.JSONExporter;
import org.nuxeo.ecm.automation.server.jaxrs.ExecutableResource;
import org.nuxeo.ecm.automation.server.jaxrs.ExecutionRequest;
import org.nuxeo.ecm.automation.server.jaxrs.io.JsonMarshalling;
import org.nuxeo.runtime.api.Framework;

public class OperationResource
extends ExecutableResource {
    protected OperationType type;

    public OperationResource(AutomationService service, OperationType type) {
        super(service);
        this.type = type;
    }

    @GET
    @Produces(value={"application/json"})
    public Object doGet() {
        OperationDocumentation doc = this.type.getDocumentation();
        JSONObject json = JSONExporter.toJSON((OperationDocumentation)doc);
        return Response.ok((Object)json).type("application/json").build();
    }

    @Override
    public Object execute(ExecutionRequest xreq) throws Exception {
        OperationContext ctx = xreq.createContext(this.request, this.getCoreSession());
        Object result = this.service.run(ctx, xreq.createChain(this.type));
        if (result == null) {
            return null;
        }
        Class<?> resultClass = result.getClass();
        JsonMarshalling jm = OperationResource.marshalling();
        if (!jm.canMarshall(resultClass)) {
            return result;
        }
        JSONObject json = new JSONObject();
        json.element("entity-type", (Object)OperationResource.entityType(resultClass));
        jm.write(resultClass, json, result);
        return json;
    }

    protected static String entityType(Class<?> clazz) {
        return clazz.getSimpleName().toLowerCase();
    }

    protected static JsonMarshalling marshalling() {
        return (JsonMarshalling)Framework.getLocalService(JsonMarshalling.class);
    }

    @Override
    public String getId() {
        return this.type.getId();
    }

    @Override
    public boolean isChain() {
        return false;
    }
}

