/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ec.placeful;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ec.placeful.Annotation;
import org.nuxeo.ecm.platform.ec.placeful.DBAnnotatableDocument;
import org.nuxeo.ecm.platform.ec.placeful.ejb.interfaces.EJBPlacefulService;
import org.nuxeo.runtime.api.Framework;

public class DBAnnotatableDocumentAdapter
implements DBAnnotatableDocument {
    private final DocumentModel doc;
    private EJBPlacefulService service;

    public DBAnnotatableDocumentAdapter(DocumentModel doc) {
        this.doc = doc;
    }

    @Override
    public Object getAnnotation(String name) throws ClientException {
        EJBPlacefulService bean = this.getServiceBean();
        return bean.getAnnotation(this.doc.getId(), name);
    }

    @Override
    public void setAnnotation(String name, Object value) throws ClientException {
        EJBPlacefulService bean = this.getServiceBean();
        bean.setAnnotation((Annotation)value);
    }

    private EJBPlacefulService getServiceBean() throws ClientException {
        if (this.service == null) {
            try {
                this.service = (EJBPlacefulService)Framework.getService(EJBPlacefulService.class);
            }
            catch (Exception e) {
                throw new ClientException("Failed to get placeful service", (Throwable)e);
            }
        }
        return this.service;
    }
}

