/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Parser;
import com.google.caja.parser.js.Statement;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsMinimalPrinter;
import com.google.caja.reporting.EchoingMessageQueue;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Callback;
import com.google.caja.util.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Minify {
    public static void main(String[] jsFilePaths) throws IOException {
        List<Pair<InputSource, File>> inputs = Minify.checkInputs(jsFilePaths);
        boolean passed = Minify.minify(inputs, new PrintWriter(System.out), new PrintWriter(System.err));
        System.exit(passed ? 0 : -1);
    }

    private static List<Pair<InputSource, File>> checkInputs(String ... jsFiles) throws IOException {
        ArrayList<Pair<InputSource, File>> inputs = new ArrayList<Pair<InputSource, File>>();
        for (String jsFile : jsFiles) {
            File f = new File(jsFile);
            if (!f.canRead()) {
                throw new IOException("Cannot read " + jsFile);
            }
            InputSource is = new InputSource(f.getAbsoluteFile().toURI());
            inputs.add(Pair.pair(is, f));
        }
        return inputs;
    }

    public static boolean minify(Iterable<Pair<InputSource, File>> inputs, Writer out, PrintWriter err) throws IOException {
        MessageContext mc = new MessageContext();
        for (Pair<InputSource, File> input : inputs) {
            mc.addInputSource((InputSource)input.a);
        }
        final EchoingMessageQueue errs = new EchoingMessageQueue(err, mc, false);
        RenderContext rc = new RenderContext(new JsMinimalPrinter(new Concatenator(out, new Callback<IOException>(){

            @Override
            public void handle(IOException ex) {
                errs.addMessage((MessageTypeInt)MessageType.IO_ERROR, MessagePart.Factory.valueOf(ex.getMessage()));
            }
        })));
        for (Pair<InputSource, File> input : inputs) {
            CharProducer cp = CharProducer.Factory.create((Reader)new InputStreamReader((InputStream)new FileInputStream((File)input.b), "UTF-8"), (InputSource)input.a);
            JsLexer lexer = new JsLexer(cp);
            JsTokenQueue tq = new JsTokenQueue(lexer, (InputSource)input.a);
            Parser p = new Parser(tq, errs);
            try {
                while (!tq.isEmpty()) {
                    Block b = p.parse();
                    for (Statement statement : b.children()) {
                        statement.render(rc);
                        if (statement.isTerminal()) continue;
                        rc.getOut().consume(";");
                    }
                }
            }
            catch (ParseException ex) {
                ex.toMessageQueue(errs);
            }
        }
        rc.getOut().noMoreTokens();
        out.flush();
        MessageLevel maxMessageLevel = MessageLevel.values()[0];
        for (Message msg : errs.getMessages()) {
            if (msg.getMessageLevel().compareTo(maxMessageLevel) < 0) continue;
            maxMessageLevel = msg.getMessageLevel();
        }
        return maxMessageLevel.compareTo(MessageLevel.ERROR) < 0;
    }
}

