/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.journal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.core.journal.AbstractJournal;
import org.apache.jackrabbit.core.journal.AppendRecord;
import org.apache.jackrabbit.core.journal.FileRecordIterator;
import org.apache.jackrabbit.core.journal.FileRecordLog;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.LockableFileRevision;
import org.apache.jackrabbit.core.journal.RecordIterator;
import org.apache.jackrabbit.core.journal.RotatingLogFile;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileJournal
extends AbstractJournal {
    private static final String REVISION_NAME = "revision";
    private static final String LOG_EXTENSION = "log";
    private static final String DEFAULT_BASENAME = "journal";
    private static final int DEFAULT_MAXSIZE = 0x100000;
    private static Logger log = LoggerFactory.getLogger((Class)FileJournal.class);
    private String directory;
    private String basename;
    private int maximumSize;
    private File rootDirectory;
    private File journalFile;
    private LockableFileRevision globalRevision;

    public void init(String id, NamespaceResolver resolver) throws JournalException {
        super.init(id, resolver);
        if (this.directory == null) {
            String msg = "Directory not specified.";
            throw new JournalException(msg);
        }
        if (this.basename == null) {
            this.basename = DEFAULT_BASENAME;
        }
        if (this.maximumSize == 0) {
            this.maximumSize = 0x100000;
        }
        this.rootDirectory = new File(this.directory);
        this.rootDirectory.mkdirs();
        if (!this.rootDirectory.exists() || !this.rootDirectory.isDirectory()) {
            String msg = "Directory specified does either not exist or is not a directory: " + this.directory;
            throw new JournalException(msg);
        }
        this.journalFile = new File(this.rootDirectory, this.basename + "." + LOG_EXTENSION);
        this.globalRevision = new LockableFileRevision(new File(this.rootDirectory, REVISION_NAME));
        log.info("FileJournal initialized at path: " + this.directory);
    }

    protected long getRevision() throws JournalException {
        return this.globalRevision.get();
    }

    protected RecordIterator getRecords(long startRevision) throws JournalException {
        long stopRevision = this.getRevision();
        File[] files = null;
        if (startRevision < stopRevision) {
            RotatingLogFile[] logFiles = RotatingLogFile.listFiles(this.rootDirectory, this.basename);
            files = new File[logFiles.length];
            for (int i = 0; i < files.length; ++i) {
                files[i] = logFiles[i].getFile();
            }
        }
        return new FileRecordIterator(files, startRevision, stopRevision, this.getResolver(), this.getNamePathResolver());
    }

    protected void doLock() throws JournalException {
        this.globalRevision.lock(false);
    }

    protected void append(AppendRecord record, InputStream in, int length) throws JournalException {
        try {
            FileRecordLog recordLog = new FileRecordLog(this.journalFile);
            if (recordLog.exceeds(this.maximumSize)) {
                this.rotateLogs();
                recordLog = new FileRecordLog(this.journalFile);
            }
            if (recordLog.isNew()) {
                recordLog.init(this.globalRevision.get());
            }
            long revision = recordLog.append(this.getId(), record.getProducerId(), in, length);
            this.globalRevision.set(revision);
            record.setRevision(revision);
        }
        catch (IOException e) {
            String msg = "Unable to append new record to journal '" + this.journalFile + "'.";
            throw new JournalException(msg, e);
        }
    }

    protected void doUnlock(boolean successful) {
        this.globalRevision.unlock();
    }

    public void close() {
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getBasename() {
        return this.basename;
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public void setBasename(String basename) {
        this.basename = basename;
    }

    public void setMaximumSize(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    private void rotateLogs() {
        RotatingLogFile[] logFiles = RotatingLogFile.listFiles(this.rootDirectory, this.basename);
        for (int i = 0; i < logFiles.length; ++i) {
            logFiles[i].rotate();
        }
    }
}

